/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.drools.RuntimeDroolsException;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class TemporalEvaluatorFactoryTest
extends TestCase {
    private EvaluatorRegistry registry = new EvaluatorRegistry();

    public void testAfter() {
        this.registry.addEvaluatorDefinition("org.drools.base.evaluators.AfterEvaluatorDefinition");
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 1L, 2L);
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 4L, 3L);
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 5L, 2L);
        Object[][] data = new Object[][]{{drool, "after", foo, Boolean.TRUE}, {drool, "after", bar, Boolean.FALSE}, {bar, "after", foo, Boolean.TRUE}, {bar, "after", drool, Boolean.FALSE}, {foo, "after", drool, Boolean.FALSE}, {foo, "after", bar, Boolean.FALSE}, {foo, "not after", bar, Boolean.TRUE}, {foo, "not after", drool, Boolean.TRUE}, {bar, "not after", drool, Boolean.TRUE}, {bar, "not after", foo, Boolean.FALSE}, {drool, "not after", foo, Boolean.FALSE}, {drool, "not after", bar, Boolean.TRUE}, {bar, "after[1]", foo, Boolean.TRUE}, {bar, "after[0]", foo, Boolean.FALSE}, {bar, "after[-3]", drool, Boolean.TRUE}, {bar, "after[-4]", drool, Boolean.FALSE}, {drool, "after[2]", foo, Boolean.TRUE}, {drool, "after[1]", foo, Boolean.FALSE}, {drool, "after[-2]", bar, Boolean.TRUE}, {drool, "after[-3]", bar, Boolean.FALSE}, {foo, "after[-6]", drool, Boolean.TRUE}, {foo, "after[-7]", drool, Boolean.FALSE}, {foo, "after[-6]", bar, Boolean.TRUE}, {foo, "after[-7]", bar, Boolean.FALSE}, {bar, "not after[1]", foo, Boolean.FALSE}, {bar, "not after[0]", foo, Boolean.TRUE}, {bar, "not after[-3]", drool, Boolean.FALSE}, {bar, "not after[-4]", drool, Boolean.TRUE}, {drool, "not after[2]", foo, Boolean.FALSE}, {drool, "not after[1]", foo, Boolean.TRUE}, {drool, "not after[-2]", bar, Boolean.FALSE}, {drool, "not after[-3]", bar, Boolean.TRUE}, {foo, "not after[-6]", drool, Boolean.FALSE}, {foo, "not after[-7]", drool, Boolean.TRUE}, {foo, "not after[-6]", bar, Boolean.FALSE}, {foo, "not after[-7]", bar, Boolean.TRUE}, {drool, "after[1,4]", foo, Boolean.TRUE}, {drool, "after[3,6]", foo, Boolean.FALSE}, {drool, "after[-3,1]", bar, Boolean.TRUE}, {drool, "after[-1,3]", bar, Boolean.FALSE}, {bar, "after[1,5]", foo, Boolean.TRUE}, {bar, "after[2,5]", foo, Boolean.FALSE}, {bar, "after[-3,0]", drool, Boolean.TRUE}, {bar, "after[-2,1]", drool, Boolean.FALSE}, {foo, "after[-7,-3]", bar, Boolean.TRUE}, {foo, "after[-5,-1]", bar, Boolean.FALSE}, {foo, "after[-6,-5]", drool, Boolean.TRUE}, {foo, "after[-5,-4]", drool, Boolean.FALSE}, {drool, "not after[1,4]", foo, Boolean.FALSE}, {drool, "not after[3,6]", foo, Boolean.TRUE}, {drool, "not after[-3,1]", bar, Boolean.FALSE}, {drool, "not after[-1,3]", bar, Boolean.TRUE}, {bar, "not after[1,5]", foo, Boolean.FALSE}, {bar, "not after[2,5]", foo, Boolean.TRUE}, {bar, "not after[-3,0]", drool, Boolean.FALSE}, {bar, "not after[-2,1]", drool, Boolean.TRUE}, {foo, "not after[-7,-3]", bar, Boolean.FALSE}, {foo, "not after[-5,-1]", bar, Boolean.TRUE}, {foo, "not after[-6,-5]", drool, Boolean.FALSE}, {foo, "not after[-5,-4]", drool, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    public void testBefore() {
        this.registry.addEvaluatorDefinition("org.drools.base.evaluators.BeforeEvaluatorDefinition");
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 1L, 2L);
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 2L);
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 5L, 3L);
        Object[][] data = new Object[][]{{foo, "before", drool, Boolean.TRUE}, {foo, "before", bar, Boolean.FALSE}, {drool, "before", foo, Boolean.FALSE}, {drool, "before", bar, Boolean.FALSE}, {bar, "before", drool, Boolean.TRUE}, {bar, "before", foo, Boolean.FALSE}, {foo, "not before", drool, Boolean.FALSE}, {foo, "not before", bar, Boolean.TRUE}, {drool, "not before", foo, Boolean.TRUE}, {drool, "not before", bar, Boolean.TRUE}, {bar, "not before", drool, Boolean.FALSE}, {bar, "not before", foo, Boolean.TRUE}, {foo, "before[2]", drool, Boolean.TRUE}, {foo, "before[3]", drool, Boolean.FALSE}, {foo, "before[-1]", bar, Boolean.TRUE}, {foo, "before[-2]", bar, Boolean.FALSE}, {bar, "before[1]", drool, Boolean.TRUE}, {bar, "before[2]", drool, Boolean.FALSE}, {bar, "before[-3]", foo, Boolean.TRUE}, {bar, "before[-2]", foo, Boolean.FALSE}, {drool, "before[-6]", bar, Boolean.TRUE}, {drool, "before[-5]", bar, Boolean.FALSE}, {drool, "before[-7]", foo, Boolean.TRUE}, {drool, "before[-8]", foo, Boolean.FALSE}, {foo, "not before[2]", drool, Boolean.FALSE}, {foo, "not before[3]", drool, Boolean.TRUE}, {foo, "not before[-1]", bar, Boolean.FALSE}, {foo, "not before[-2]", bar, Boolean.TRUE}, {bar, "not before[1]", drool, Boolean.FALSE}, {bar, "not before[2]", drool, Boolean.TRUE}, {bar, "not before[-3]", foo, Boolean.FALSE}, {bar, "not before[-2]", foo, Boolean.TRUE}, {drool, "not before[-6]", bar, Boolean.FALSE}, {drool, "not before[-5]", bar, Boolean.TRUE}, {drool, "not before[-7]", foo, Boolean.FALSE}, {drool, "not before[-8]", foo, Boolean.TRUE}, {foo, "before[2,4]", drool, Boolean.TRUE}, {foo, "before[3,4]", drool, Boolean.FALSE}, {foo, "before[-1,1]", bar, Boolean.TRUE}, {foo, "before[0,-2]", bar, Boolean.FALSE}, {bar, "before[0,4]", drool, Boolean.TRUE}, {bar, "before[2,4]", drool, Boolean.FALSE}, {bar, "before[-4,0]", foo, Boolean.TRUE}, {bar, "before[-2,0]", foo, Boolean.FALSE}, {drool, "before[-6,-3]", bar, Boolean.TRUE}, {drool, "before[-5,-3]", bar, Boolean.FALSE}, {drool, "before[-7,-4]", foo, Boolean.TRUE}, {drool, "before[-6,-4]", foo, Boolean.FALSE}, {foo, "not before[2,4]", drool, Boolean.FALSE}, {foo, "not before[3,4]", drool, Boolean.TRUE}, {foo, "not before[-1,1]", bar, Boolean.FALSE}, {foo, "not before[0,-2]", bar, Boolean.TRUE}, {bar, "not before[0,4]", drool, Boolean.FALSE}, {bar, "not before[2,4]", drool, Boolean.TRUE}, {bar, "not before[-4,0]", foo, Boolean.FALSE}, {bar, "not before[-2,0]", foo, Boolean.TRUE}, {drool, "not before[-6,-3]", bar, Boolean.FALSE}, {drool, "not before[-5,-3]", bar, Boolean.TRUE}, {drool, "not before[-7,-4]", foo, Boolean.FALSE}, {drool, "not before[-6,-4]", foo, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    public void testCoincides() {
        this.registry.addEvaluatorDefinition("org.drools.base.evaluators.CoincidesEvaluatorDefinition");
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 3L);
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 3L);
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 2L, 2L);
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 1L, 2L);
        Object[][] data = new Object[][]{{foo, "coincides", bar, Boolean.TRUE}, {foo, "coincides", drool, Boolean.FALSE}, {foo, "coincides", mole, Boolean.FALSE}, {drool, "coincides", mole, Boolean.FALSE}, {foo, "not coincides", bar, Boolean.FALSE}, {foo, "not coincides", drool, Boolean.TRUE}, {foo, "not coincides", mole, Boolean.TRUE}, {drool, "not coincides", mole, Boolean.TRUE}, {foo, "coincides[1]", bar, Boolean.TRUE}, {foo, "coincides[1]", drool, Boolean.TRUE}, {foo, "coincides[2]", mole, Boolean.TRUE}, {foo, "coincides[1]", mole, Boolean.FALSE}, {drool, "coincides[1]", mole, Boolean.TRUE}, {foo, "not coincides[1]", bar, Boolean.FALSE}, {foo, "not coincides[1]", drool, Boolean.FALSE}, {foo, "not coincides[2]", mole, Boolean.FALSE}, {foo, "not coincides[1]", mole, Boolean.TRUE}, {drool, "not coincides[1]", mole, Boolean.FALSE}, {foo, "coincides[1,2]", bar, Boolean.TRUE}, {foo, "coincides[0,1]", drool, Boolean.TRUE}, {foo, "coincides[1,0]", drool, Boolean.FALSE}, {foo, "coincides[1,2]", mole, Boolean.TRUE}, {foo, "coincides[1,1]", mole, Boolean.FALSE}, {drool, "coincides[1,1]", mole, Boolean.TRUE}, {drool, "coincides[0,1]", mole, Boolean.FALSE}, {foo, "not coincides[1,2]", bar, Boolean.FALSE}, {foo, "not coincides[0,1]", drool, Boolean.FALSE}, {foo, "not coincides[1,0]", drool, Boolean.TRUE}, {foo, "not coincides[1,2]", mole, Boolean.FALSE}, {foo, "not coincides[1,1]", mole, Boolean.TRUE}, {drool, "not coincides[1,1]", mole, Boolean.FALSE}, {drool, "not coincides[0,1]", mole, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    private void runEvaluatorTest(Object[][] data, ValueType valueType) {
        MockExtractor extractor = new MockExtractor();
        for (int i = 0; i < data.length; ++i) {
            Object[] row = data[i];
            boolean isNegated = ((String)row[1]).startsWith("not ");
            String evaluatorStr = isNegated ? ((String)row[1]).substring(4) : (String)row[1];
            boolean isConstrained = evaluatorStr.endsWith("]");
            String parameters = null;
            if (isConstrained) {
                parameters = evaluatorStr.split("\\[")[1];
                evaluatorStr = evaluatorStr.split("\\[")[0];
                parameters = parameters.split("\\]")[0];
            }
            EvaluatorDefinition evalDef = this.registry.getEvaluatorDefinition(evaluatorStr);
            TemporalEvaluatorFactoryTest.assertNotNull((Object)evalDef);
            Evaluator evaluator = evalDef.getEvaluator(valueType, evaluatorStr, isNegated, parameters);
            this.checkEvaluatorMethodWith2Extractors(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodCachedRight(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodCachedLeft(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodWithFieldValue(valueType, extractor, row, evaluator);
            TemporalEvaluatorFactoryTest.assertEquals((Object)valueType, (Object)evaluator.getValueType());
        }
    }

    private void checkEvaluatorMethodWith2Extractors(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        boolean result = evaluator.evaluate(null, extractor, row[0], extractor, row[2]);
        String message = "The evaluator type: [" + valueType + "] with 2 extractors incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            TemporalEvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            TemporalEvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodCachedRight(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        VariableRestriction.VariableContextEntry context = this.getContextEntry(evaluator, extractor, valueType, row);
        boolean result = evaluator.evaluateCachedRight(null, context, row[2]);
        String message = "The evaluator type: [" + valueType + "] with CachedRight incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            TemporalEvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            TemporalEvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodCachedLeft(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        VariableRestriction.VariableContextEntry context = this.getContextEntry(evaluator, extractor, valueType, row);
        boolean result = evaluator.evaluateCachedLeft(null, context, row[0]);
        String message = "The evaluator type: [" + valueType + "] with CachedLeft incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            TemporalEvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            TemporalEvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodWithFieldValue(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        FieldValue value = FieldFactory.getFieldValue((Object)row[2]);
        RuntimeDroolsException exc = null;
        try {
            boolean result = evaluator.evaluate(null, extractor, row[0], value);
        }
        catch (RuntimeDroolsException e) {
            exc = e;
        }
        TemporalEvaluatorFactoryTest.assertNotNull((Object)((Object)exc));
    }

    private VariableRestriction.VariableContextEntry getContextEntry(Evaluator evaluator, InternalReadAccessor extractor, ValueType valueType, Object[] row) {
        Declaration declaration = new Declaration("test", extractor, null);
        ValueType coerced = evaluator.getCoercedValueType();
        if (coerced.isIntegerNumber()) {
            VariableRestriction.LongVariableContextEntry context = new VariableRestriction.LongVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Number)row[2]).longValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Number)row[0]).longValue();
            }
            return context;
        }
        if (coerced.isChar()) {
            VariableRestriction.CharVariableContextEntry context = new VariableRestriction.CharVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Character)row[2]).charValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Character)row[0]).charValue();
            }
            return context;
        }
        if (coerced.isBoolean()) {
            VariableRestriction.BooleanVariableContextEntry context = new VariableRestriction.BooleanVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = (Boolean)row[2];
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = (Boolean)row[0];
            }
            return context;
        }
        if (coerced.isFloatNumber()) {
            VariableRestriction.DoubleVariableContextEntry context = new VariableRestriction.DoubleVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Number)row[2]).doubleValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Number)row[0]).doubleValue();
            }
            return context;
        }
        VariableRestriction.ObjectVariableContextEntry context = new VariableRestriction.ObjectVariableContextEntry(extractor, declaration, evaluator);
        if (row[2] == null) {
            context.leftNull = true;
        } else {
            context.left = row[2];
        }
        if (row[0] == null) {
            context.rightNull = true;
        } else {
            context.right = row[0];
        }
        return context;
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        private static final long serialVersionUID = 400L;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? (Boolean)object : false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).byteValue() : (byte)0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Character)object).charValue() : (char)'\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).doubleValue() : 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).floatValue() : 0.0f;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).intValue() : 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).longValue() : 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).shortValue() : (short)0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return object;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return object == null;
        }

        public ValueType getValueType() {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }
    }
}

