/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.persistence.Persister;
import org.drools.persistence.session.MemoryPersisterManager;
import org.drools.process.core.Work;
import org.drools.process.core.impl.WorkImpl;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.WorkItemNode;

public class MemoryPersistenceManagerTest
extends TestCase {
    private Map<Long, WorkItem> workItems = new HashMap<Long, WorkItem>();

    public void testProcessPersistence() {
        MemoryPersisterManager manager = new MemoryPersisterManager();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("org.drools.test");
        pkg.addProcess((Process)this.getProcess());
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        Persister persister = manager.getSessionPersister(session);
        session.getWorkItemManager().registerWorkItemHandler("MyWork", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                MemoryPersistenceManagerTest.this.workItems.put(workItem.getProcessInstanceId(), workItem);
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        ProcessInstance processInstance = session.startProcess("org.drools.test.TestProcess");
        long processInstanceId = processInstance.getId();
        persister.setUniqueId(processInstanceId + "");
        persister.save();
        persister = manager.getSessionPersister(processInstanceId + "", ruleBase);
        session = (StatefulSession)persister.getObject();
        processInstance = session.getProcessInstance(processInstanceId);
        MemoryPersistenceManagerTest.assertEquals((int)1, (int)processInstance.getState());
        session.getWorkItemManager().completeWorkItem(this.workItems.get(processInstanceId).getId(), null);
        MemoryPersistenceManagerTest.assertEquals((int)2, (int)processInstance.getState());
        persister.save();
        persister = manager.getSessionPersister(processInstanceId + "", ruleBase);
        session = (StatefulSession)persister.getObject();
        processInstance = session.getProcessInstance(processInstanceId);
        MemoryPersistenceManagerTest.assertNull((Object)processInstance);
    }

    private RuleFlowProcess getProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setMetaData("Action", (Object)new Action(){

            public void execute(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory, ProcessContext context) throws Exception {
                System.out.println("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        return process;
    }
}

