/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.persistence.ByteArraySnapshotter;
import org.drools.persistence.Transaction;
import org.drools.persistence.memory.MemoryPersister;
import org.drools.persistence.session.StatefulSessionSnapshotter;
import org.drools.process.core.Work;
import org.drools.process.core.impl.WorkImpl;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.WorkItemNode;

public class MemoryPersisterProcessTest
extends TestCase {
    private WorkItem workItem;

    public void testSave() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("org.drools.test");
        pkg.addProcess((Process)this.getProcess());
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.getWorkItemManager().registerWorkItemHandler("MyWork", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                MemoryPersisterProcessTest.this.workItem = workItem;
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        ProcessInstance processInstance = session.startProcess("org.drools.test.TestProcess");
        MemoryPersisterProcessTest.assertNotNull((Object)this.workItem);
        MemoryPersister pm = new MemoryPersister((ByteArraySnapshotter)new StatefulSessionSnapshotter(session));
        pm.save();
        session.getWorkItemManager().completeWorkItem(this.workItem.getId(), null);
        MemoryPersisterProcessTest.assertEquals((int)2, (int)processInstance.getState());
        pm.load();
        processInstance = session.getProcessInstance(processInstance.getId());
        MemoryPersisterProcessTest.assertNotNull((Object)processInstance);
        MemoryPersisterProcessTest.assertEquals((int)1, (int)processInstance.getState());
        session.getWorkItemManager().completeWorkItem(this.workItem.getId(), null);
        MemoryPersisterProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testTransactionWithRollback() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("org.drools.test");
        pkg.addProcess((Process)this.getProcess());
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.getWorkItemManager().registerWorkItemHandler("MyWork", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                MemoryPersisterProcessTest.this.workItem = workItem;
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        ProcessInstance processInstance = session.startProcess("org.drools.test.TestProcess");
        MemoryPersister pm = new MemoryPersister((ByteArraySnapshotter)new StatefulSessionSnapshotter(session));
        Transaction t = pm.getTransaction();
        t.start();
        session.getWorkItemManager().completeWorkItem(this.workItem.getId(), null);
        MemoryPersisterProcessTest.assertEquals((int)2, (int)processInstance.getState());
        t.rollback();
        processInstance = session.getProcessInstance(processInstance.getId());
        MemoryPersisterProcessTest.assertNotNull((Object)processInstance);
        MemoryPersisterProcessTest.assertEquals((int)1, (int)processInstance.getState());
        session.getWorkItemManager().completeWorkItem(this.workItem.getId(), null);
        MemoryPersisterProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    private RuleFlowProcess getProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setMetaData("Action", (Object)new Action(){

            public void execute(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory, ProcessContext context) throws Exception {
                System.out.println("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        return process;
    }

    public boolean assertEquals(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

