/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.persistence.ByteArraySnapshotter;
import org.drools.persistence.Transaction;
import org.drools.persistence.memory.MemoryPersister;
import org.drools.persistence.session.StatefulSessionSnapshotter;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public class MemoryPersisterSessionTest
extends TestCase {
    private byte[] data1 = new byte[]{1, 1, 1, 1, 1};
    private byte[] data2 = new byte[]{1, 1, 1, 1, 0};
    private byte[] data3 = new byte[]{1, 1, 1, 0, 0};
    ClassFieldAccessorStore store;

    public void testSave() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("org.drools.test");
        pkg.addGlobal("list", List.class);
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store = pkg.getClassFieldAccessorStore();
        this.store.setEagerWire(true);
        pkg.addRule(this.getFindPersonRule());
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p1 = new Person("boba fet", 500);
        session.insert((Object)p1);
        MemoryPersister pm = new MemoryPersister((ByteArraySnapshotter)new StatefulSessionSnapshotter(session));
        pm.save();
        Person p2 = new Person("boba fet", 500);
        Person p3 = new Person("boba fet", 500);
        session.insert((Object)p2);
        session.insert((Object)p3);
        session.insert((Object)new String("boba fet"));
        MemoryPersisterSessionTest.assertEquals((int)4, (int)((InternalWorkingMemory)session).getObjectStore().size());
        session.fireAllRules();
        MemoryPersisterSessionTest.assertEquals((int)3, (int)list.size());
        pm.load();
        list.clear();
        session.insert((Object)new String("boba fet"));
        session.fireAllRules();
        MemoryPersisterSessionTest.assertEquals((int)1, (int)list.size());
        MemoryPersisterSessionTest.assertEquals((int)2, (int)((InternalWorkingMemory)session).getObjectStore().size());
    }

    public void testTransactionWithRollback() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("org.drools.test");
        pkg.addGlobal("list", List.class);
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store = pkg.getClassFieldAccessorStore();
        this.store.setEagerWire(true);
        pkg.addRule(this.getFindPersonRule());
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p1 = new Person("boba fet", 500);
        session.insert((Object)p1);
        MemoryPersister pm = new MemoryPersister((ByteArraySnapshotter)new StatefulSessionSnapshotter(session));
        Transaction t = pm.getTransaction();
        t.start();
        Person p2 = new Person("boba fet", 500);
        Person p3 = new Person("boba fet", 500);
        session.insert((Object)p2);
        session.insert((Object)p3);
        session.insert((Object)new String("boba fet"));
        MemoryPersisterSessionTest.assertEquals((int)4, (int)((InternalWorkingMemory)session).getObjectStore().size());
        session.fireAllRules();
        MemoryPersisterSessionTest.assertEquals((int)3, (int)list.size());
        t.rollback();
        list.clear();
        session.insert((Object)new String("boba fet"));
        session.fireAllRules();
        MemoryPersisterSessionTest.assertEquals((int)1, (int)list.size());
        MemoryPersisterSessionTest.assertEquals((int)2, (int)((InternalWorkingMemory)session).getObjectStore().size());
    }

    private Rule getFindPersonRule() throws IntrospectionException, InvalidRuleException {
        ClassObjectType stringType = new ClassObjectType(String.class);
        ClassObjectType personType = new ClassObjectType(Person.class);
        Rule rule = new Rule("find person");
        Pattern stringPattern = new Pattern(0, (ObjectType)stringType, "$s");
        rule.addPattern((RuleConditionElement)stringPattern);
        Declaration sDeclaration = rule.getDeclaration("$s");
        Pattern personPattern = new Pattern(1, (ObjectType)personType, "$p");
        EqualityEvaluatorsDefinition evals = new EqualityEvaluatorsDefinition();
        Evaluator eval = evals.getEvaluator(ValueType.OBJECT_TYPE, Operator.EQUAL, null);
        personPattern.addConstraint((Constraint)this.getBoundVariableConstraint(personPattern, "name", sDeclaration, eval));
        rule.addPattern((RuleConditionElement)personPattern);
        final Declaration pDeclaration = rule.getDeclaration("$p");
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    Person p = (Person)drools.get(pDeclaration);
                    List list = (List)workingMemory.getGlobal("list");
                    list.add(p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    public boolean assertEquals(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    private BetaNodeFieldConstraint getBoundVariableConstraint(Pattern pattern, String fieldName, Declaration declaration, Evaluator evaluator) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, ((Object)((Object)this)).getClass().getClassLoader());
        return new VariableConstraint((InternalReadAccessor)extractor, declaration, evaluator);
    }
}

