/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.field.LongFieldImpl;
import org.drools.base.field.ObjectFieldImpl;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooFactHandleFactory;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.PredicateConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.PropagationContext;

public class CompositeObjectSinkAdapterTest
extends TestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EqualityEvaluatorsDefinition equals = new EqualityEvaluatorsDefinition();
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    public int la;
    public int blah;
    public String wah;

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
    }

    public void testBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), null, null);
        ad.addObjectSink((ObjectSink)beta);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.getSinks().length);
        CompositeObjectSinkAdapterTest.assertEquals((Object)((Object)beta), (Object)ad.getSinks()[0]);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.otherSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)((Object)beta), (Object)ad.otherSinks.getFirst());
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashableSinks);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashedFieldIndexes);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashedSinkMap);
        ad.removeObjectSink((ObjectSink)beta);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertEquals((int)0, (int)ad.getSinks().length);
    }

    public void testAlphaWithPredicate() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)new PredicateConstraint(null, null), null, this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.getSinks().length);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.otherSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)al, (Object)ad.otherSinks.getFirst());
        ad.removeObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertEquals((int)0, (int)ad.getSinks().length);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
    }

    public void testSingleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)new MockExtractor(), this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashedFieldIndexes);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        ad.removeObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashableSinks);
    }

    public void testDoubleAlphaWithBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)new MockExtractor(), this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashedFieldIndexes);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)new MockExtractor(), this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"cheddar"));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        CompositeObjectSinkAdapterTest.assertEquals((Object)al2, (Object)ad.getSinks()[1]);
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), null, null);
        ad.addObjectSink((ObjectSink)beta);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.otherSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)((Object)beta), (Object)ad.otherSinks.getFirst());
        ad.removeObjectSink((ObjectSink)beta);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
    }

    public void testTripleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashedFieldIndexes);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"cheddar"));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashedSinkMap);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stinky"));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashedSinkMap);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashableSinks);
        ad.removeObjectSink((ObjectSink)al2);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashableSinks);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashedSinkMap);
    }

    public void testTripleAlphaCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charType", ((Object)((Object)this)).getClass().getClassLoader());
        LiteralConstraint lit = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(65L));
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.otherSinks);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashedFieldIndexes);
        CompositeObjectSinkAdapterTest.assertEquals((int)1, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(66L));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashedSinkMap);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(extractor.getValueType(), Operator.EQUAL), (FieldValue)new LongFieldImpl(67L));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashedSinkMap);
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashableSinks);
        Cheese cheese = new Cheese();
        cheese.setCharType('B');
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        CompositeObjectSinkAdapterTest.assertSame((Object)al2, (Object)sink);
        cheese.setCharType('X');
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        CompositeObjectSinkAdapterTest.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        CompositeObjectSinkAdapterTest.assertNotNull((Object)ad.hashableSinks);
        CompositeObjectSinkAdapterTest.assertEquals((int)2, (int)ad.hashableSinks.size());
        CompositeObjectSinkAdapterTest.assertNull((Object)ad.hashedSinkMap);
    }

    public void testPropagationWithNullValue() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        LiteralConstraint lit1 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"stilton"));
        AlphaNode al1 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit1, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        LiteralConstraint lit2 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"brie"));
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        LiteralConstraint lit3 = new LiteralConstraint((InternalReadAccessor)extractor, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL), (FieldValue)new ObjectFieldImpl((Object)"muzzarela"));
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al1);
        ad.addObjectSink((ObjectSink)al2);
        ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null);
        try {
            ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            CompositeObjectSinkAdapterTest.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    static class MockBetaNode
    extends BetaNode {
        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput) {
            super(id, RuleBasePartitionId.MAIN_PARTITION, false, leftInput, rightInput, EmptyBetaConstraints.getInstance(), Behavior.EMPTY_BEHAVIOR_LIST);
        }

        public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int getIndex() {
            return 0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public boolean isNullValue(Object object, InternalWorkingMemory workingMemory) {
            return false;
        }

        public ValueType getValueType() {
            return ValueType.STRING_TYPE;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }
    }
}

