/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.drools.DroolsTestCase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.Rule;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.MockConstraint;
import org.drools.spi.PropagationContext;

public class JoinNodeTest
extends DroolsTestCase {
    Rule rule;
    PropagationContext context;
    ReteooWorkingMemory workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    BetaNode node;
    BetaMemory memory;
    MockConstraint constraint = new MockConstraint();

    public void setUp() {
        this.rule = new Rule("test-rule");
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        this.workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        this.tupleSource = new MockTupleSource(4);
        this.objectSource = new MockObjectSource(4);
        this.sink = new MockLeftTupleSink();
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.node = new JoinNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, configuration), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
        JoinNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        JoinNodeTest.assertEquals((int)0, (int)this.memory.getRightTupleMemory().size());
    }

    public void testAttach() throws Exception {
        Field objectFfield = ObjectSource.class.getDeclaredField("sink");
        objectFfield.setAccessible(true);
        ObjectSinkPropagator objectSink = (ObjectSinkPropagator)objectFfield.get((Object)this.objectSource);
        Field tupleField = LeftTupleSource.class.getDeclaredField("sink");
        tupleField.setAccessible(true);
        LeftTupleSinkPropagator tupleSink = (LeftTupleSinkPropagator)tupleField.get((Object)this.tupleSource);
        JoinNodeTest.assertEquals((int)15, (int)this.node.getId());
        JoinNodeTest.assertNotNull((Object)objectSink);
        JoinNodeTest.assertNotNull((Object)tupleSink);
        this.node.attach();
        objectSink = (ObjectSinkPropagator)objectFfield.get((Object)this.objectSource);
        tupleSink = (LeftTupleSinkPropagator)tupleField.get((Object)this.tupleSource);
        JoinNodeTest.assertEquals((int)1, (int)objectSink.getSinks().length);
        JoinNodeTest.assertEquals((int)1, (int)tupleSink.getSinks().length);
        JoinNodeTest.assertSame((Object)this.node, (Object)objectSink.getSinks()[0]);
        JoinNodeTest.assertSame((Object)this.node, (Object)tupleSink.getSinks()[0]);
    }

    public void testMemory() {
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        MockObjectSource objectSource = new MockObjectSource(1);
        MockTupleSource tupleSource = new MockTupleSource(1);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        JoinNode joinNode = new JoinNode(2, (LeftTupleSource)tupleSource, (ObjectSource)objectSource, EmptyBetaConstraints.getInstance(), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((NodeMemory)joinNode);
        JoinNodeTest.assertNotNull((Object)memory);
    }

    public void testAssertTuple() throws Exception {
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"cheese");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)1, (int)this.memory.getLeftTupleMemory().size());
        JoinNodeTest.assertEquals((int)0, (int)this.memory.getRightTupleMemory().size());
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)2, (int)this.memory.getLeftTupleMemory().size());
        LeftTuple leftTuple = this.memory.getLeftTupleMemory().getFirst(null);
        JoinNodeTest.assertEquals((Object)tuple1, (Object)leftTuple);
        JoinNodeTest.assertEquals((Object)tuple0, (Object)leftTuple.getNext());
    }

    public void testAssertTupleSequentialMode() throws Exception {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        this.workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf)));
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        buildContext.setObjectTypeNodeMemoryEnabled(false);
        this.node = new JoinNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, conf), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"cheese");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)1, (int)this.sink.getAsserted().size());
        JoinNodeTest.assertNull((Object)this.memory.getLeftTupleMemory());
        JoinNodeTest.assertEquals((int)1, (int)this.memory.getRightTupleMemory().size());
        JoinNodeTest.assertEquals((Object)new LeftTuple(tuple0, f0.getRightTuple(), (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
    }

    public void testAssertObject() throws Exception {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        JoinNodeTest.assertEquals((int)1, (int)this.memory.getRightTupleMemory().size());
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)"test1");
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)2, (int)this.memory.getRightTupleMemory().size());
        RightTuple rightTuple = this.memory.getRightTupleMemory().getFirst(new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true));
        InternalFactHandle rf1 = rightTuple.getFactHandle();
        InternalFactHandle rf0 = ((RightTuple)rightTuple.getNext()).getFactHandle();
        JoinNodeTest.assertEquals((Object)f0, (Object)rf0);
        JoinNodeTest.assertEquals((Object)f1, (Object)rf1);
    }

    public void testAssertPropagations() throws Exception {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)1, (int)this.sink.getAsserted().size());
        JoinNodeTest.assertEquals((Object)new LeftTuple(tuple1, f0.getRightTuple(), (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        DefaultFactHandle f2 = new DefaultFactHandle(2, (Object)"cheese");
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)f2, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)2, (int)this.sink.getAsserted().size());
        JoinNodeTest.assertEquals((Object)new LeftTuple(tuple2, f0.getRightTuple(), (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(1))[0]);
        DefaultFactHandle f3 = (DefaultFactHandle)this.workingMemory.insert((Object)"test2");
        this.node.assertObject((InternalFactHandle)f3, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)4, (int)this.sink.getAsserted().size());
        ArrayList<Object> tuples = new ArrayList<Object>();
        tuples.add(((Object[])this.sink.getAsserted().get(2))[0]);
        tuples.add(((Object[])this.sink.getAsserted().get(3))[0]);
        JoinNodeTest.assertTrue((boolean)tuples.contains(new LeftTuple(tuple1, f3.getRightTuple(), (LeftTupleSink)this.sink, true)));
        JoinNodeTest.assertTrue((boolean)tuples.contains(new LeftTuple(tuple2, f3.getRightTuple(), (LeftTupleSink)this.sink, true)));
    }

    public void testRetractTuple() throws Exception {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)"test1");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)"test2");
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)f2, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f3 = (DefaultFactHandle)this.workingMemory.insert((Object)"test3");
        this.node.assertObject((InternalFactHandle)f3, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f4 = (DefaultFactHandle)this.workingMemory.insert((Object)"test4");
        this.node.assertObject((InternalFactHandle)f4, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(6, this.sink.getAsserted());
        BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
        JoinNodeTest.assertTrue((boolean)memory.getRightTupleMemory().contains(f0.getRightTuple()));
        this.node.retractRightTuple(f0.getRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(2, this.sink.getRetracted());
        ArrayList<Object> tuples = new ArrayList<Object>();
        tuples.add(((Object[])this.sink.getRetracted().get(0))[0]);
        tuples.add(((Object[])this.sink.getRetracted().get(1))[0]);
        JoinNodeTest.assertTrue((boolean)tuples.contains(new LeftTuple(tuple1, f0.getRightTuple(), (LeftTupleSink)this.sink, true)));
        JoinNodeTest.assertTrue((boolean)tuples.contains(new LeftTuple(tuple1, f0.getRightTuple(), (LeftTupleSink)this.sink, true)));
        JoinNodeTest.assertFalse((boolean)memory.getRightTupleMemory().contains(f0.getRightTuple()));
        this.node.retractLeftTuple(tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        JoinNodeTest.assertEquals((int)4, (int)this.sink.getRetracted().size());
        tuples = new ArrayList();
        tuples.add(((Object[])this.sink.getRetracted().get(2))[0]);
        tuples.add(((Object[])this.sink.getRetracted().get(3))[0]);
        JoinNodeTest.assertTrue((boolean)tuples.contains(new LeftTuple(tuple2, f3.getRightTuple(), (LeftTupleSink)this.sink, true)));
        JoinNodeTest.assertTrue((boolean)tuples.contains(new LeftTuple(tuple2, f4.getRightTuple(), (LeftTupleSink)this.sink, true)));
    }

    public void testConstraintPropagations() throws Exception {
        this.constraint.isAllowed = false;
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getAsserted());
        this.node.retractRightTuple(f0.getRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getRetracted());
    }

    public void testUpdateSink() {
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        JoinNode joinNode = new JoinNode(1, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, EmptyBetaConstraints.getInstance(), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        MockLeftTupleSink sink1 = new MockLeftTupleSink(2);
        joinNode.addTupleSink((LeftTupleSink)sink1);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"string0");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        joinNode.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)workingMemory);
        String string1 = "string1";
        DefaultFactHandle string1Handle = new DefaultFactHandle(1, (Object)"string1");
        joinNode.assertObject((InternalFactHandle)string1Handle, this.context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink1.getAsserted());
        MockLeftTupleSink sink2 = new MockLeftTupleSink(3);
        this.assertLength(0, sink2.getAsserted());
        joinNode.updateSink((LeftTupleSink)sink2, this.context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink2.getAsserted());
    }
}

