/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.agent.AgentEventListener;
import org.drools.agent.MockProvider;
import org.drools.agent.MockRuleAgent;
import org.drools.agent.RuleAgent;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.agent.URLScanner;
import org.drools.common.InternalRuleBase;
import org.drools.rule.Package;

public class RuleAgentTest
extends TestCase {
    public void testLists() {
        String s = "\tfoo.bar\n baz.bar\t whee ";
        List result = RuleAgent.list((String)s);
        RuleAgentTest.assertEquals((int)3, (int)result.size());
        RuleAgentTest.assertEquals((Object)"foo.bar", result.get(0));
        RuleAgentTest.assertEquals((Object)"baz.bar", result.get(1));
        RuleAgentTest.assertEquals((Object)"whee", result.get(2));
        s = null;
        result = RuleAgent.list((String)s);
        RuleAgentTest.assertNotNull((Object)result);
        RuleAgentTest.assertEquals((int)0, (int)result.size());
        s = "\"yeah man\" \"another one\"";
        result = RuleAgent.list((String)s);
        RuleAgentTest.assertEquals((int)2, (int)result.size());
        RuleAgentTest.assertEquals((Object)"yeah man", result.get(0));
        RuleAgentTest.assertEquals((Object)"another one", result.get(1));
        s = "\"yeah man\"";
        result = RuleAgent.list((String)s);
        RuleAgentTest.assertEquals((int)1, (int)result.size());
        RuleAgentTest.assertEquals((Object)"yeah man", result.get(0));
        s = "YEAH";
        result = RuleAgent.list((String)s);
        RuleAgentTest.assertEquals((int)1, (int)result.size());
        RuleAgentTest.assertEquals((Object)"YEAH", result.get(0));
    }

    public void testFiles() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p1.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p2.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p1.pkg " + dir.getPath() + "/" + "p2.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleBase rb = ag.getRuleBase();
        RuleAgentTest.assertNotNull((Object)rb);
        RuleAgentTest.assertEquals((int)2, (int)rb.getPackages().length);
        RuleAgentTest.assertFalse((boolean)ag.isPolling());
        props.setProperty("poll", "1");
        ag = RuleAgent.newRuleAgent((Properties)props);
        RuleAgentTest.assertTrue((boolean)ag.isPolling());
        ag.stopPolling();
        RuleAgentTest.assertFalse((boolean)ag.isPolling());
    }

    public void testPollingFilesRuleBaseUpdate() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Random rnd = new Random(System.currentTimeMillis());
        Package p1 = new Package("p1");
        File p1f = new File(dir, rnd.nextLong() + ".pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        String path = p1f.getPath();
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleBase rb = ag.getRuleBase();
        RuleAgentTest.assertEquals((int)1, (int)rb.getPackages().length);
        RuleAgentTest.assertEquals((int)0, (int)rb.getPackages()[0].getGlobals().size());
        p1.addGlobal("goo", String.class);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        RuleBase rb_ = ag.getRuleBase();
        RuleAgentTest.assertSame((Object)rb, (Object)rb_);
        RuleAgentTest.assertEquals((int)1, (int)rb.getPackages().length);
        RuleAgentTest.assertEquals((int)0, (int)rb.getPackages()[0].getGlobals().size());
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleBase rb2 = ag.getRuleBase();
        RuleAgentTest.assertSame((Object)rb, (Object)rb2);
        RuleAgentTest.assertEquals((int)1, (int)rb2.getPackages().length);
        RuleAgentTest.assertEquals((int)1, (int)rb2.getPackages()[0].getGlobals().size());
        p1.addGlobal("goo2", String.class);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleBase rb2_ = ag.getRuleBase();
        RuleAgentTest.assertSame((Object)rb2_, (Object)rb2);
        RuleAgentTest.assertEquals((int)1, (int)rb2_.getPackages().length);
        RuleAgentTest.assertEquals((int)2, (int)rb2_.getPackages()[0].getGlobals().size());
        ag.refreshRuleBase();
        RuleBase rb3 = ag.getRuleBase();
        RuleAgentTest.assertSame((Object)rb3, (Object)rb2);
        RuleAgentTest.assertEquals((int)1, (int)rb3.getPackages().length);
        RuleAgentTest.assertEquals((int)2, (int)rb3.getPackages()[0].getGlobals().size());
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleAgentTest.assertEquals((int)1, (int)rb3.getPackages().length);
        RuleAgentTest.assertEquals((int)2, (int)rb3.getPackages()[0].getGlobals().size());
    }

    public void testPollingFilesRuleBaseReplace() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "true");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleAgentTest.assertTrue((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        RuleAgentTest.assertEquals((int)2, (int)rb.getPackages().length);
        RuleBase rb_ = ag.getRuleBase();
        RuleAgentTest.assertSame((Object)rb, (Object)rb_);
        ag.refreshRuleBase();
        RuleAgentTest.assertSame((Object)rb, (Object)ag.getRuleBase());
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        rb_ = ag.getRuleBase();
        RuleAgentTest.assertNotSame((Object)rb, (Object)rb_);
        RuleAgentTest.assertEquals((int)2, (int)rb_.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleBase rb__ = ag.getRuleBase();
        RuleAgentTest.assertSame((Object)rb_, (Object)rb__);
    }

    public void testPollingFilesRuleBaseRemoveNewInstanceFalse() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "false");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleAgentTest.assertFalse((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        RuleAgentTest.assertEquals((int)2, (int)rb.getPackages().length);
        boolean success = p2f.delete();
        RuleAgentTest.assertTrue((boolean)success);
        ag.refreshRuleBase();
        RuleAgentTest.assertEquals((int)1, (int)rb.getPackages().length);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleAgentTest.assertEquals((int)1, (int)rb.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleAgentTest.assertEquals((int)1, (int)rb.getPackages().length);
    }

    public void testPollingFilesRuleBaseRemoveNewInstanceTrue() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Package p2 = new Package("p2");
        File p2f = new File(dir, "p44_.pkg");
        RuleBaseAssemblerTest.writePackage(p2, p2f);
        String path = dir.getPath() + "/" + "p43_.pkg " + dir.getPath() + "/p44_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("newInstance", "true");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        RuleAgentTest.assertTrue((boolean)ag.isNewInstance());
        RuleBase rb = ag.getRuleBase();
        RuleAgentTest.assertEquals((int)2, (int)rb.getPackages().length);
        boolean success = p2f.delete();
        RuleAgentTest.assertTrue((boolean)success);
        ag.refreshRuleBase();
        RuleBase rb_ = ag.getRuleBase();
        RuleAgentTest.assertNotSame((Object)rb, (Object)rb_);
        RuleAgentTest.assertEquals((int)1, (int)rb_.getPackages().length);
        Thread.sleep(1000L);
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Thread.sleep(1000L);
        ag.refreshRuleBase();
        RuleBase rb__ = ag.getRuleBase();
        RuleAgentTest.assertNotSame((Object)rb, (Object)rb__);
        RuleAgentTest.assertEquals((int)1, (int)rb__.getPackages().length);
        ag.refreshRuleBase();
        ag.refreshRuleBase();
        RuleBase rb___ = ag.getRuleBase();
        RuleAgentTest.assertEquals((int)1, (int)rb___.getPackages().length);
    }

    public void testDirectory() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p43_.pkg");
        File junk = new File(dir, "xxx.poo");
        FileOutputStream ojunk = new FileOutputStream(junk);
        ojunk.write("ignore me".getBytes());
        ojunk.flush();
        ojunk.close();
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        Properties props = new Properties();
        props.setProperty("dir", dir.getPath());
        props.setProperty("name", "goo");
        RuleAgent ag = RuleAgent.newRuleAgent((Properties)props);
        ag.refreshRuleBase();
        RuleBase rb = ag.getRuleBase();
        RuleAgentTest.assertNotNull((Object)rb);
    }

    public void testCustomRuleBaseConfiguration() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Random rnd = new Random(System.currentTimeMillis());
        Package p1 = new Package("p1");
        File p1f = new File(dir, rnd.nextLong() + ".pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        String path = p1f.getPath();
        Properties props = new Properties();
        props.setProperty("file", path);
        RuleAgent agent = RuleAgent.newRuleAgent((Properties)props);
        RuleBaseConfiguration conf = ((InternalRuleBase)agent.getRuleBase()).getConfiguration();
        RuleAgentTest.assertEquals((boolean)false, (boolean)conf.isSequential());
        conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        agent = RuleAgent.newRuleAgent((Properties)props, (RuleBaseConfiguration)conf);
        conf = ((InternalRuleBase)agent.getRuleBase()).getConfiguration();
        RuleAgentTest.assertEquals((boolean)true, (boolean)conf.isSequential());
    }

    public void testLoadSampleConfig() {
        RuleAgent ag = new RuleAgent(new RuleBaseConfiguration());
        Properties props = RuleAgent.loadFromProperties((String)"/sample-agent-config.properties");
        RuleAgentTest.assertEquals((String)"10", (String)props.getProperty("poll"));
        RuleAgentTest.assertEquals((String)"/home/packages", (String)props.getProperty("dir"));
        RuleAgentTest.assertEquals((String)"true", (String)props.getProperty("newInstance"));
        this.assertEqualsIgnoreWhitespace("/foo/bar.pkg /wee/waa.pkg /wee/waa2.pkg", props.getProperty("file"));
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        RuleAgentTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    public void testEventListenerSetup() throws Exception {
        RuleAgent ag = new RuleAgent(new RuleBaseConfiguration());
        RuleAgentTest.assertNotNull((Object)ag.listener);
        final String[] name = new String[1];
        AgentEventListener list = new AgentEventListener(){

            public void debug(String message) {
            }

            public void exception(Exception e) {
            }

            public void info(String message) {
            }

            public void warning(String message) {
            }

            public void setAgentName(String n) {
                name[0] = n;
            }

            public void debug(String message, Object object) {
            }

            public void info(String message, Object object) {
            }

            public void warning(String message, Object object) {
            }
        };
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("p1");
        File p1f = new File(dir, "p42_.pkg");
        RuleBaseAssemblerTest.writePackage(p1, p1f);
        String path = dir.getPath() + "/" + "p42_.pkg";
        Properties props = new Properties();
        props.setProperty("file", path);
        props.setProperty("poll", "1");
        props.setProperty("name", "poo");
        ag = RuleAgent.newRuleAgent((Properties)props, (AgentEventListener)list);
        RuleAgentTest.assertEquals((Object)list, (Object)ag.listener);
        RuleAgentTest.assertEquals((String)"poo", (String)name[0]);
        ag.stopPolling();
    }

    public void testPollSetup() throws Exception {
        Properties props = new Properties();
        props.setProperty("poll", "1");
        MockRuleAgent ag = new MockRuleAgent();
        ag.init(props);
        RuleAgentTest.assertTrue((boolean)ag.isPolling());
        RuleAgentTest.assertTrue((boolean)ag.refreshCalled);
        ag.refreshCalled = false;
        RuleAgentTest.assertFalse((boolean)ag.refreshCalled);
        Thread.sleep(100L);
        RuleAgentTest.assertFalse((boolean)ag.refreshCalled);
        Thread.sleep(1500L);
        RuleAgentTest.assertTrue((boolean)ag.refreshCalled);
        ag.refreshCalled = false;
        Thread.sleep(100L);
        RuleAgentTest.assertFalse((boolean)ag.refreshCalled);
        Thread.sleep(1500L);
        RuleAgentTest.assertTrue((boolean)ag.refreshCalled);
        ag.stopPolling();
    }

    public void testProviderMap() throws Exception {
        RuleAgentTest.assertEquals((int)3, (int)RuleAgent.PACKAGE_PROVIDERS.size());
        RuleAgentTest.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("url"));
        RuleAgentTest.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("file"));
        RuleAgentTest.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("dir"));
        RuleAgentTest.assertFalse((boolean)RuleAgent.PACKAGE_PROVIDERS.containsKey("XXX"));
        RuleAgentTest.assertTrue((boolean)RuleAgent.PACKAGE_PROVIDERS.get("url").equals(URLScanner.class));
    }

    public void testLoadUpFromProperties() throws Exception {
        AnotherRuleAgentMock ag = new AnotherRuleAgentMock();
        Map oldMap = AnotherRuleAgentMock.PACKAGE_PROVIDERS;
        AnotherRuleAgentMock.PACKAGE_PROVIDERS = new HashMap();
        AnotherRuleAgentMock.PACKAGE_PROVIDERS.put("url", MockProvider.class);
        AnotherRuleAgentMock.PACKAGE_PROVIDERS.put("file", MockProvider.class);
        AnotherRuleAgentMock.PACKAGE_PROVIDERS.put("dir", MockProvider.class);
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("/rule-agent-config.properties"));
        MockEventListener evl = new MockEventListener();
        ag.listener = evl;
        ag.init(props);
        RuleAgentTest.assertTrue((boolean)ag.newInstance);
        RuleAgentTest.assertEquals((int)3, (int)ag.provs.size());
        RuleAgentTest.assertEquals((int)30, (int)ag.secondsToRefresh);
        RuleAgentTest.assertEquals((String)"MyConfig", (String)evl.name);
        RuleAgentTest.assertFalse((boolean)evl.exceptionCalled);
        RuleAgentTest.assertFalse((boolean)evl.warningCalled);
        RuleAgentTest.assertTrue((boolean)evl.infoCalled);
        AnotherRuleAgentMock.PACKAGE_PROVIDERS = oldMap;
    }

    public void testLoadRuleBaseConfigurationProperties() throws Exception {
        AnotherRuleAgentMock ag = new AnotherRuleAgentMock();
        Map oldMap = AnotherRuleAgentMock.PACKAGE_PROVIDERS;
        RuleAgent.PACKAGE_PROVIDERS = new HashMap();
        RuleAgent.PACKAGE_PROVIDERS.put("url", MockProvider.class);
        RuleAgent.PACKAGE_PROVIDERS.put("file", MockProvider.class);
        RuleAgent.PACKAGE_PROVIDERS.put("dir", MockProvider.class);
        Properties props = new Properties();
        MockEventListener evl = new MockEventListener();
        ag.listener = evl;
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("/rule-agent-config.properties"));
        ag.init(props, true);
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().isMaintainTms());
        RuleAgentTest.assertFalse((boolean)ag.getRuleBaseConfiguration().isSequential());
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().getSequentialAgenda().equals(RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL));
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().isShareAlphaNodes());
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().isShareBetaNodes());
        props.load(((Object)((Object)this)).getClass().getResourceAsStream("/rule-base-rule-agent-config.properties"));
        ag.init(props, true);
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().isMaintainTms());
        RuleAgentTest.assertFalse((boolean)ag.getRuleBaseConfiguration().isSequential());
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().getSequentialAgenda().equals(RuleBaseConfiguration.SequentialAgenda.DYNAMIC));
        RuleAgentTest.assertFalse((boolean)ag.getRuleBaseConfiguration().isShareAlphaNodes());
        RuleAgentTest.assertTrue((boolean)ag.getRuleBaseConfiguration().isShareBetaNodes());
        AnotherRuleAgentMock.PACKAGE_PROVIDERS = oldMap;
    }

    class MockEventListener
    implements AgentEventListener {
        public String name;
        boolean exceptionCalled = false;
        boolean infoCalled = false;
        boolean warningCalled;

        MockEventListener() {
        }

        public void debug(String message) {
        }

        public void exception(Exception e) {
            this.exceptionCalled = true;
        }

        public void info(String message) {
            if (message != null) {
                this.infoCalled = true;
            }
        }

        public void setAgentName(String name) {
            this.name = name;
        }

        public void warning(String message) {
            this.warningCalled = false;
        }

        public void debug(String message, Object object) {
        }

        public void info(String message, Object object) {
        }

        public void warning(String message, Object object) {
        }
    }

    class AnotherRuleAgentMock
    extends RuleAgent {
        public int secondsToRefresh;
        public List provs;
        public boolean newInstance;

        public AnotherRuleAgentMock() {
            super(new RuleBaseConfiguration());
        }

        synchronized void configure(boolean newInstance, List provs, int secondsToRefresh) {
            this.newInstance = newInstance;
            this.provs = provs;
            this.secondsToRefresh = secondsToRefresh;
        }
    }
}

