/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import junit.framework.TestCase;
import org.drools.base.BaseClassFieldReader;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorFactory;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.TestBean;
import org.drools.util.asm.BeanInherit;
import org.drools.util.asm.TestAbstract;
import org.drools.util.asm.TestAbstractImpl;
import org.drools.util.asm.TestInterface;
import org.drools.util.asm.TestInterfaceImpl;

public class BaseClassFieldAccessorFactoryTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testIt() throws Exception {
        ClassFieldAccessorFactory factory = new ClassFieldAccessorFactory();
        ClassFieldAccessorCache.CacheEntry cachEntry = new ClassFieldAccessorCache.CacheEntry(Thread.currentThread().getContextClassLoader());
        BaseClassFieldReader ex = factory.getClassFieldReader(TestBean.class, "name", cachEntry);
        BaseClassFieldAccessorFactoryTest.assertEquals((Object)"michael", (Object)ex.getValue(null, (Object)new TestBean()));
        ex = factory.getClassFieldReader(TestBean.class, "age", cachEntry);
        BaseClassFieldAccessorFactoryTest.assertEquals((int)42, (int)((Number)ex.getValue(null, (Object)new TestBean())).intValue());
    }

    public void testInterface() throws Exception {
        ClassFieldReader ex = this.store.getReader(TestInterface.class, "something", ((Object)((Object)this)).getClass().getClassLoader());
        BaseClassFieldAccessorFactoryTest.assertEquals((int)0, (int)ex.getIndex());
        BaseClassFieldAccessorFactoryTest.assertEquals((Object)"foo", (Object)ex.getValue(null, (Object)new TestInterfaceImpl()));
    }

    public void testAbstract() throws Exception {
        ClassFieldReader ex = this.store.getReader(TestAbstract.class, "something", ((Object)((Object)this)).getClass().getClassLoader());
        BaseClassFieldAccessorFactoryTest.assertEquals((int)0, (int)ex.getIndex());
        BaseClassFieldAccessorFactoryTest.assertEquals((Object)"foo", (Object)ex.getValue(null, (Object)new TestAbstractImpl()));
    }

    public void testInherited() throws Exception {
        ClassFieldReader ex = this.store.getReader(BeanInherit.class, "text", ((Object)((Object)this)).getClass().getClassLoader());
        BaseClassFieldAccessorFactoryTest.assertEquals((Object)"hola", (Object)ex.getValue(null, (Object)new BeanInherit()));
    }

    public void testSelfReference() throws Exception {
        ClassFieldReader ex = this.store.getReader(BeanInherit.class, "this", ((Object)((Object)this)).getClass().getClassLoader());
        TestBean bean = new TestBean();
        BaseClassFieldAccessorFactoryTest.assertEquals((Object)bean, (Object)ex.getValue(null, (Object)bean));
    }
}

