/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import junit.framework.Assert;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.TestBean;
import org.drools.base.extractors.BaseClassFieldExtractorsTest;
import org.drools.spi.InternalReadAccessor;

public class LongClassFieldExtractorTest
extends BaseClassFieldExtractorsTest {
    private static final long VALUE = 5L;
    InternalReadAccessor extractor;
    TestBean bean = new TestBean();

    protected void setUp() throws Exception {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        this.extractor = store.getReader(TestBean.class, "longAttr", ((Object)((Object)this)).getClass().getClassLoader());
    }

    public void testGetBooleanValue() {
        try {
            this.extractor.getBooleanValue(null, (Object)this.bean);
            LongClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetByteValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getByteValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testGetCharValue() {
        try {
            this.extractor.getCharValue(null, (Object)this.bean);
            LongClassFieldExtractorTest.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetDoubleValue() {
        try {
            Assert.assertEquals((double)5.0, (double)this.extractor.getDoubleValue(null, (Object)this.bean), (double)0.01);
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testGetFloatValue() {
        try {
            Assert.assertEquals((double)5.0, (double)this.extractor.getFloatValue(null, (Object)this.bean), (double)0.01);
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testGetIntValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getIntValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testGetLongValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getLongValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testGetShortValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getShortValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testGetValue() {
        try {
            Assert.assertEquals((Object)new Long(5L), (Object)this.extractor.getValue(null, (Object)this.bean));
            Assert.assertTrue((boolean)(this.extractor.getValue(null, (Object)this.bean) instanceof Long));
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }

    public void testIsNullValue() {
        try {
            Assert.assertFalse((boolean)this.extractor.isNullValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            LongClassFieldExtractorTest.fail((String)"Should not throw an exception");
        }
    }
}

