/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event.rule;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.ObjectUpdatedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;

public class WorkingMemoryEventSupportTest
extends TestCase {
    public void testAddRuleRuntimeEventListener() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener eventListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectRetracted(ObjectRetractedEvent event) {
                wmList.add(event);
            }
        };
        ksession.addEventListener(eventListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        WorkingMemoryEventSupportTest.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        ksession.update(stiltonHandle, (Object)stilton);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        WorkingMemoryEventSupportTest.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        ksession.retract(stiltonHandle);
        ObjectRetractedEvent ore = (ObjectRetractedEvent)wmList.get(2);
        WorkingMemoryEventSupportTest.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        ksession.insert((Object)cheddar);
    }

    public void testRemoveRuleRuntimeEventListener() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener eventListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectRetracted(ObjectRetractedEvent event) {
                wmList.add(event);
            }
        };
        ksession.addEventListener(eventListener);
        ksession.removeEventListener(eventListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        WorkingMemoryEventSupportTest.assertTrue((boolean)wmList.isEmpty());
        ksession.update(stiltonHandle, (Object)stilton);
        WorkingMemoryEventSupportTest.assertTrue((boolean)wmList.isEmpty());
        ksession.retract(stiltonHandle);
        WorkingMemoryEventSupportTest.assertTrue((boolean)wmList.isEmpty());
        ksession.insert((Object)cheddar);
        WorkingMemoryEventSupportTest.assertTrue((boolean)wmList.isEmpty());
    }
}

