/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.ByteArrayInputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import junit.framework.TestCase;
import org.drools.factmodel.Fact;
import org.drools.factmodel.Field;
import org.drools.factmodel.Jenerator;

public class JeneratorTest
extends TestCase {
    public void testRoundTrip() throws Exception {
        Fact f = new Fact();
        f.name = "Foobar";
        Field f1 = new Field();
        f1.name = "name";
        f1.type = "java.lang.String";
        f.fields.add(f1);
        Field f2 = new Field();
        f2.name = "age";
        f2.type = "java.lang.Integer";
        f.fields.add(f2);
        Fact f_ = new Fact();
        f_.name = "Baz";
        Field f1_ = new Field();
        f1_.name = "name";
        f1_.type = "java.lang.String";
        f_.fields.add(f1_);
        Jenerator jen = new Jenerator();
        byte[] data = jen.createJar(new Fact[]{f, f_}, "whee.waa");
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(data));
        JarEntry je = jis.getNextJarEntry();
        JeneratorTest.assertNotNull((Object)je);
        System.err.println(je.getName());
        JeneratorTest.assertEquals((String)"factmodel.xml", (String)je.getName());
        je = jis.getNextJarEntry();
        JeneratorTest.assertNotNull((Object)je);
        System.err.println(je.getName());
        JeneratorTest.assertEquals((String)"whee/waa/Foobar.class", (String)je.getName());
        je = jis.getNextJarEntry();
        JeneratorTest.assertNotNull((Object)je);
        System.err.println(je.getName());
        JeneratorTest.assertEquals((String)"whee/waa/Baz.class", (String)je.getName());
        Fact[] facts = jen.loadMetaModel(new JarInputStream(new ByteArrayInputStream(data)));
        JeneratorTest.assertEquals((int)2, (int)facts.length);
        JeneratorTest.assertEquals((String)"Foobar", (String)facts[0].name);
        JeneratorTest.assertEquals((String)"Baz", (String)facts[1].name);
    }
}

