/*
 * Decompiled with CFR 0.152.
 */
package org.drools.facttemplates;

import junit.framework.TestCase;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactTemplateImpl;
import org.drools.facttemplates.FieldTemplate;
import org.drools.facttemplates.FieldTemplateImpl;
import org.drools.rule.Package;

public class FactTemplateTest
extends TestCase {
    public void testFieldsAndGetters() {
        Package pkg = new Package("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateTest.assertEquals((String)"org.store", (String)cheese.getPackage().getName());
        FactTemplateTest.assertEquals((String)"Cheese", (String)cheese.getName());
        FactTemplateTest.assertEquals((int)2, (int)cheese.getNumberOfFields());
        FactTemplateTest.assertSame((Object)fields, (Object)cheese.getAllFieldTemplates());
        FactTemplateTest.assertSame((Object)cheeseName, (Object)cheese.getFieldTemplate(0));
        FactTemplateTest.assertSame((Object)cheesePrice, (Object)cheese.getFieldTemplate(1));
        FactTemplateTest.assertSame((Object)cheeseName, (Object)cheese.getFieldTemplate("name"));
        FactTemplateTest.assertSame((Object)cheesePrice, (Object)cheese.getFieldTemplate("price"));
        FactTemplateTest.assertEquals((int)0, (int)cheese.getFieldTemplateIndex("name"));
        FactTemplateTest.assertEquals((int)1, (int)cheese.getFieldTemplateIndex("price"));
    }

    public void testEqualsAndHashCode() {
        Package pkg = new Package("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields1 = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese1 = new FactTemplateImpl(pkg, "Cheese", fields1);
        FieldTemplateImpl cheeseType = new FieldTemplateImpl("type", 0, String.class);
        FieldTemplate[] fields2 = new FieldTemplate[]{cheeseType, cheesePrice};
        FactTemplateImpl cheese2 = new FactTemplateImpl(pkg, "Cheese", fields2);
        FactTemplateTest.assertNotSame((Object)cheese1, (Object)cheese2);
        FactTemplateTest.assertFalse((boolean)cheese1.equals(cheese2));
        FactTemplateTest.assertFalse((cheese1.hashCode() == cheese2.hashCode() ? 1 : 0) != 0);
        FieldTemplateImpl cheeseName2 = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice2 = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields3 = new FieldTemplate[]{cheeseName2, cheesePrice2};
        FactTemplateImpl cheese3 = new FactTemplateImpl(pkg, "Cheese", fields3);
        FactTemplateTest.assertNotSame((Object)cheese1, (Object)cheese3);
        FactTemplateTest.assertNotSame((Object)cheese1.getAllFieldTemplates(), (Object)cheese3.getAllFieldTemplates());
        FactTemplateTest.assertEquals((Object)cheese1, (Object)cheese3);
        FactTemplateTest.assertEquals((int)cheese1.hashCode(), (int)cheese3.hashCode());
    }

    public void testFacts() {
        Package pkg = new Package("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields1 = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese1 = new FactTemplateImpl(pkg, "Cheese", fields1);
        Fact stilton1 = cheese1.createFact(10L);
        stilton1.setFieldValue("name", (Object)"stilton");
        stilton1.setFieldValue("price", (Object)new Integer(200));
        Fact stilton2 = cheese1.createFact(11L);
        stilton2.setFieldValue(0, (Object)"stilton");
        stilton2.setFieldValue(1, (Object)new Integer(200));
        FactTemplateTest.assertEquals((Object)stilton1, (Object)stilton2);
        FactTemplateTest.assertEquals((int)stilton1.hashCode(), (int)stilton2.hashCode());
        Fact brie = cheese1.createFact(12L);
        brie.setFieldValue("name", (Object)"brie");
        brie.setFieldValue("price", (Object)new Integer(55));
        FactTemplateTest.assertFalse((boolean)stilton1.equals(brie));
        FactTemplateTest.assertFalse((stilton1.hashCode() == brie.hashCode() ? 1 : 0) != 0);
    }
}

