/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import junit.framework.TestCase;
import org.drools.persistence.DroolsXid;
import org.drools.persistence.memory.MemoryPersister;
import org.drools.persistence.memory.MemoryXaResource;
import org.drools.transaction.MockByteArraySnapshotter;

public class MemoryPersisterTest
extends TestCase {
    private byte[] data1 = new byte[]{1, 1, 1, 1, 1};
    private byte[] data2 = new byte[]{1, 1, 1, 1, 0};
    private byte[] data3 = new byte[]{1, 1, 1, 0, 0};
    MockByteArraySnapshotter<Object> snapshotter;
    MemoryPersister<Object> pm;

    protected void setUp() throws Exception {
        this.snapshotter = new MockByteArraySnapshotter();
        this.pm = new MemoryPersister(this.snapshotter);
    }

    public void testSave() {
        this.snapshotter.loadSnapshot(this.data1);
        this.pm.save();
        MemoryPersisterTest.assertTrue((boolean)this.assertEquals(this.data1, this.snapshotter.bytes));
        this.snapshotter.loadSnapshot(this.data2);
        MemoryPersisterTest.assertTrue((boolean)this.assertEquals(this.data2, this.snapshotter.bytes));
        this.pm.load();
        MemoryPersisterTest.assertTrue((boolean)this.assertEquals(this.data1, this.snapshotter.bytes));
    }

    public void testSaveInOpenTransaction() throws XAException {
        this.snapshotter.loadSnapshot(this.data1);
        MemoryXaResource xa = this.pm.getXAResource();
        DroolsXid xid = new DroolsXid(100, new byte[]{1}, new byte[]{1});
        xa.start((Xid)xid, 0);
        try {
            this.pm.save();
            MemoryPersisterTest.fail((String)"save should fail as the session currently has an open transaction");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoadInOpenTransaction() throws XAException {
        this.snapshotter.loadSnapshot(this.data1);
        this.pm.save();
        MemoryXaResource xa = this.pm.getXAResource();
        DroolsXid xid = new DroolsXid(100, new byte[]{1}, new byte[]{1});
        xa.start((Xid)xid, 0);
        try {
            this.pm.load();
            MemoryPersisterTest.fail((String)"load should fail as the session currently has an open transaction");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoadSaveAfterTransaction() throws Exception {
        this.snapshotter.loadSnapshot(this.data1);
        MemoryXaResource xa = this.pm.getXAResource();
        DroolsXid xid = new DroolsXid(100, new byte[]{1}, new byte[]{1});
        xa.start((Xid)xid, 0);
        this.snapshotter.loadSnapshot(this.data2);
        xa.commit((Xid)xid, true);
        this.pm.save();
        MemoryPersisterTest.assertTrue((boolean)this.assertEquals(this.data2, this.snapshotter.bytes));
        this.snapshotter.loadSnapshot(this.data3);
        MemoryPersisterTest.assertTrue((boolean)this.assertEquals(this.data3, this.snapshotter.bytes));
        this.pm.load();
        MemoryPersisterTest.assertTrue((boolean)this.assertEquals(this.data2, this.snapshotter.bytes));
    }

    public boolean assertEquals(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

