/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import javax.transaction.xa.Xid;
import junit.framework.TestCase;
import org.drools.persistence.ByteArraySnapshotter;
import org.drools.persistence.DroolsXid;
import org.drools.persistence.memory.MemoryPersister;
import org.drools.persistence.memory.MemoryXaResource;
import org.drools.transaction.MockByteArraySnapshotter;

public class MemoryXaResourceTest
extends TestCase {
    private byte[] data1 = new byte[]{1, 1, 1, 1, 1};
    private byte[] data2 = new byte[]{1, 1, 1, 1, 0};
    private byte[] data3 = new byte[]{1, 1, 1, 0, 0};
    MockByteArraySnapshotter snapshotter;
    MemoryPersister pm;

    protected void setUp() throws Exception {
        this.snapshotter = new MockByteArraySnapshotter();
        this.pm = new MemoryPersister((ByteArraySnapshotter)this.snapshotter);
    }

    public void testInitFields() {
        MemoryXaResource xa = this.pm.getXAResource();
        MemoryXaResourceTest.assertEquals((int)0, (int)xa.list.size());
        MemoryXaResourceTest.assertNull((Object)this.pm.lastSave.getData(null));
    }

    public void testSingleTransactionWithRollBack() throws Exception {
        MemoryXaResource xa = this.pm.getXAResource();
        DroolsXid xid = new DroolsXid(100, new byte[]{1}, new byte[]{1});
        this.snapshotter.bytes = this.data1;
        xa.start((Xid)xid, 0);
        MemoryXaResourceTest.assertEquals((int)1, (int)xa.list.size());
        MemoryXaResourceTest.assertSame(xa.data.get(xa.list.get(0)), (Object)this.pm.lastSave.getData(null));
        this.snapshotter.bytes = this.data2;
        xa.rollback((Xid)xid);
        MemoryXaResourceTest.assertTrue((boolean)this.assertEquals(this.data1, this.snapshotter.bytes));
        MemoryXaResourceTest.assertTrue((boolean)xa.list.isEmpty());
        MemoryXaResourceTest.assertTrue((boolean)xa.data.isEmpty());
    }

    public void testSingleTransactionWithCommit() throws Exception {
        MemoryXaResource xa = this.pm.getXAResource();
        DroolsXid xid = new DroolsXid(100, new byte[]{1}, new byte[]{1});
        this.snapshotter.bytes = this.data1;
        xa.start((Xid)xid, 0);
        this.snapshotter.bytes = this.data2;
        xa.commit((Xid)xid, true);
        MemoryXaResourceTest.assertEquals((int)0, (int)xa.list.size());
        MemoryXaResourceTest.assertSame((Object)this.data2, (Object)this.pm.lastSave.getData(null));
        xa.rollback((Xid)xid);
        MemoryXaResourceTest.assertTrue((boolean)this.assertEquals(this.data2, this.snapshotter.bytes));
        MemoryXaResourceTest.assertTrue((boolean)xa.list.isEmpty());
        MemoryXaResourceTest.assertTrue((boolean)xa.data.isEmpty());
    }

    public void testMultipleTransactions() throws Exception {
        MemoryXaResource xa = this.pm.getXAResource();
        DroolsXid xid1 = new DroolsXid(100, new byte[]{1}, new byte[]{1});
        this.snapshotter.bytes = this.data1;
        xa.start((Xid)xid1, 0);
        DroolsXid xid2 = new DroolsXid(100, new byte[]{2}, new byte[]{2});
        this.snapshotter.bytes = this.data2;
        xa.start((Xid)xid2, 0);
        MemoryXaResourceTest.assertEquals((int)2, (int)xa.list.size());
        MemoryXaResourceTest.assertSame(xa.data.get(xa.list.get(0)), (Object)this.pm.lastSave.getData(null));
        DroolsXid xid3 = new DroolsXid(100, new byte[]{3}, new byte[]{3});
        this.snapshotter.bytes = this.data3;
        xa.start((Xid)xid3, 0);
        MemoryXaResourceTest.assertEquals((int)3, (int)xa.list.size());
        xa.commit((Xid)xid1, true);
        MemoryXaResourceTest.assertSame(xa.data.get(xid2), (Object)this.pm.lastSave.getData(null));
        xa.rollback((Xid)xid2);
        MemoryXaResourceTest.assertTrue((boolean)xa.list.isEmpty());
        MemoryXaResourceTest.assertTrue((boolean)xa.data.isEmpty());
    }

    public boolean assertEquals(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

