/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process;

import junit.framework.TestCase;
import org.drools.RuleBaseFactory;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalRuleBase;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.process.instance.timer.TimerManager;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;

public class TimerTest
extends TestCase {
    private int counter = 0;

    public void testTimer() {
        AbstractRuleBase ruleBase = (AbstractRuleBase)RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance(){
            private static final long serialVersionUID = 4L;

            public void signalEvent(String type, Object event) {
                if ("timerTriggered".equals(type)) {
                    TimerInstance timer = (TimerInstance)event;
                    System.out.println("Timer " + timer.getId() + " triggered");
                    TimerTest.this.counter++;
                }
            }
        };
        processInstance.setId(1234L);
        workingMemory.getProcessInstanceManager().internalAddProcessInstance((ProcessInstance)processInstance);
        TimerManager timerManager = workingMemory.getTimerManager();
        TimerInstance timer = new TimerInstance();
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TimerTest.assertEquals((int)1, (int)this.counter);
        this.counter = 0;
        timer = new TimerInstance();
        timer.setDelay(500L);
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        TimerTest.assertEquals((int)0, (int)this.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TimerTest.assertEquals((int)1, (int)this.counter);
        this.counter = 0;
        timer = new TimerInstance();
        timer.setDelay(500L);
        timer.setPeriod(300L);
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        TimerTest.assertEquals((int)0, (int)this.counter);
        try {
            Thread.sleep(700L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TimerTest.assertEquals((int)1, (int)this.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TimerTest.assertTrue((this.counter >= 4 ? 1 : 0) != 0);
        timerManager.cancelTimer(timer.getId());
        int lastCount = this.counter;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TimerTest.assertEquals((int)lastCount, (int)this.counter);
    }
}

