/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.RuleBaseFactory;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockEvalCondition;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;

public class EvalConditionNodeTest
extends DroolsTestCase {
    private PropagationContext context;
    private ReteooWorkingMemory workingMemory;
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    public EvalConditionNodeTest(String name) {
        super(name);
    }

    public void setUp() {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        this.workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
    }

    public void testAttach() throws Exception {
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        EvalConditionNodeTest.assertEquals((int)18, (int)node.getId());
        EvalConditionNodeTest.assertEquals((int)0, (int)source.getAttached());
        node.attach();
        EvalConditionNodeTest.assertEquals((int)1, (int)source.getAttached());
    }

    public void testMemory() {
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)workingMemory.getNodeMemory((NodeMemory)node);
        EvalConditionNodeTest.assertNotNull((Object)memory.tupleMemory);
    }

    public void testAssertedAllowed() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)this.workingMemory.getNodeMemory((NodeMemory)node);
        EvalConditionNodeTest.assertEquals((int)2, (int)memory.tupleMemory.size());
        EvalConditionNodeTest.assertTrue((boolean)memory.tupleMemory.contains(tuple0));
        EvalConditionNodeTest.assertTrue((boolean)memory.tupleMemory.contains(tuple1));
        EvalConditionNodeTest.assertEquals((int)2, (int)sink.getAsserted().size());
    }

    public void testAssertedAllowedThenRetract() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)this.workingMemory.getNodeMemory((NodeMemory)node);
        EvalConditionNodeTest.assertEquals((int)2, (int)memory.tupleMemory.size());
        EvalConditionNodeTest.assertTrue((boolean)memory.tupleMemory.contains(tuple0));
        EvalConditionNodeTest.assertTrue((boolean)memory.tupleMemory.contains(tuple1));
        EvalConditionNodeTest.assertEquals((int)2, (int)sink.getAsserted().size());
        node.retractLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        EvalConditionNodeTest.assertEquals((int)1, (int)memory.tupleMemory.size());
        EvalConditionNodeTest.assertTrue((boolean)memory.tupleMemory.contains(tuple1));
        EvalConditionNodeTest.assertEquals((int)1, (int)sink.getRetracted().size());
        node.retractLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        EvalConditionNodeTest.assertEquals((int)0, (int)memory.tupleMemory.size());
        EvalConditionNodeTest.assertEquals((int)2, (int)sink.getRetracted().size());
    }

    public void testAssertedNotAllowed() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(false);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)this.workingMemory.getNodeMemory((NodeMemory)node);
        EvalConditionNodeTest.assertEquals((int)0, (int)memory.tupleMemory.size());
        EvalConditionNodeTest.assertEquals((int)0, (int)sink.getAsserted().size());
        EvalConditionNodeTest.assertEquals((int)0, (int)sink.getRetracted().size());
    }

    public void testUpdateWithMemory() throws FactException {
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)new MockEvalCondition(true), this.buildContext);
        MockLeftTupleSink sink1 = new MockLeftTupleSink(2);
        node.addTupleSink((LeftTupleSink)sink1);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"string0");
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)sink1, true);
        node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink1.getAsserted());
        MockLeftTupleSink sink2 = new MockLeftTupleSink(3);
        node.addTupleSink((LeftTupleSink)sink2);
        this.assertLength(0, sink2.getAsserted());
        node.updateSink((LeftTupleSink)sink2, this.context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink2.getAsserted());
    }
}

