/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.ComparableEvaluatorsDefinition;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightTuple;
import org.drools.rule.AndConstraint;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.OrConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.ReturnValueRestriction;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PredicateExpression;
import org.drools.spi.ReturnValueExpression;
import org.drools.spi.Tuple;

public class FieldConstraintTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    EqualityEvaluatorsDefinition equals = new EqualityEvaluatorsDefinition();
    ComparableEvaluatorsDefinition comparables = new ComparableEvaluatorsDefinition();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testLiteralConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator evaluator = this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL);
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        ContextEntry context = constraint.createContextEntry();
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        Cheese stilton = new Cheese("stilton", 5);
        InternalFactHandle stiltonHandle = (InternalFactHandle)workingMemory.insert((Object)stilton);
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(stiltonHandle, workingMemory, context));
    }

    public void testPrimitiveLiteralConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((int)5);
        Evaluator evaluator = this.equals.getEvaluator(ValueType.PINTEGER_TYPE, Operator.EQUAL);
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        ContextEntry context = constraint.createContextEntry();
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        Cheese stilton = new Cheese("stilton", 10);
        InternalFactHandle stiltonHandle = (InternalFactHandle)workingMemory.insert((Object)stilton);
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(stiltonHandle, workingMemory, context));
    }

    public void testPredicateConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price1Declaration = new Declaration("price1", (InternalReadAccessor)priceExtractor, pattern);
        pattern = new Pattern(1, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price2Declaration = new Declaration("price2", (InternalReadAccessor)priceExtractor, pattern);
        PredicateExpression evaluator = new PredicateExpression(){
            private static final long serialVersionUID = 400L;

            public boolean evaluate(Object object, Tuple tuple, Declaration[] previousDeclarations, Declaration[] localDeclarations, WorkingMemory workingMemory, Object context) {
                int price1 = previousDeclarations[0].getIntValue((InternalWorkingMemory)workingMemory, workingMemory.getObject((FactHandle)tuple.get(previousDeclarations[0])));
                int price2 = localDeclarations[0].getIntValue((InternalWorkingMemory)workingMemory, object);
                return price2 == price1 * 2;
            }

            public Object createContext() {
                return null;
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        PredicateConstraint constraint1 = new PredicateConstraint(evaluator, new Declaration[]{price1Declaration}, new Declaration[]{price2Declaration}, new String[0]);
        Cheese cheddar0 = new Cheese("cheddar", 5);
        InternalFactHandle f0 = (InternalFactHandle)workingMemory.insert((Object)cheddar0);
        LeftTuple tuple = new LeftTuple(f0, null, true);
        Cheese cheddar1 = new Cheese("cheddar", 10);
        InternalFactHandle f1 = (InternalFactHandle)workingMemory.insert((Object)cheddar1);
        tuple = new LeftTuple(tuple, new RightTuple(f1, null), null, true);
        PredicateConstraint.PredicateContextEntry context = (PredicateConstraint.PredicateContextEntry)constraint1.createContextEntry();
        context.updateFromTuple(workingMemory, tuple);
        FieldConstraintTest.assertTrue((boolean)constraint1.isAllowedCachedLeft((ContextEntry)context, f1));
    }

    public void testReturnValueConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration priceDeclaration = new Declaration("price1", (InternalReadAccessor)priceExtractor, pattern);
        ReturnValueExpression isDoubleThePrice = new ReturnValueExpression(){
            private static final long serialVersionUID = 400L;

            public FieldValue evaluate(Object object, Tuple tuple, Declaration[] previousDeclarations, Declaration[] localDeclarations, WorkingMemory workingMemory, Object context) {
                int price = ((Number)previousDeclarations[0].getValue((InternalWorkingMemory)workingMemory, workingMemory.getObject((FactHandle)tuple.get(previousDeclarations[0])))).intValue();
                return FieldFactory.getFieldValue((int)(2 * price));
            }

            public Object createContext() {
                return null;
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        ReturnValueRestriction restriction1 = new ReturnValueRestriction((InternalReadAccessor)priceExtractor, isDoubleThePrice, new Declaration[]{priceDeclaration}, new Declaration[0], new String[0], this.equals.getEvaluator(ValueType.INTEGER_TYPE, Operator.EQUAL));
        ReturnValueConstraint constraint1 = new ReturnValueConstraint((InternalReadAccessor)priceExtractor, restriction1);
        ReturnValueRestriction restriction2 = new ReturnValueRestriction((InternalReadAccessor)priceExtractor, isDoubleThePrice, new Declaration[]{priceDeclaration}, new Declaration[0], new String[0], this.comparables.getEvaluator(ValueType.INTEGER_TYPE, Operator.GREATER));
        ReturnValueConstraint constraint2 = new ReturnValueConstraint((InternalReadAccessor)priceExtractor, restriction2);
        Cheese cheddar0 = new Cheese("cheddar", 5);
        InternalFactHandle f0 = (InternalFactHandle)workingMemory.insert((Object)cheddar0);
        LeftTuple tuple = new LeftTuple(f0, null, true);
        Cheese cheddar1 = new Cheese("cheddar", 10);
        InternalFactHandle f1 = (InternalFactHandle)workingMemory.insert((Object)cheddar1);
        tuple = new LeftTuple(tuple, new RightTuple(f1, null), null, true);
        ReturnValueRestriction.ReturnValueContextEntry context1 = (ReturnValueRestriction.ReturnValueContextEntry)constraint1.createContextEntry();
        context1.updateFromTuple(workingMemory, tuple);
        FieldConstraintTest.assertTrue((boolean)constraint1.isAllowedCachedLeft((ContextEntry)context1, f1));
        ReturnValueRestriction.ReturnValueContextEntry context2 = (ReturnValueRestriction.ReturnValueContextEntry)constraint2.createContextEntry();
        context2.updateFromTuple(workingMemory, tuple);
        FieldConstraintTest.assertFalse((boolean)constraint2.isAllowedCachedLeft((ContextEntry)context2, f1));
        Cheese cheddar2 = new Cheese("cheddar", 11);
        InternalFactHandle f2 = (InternalFactHandle)workingMemory.insert((Object)cheddar2);
        FieldConstraintTest.assertTrue((boolean)constraint2.isAllowedCachedLeft((ContextEntry)context2, f2));
    }

    public void testCompositeAndConstraint() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator evaluator = this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL);
        LiteralConstraint constraint1 = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue priceField = FieldFactory.getFieldValue((int)10);
        Evaluator priceEvaluator = this.comparables.getEvaluator(ValueType.INTEGER_TYPE, Operator.GREATER);
        LiteralConstraint constraint2 = new LiteralConstraint((InternalReadAccessor)priceExtractor, priceEvaluator, priceField);
        Cheese cheddar = new Cheese("cheddar", 15);
        AndConstraint constraint = new AndConstraint();
        constraint.addAlphaConstraint((AlphaNodeFieldConstraint)constraint1);
        constraint.addAlphaConstraint((AlphaNodeFieldConstraint)constraint2);
        ContextEntry context = constraint.createContextEntry();
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setPrice(5);
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setType("stilton");
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setPrice(15);
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
    }

    public void testCompositeOrConstraint() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator evaluator = this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL);
        LiteralConstraint constraint1 = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue priceField = FieldFactory.getFieldValue((int)10);
        Evaluator priceEvaluator = this.comparables.getEvaluator(ValueType.INTEGER_TYPE, Operator.GREATER);
        LiteralConstraint constraint2 = new LiteralConstraint((InternalReadAccessor)priceExtractor, priceEvaluator, priceField);
        Cheese cheddar = new Cheese("cheddar", 15);
        OrConstraint constraint = new OrConstraint();
        constraint.addAlphaConstraint((AlphaNodeFieldConstraint)constraint1);
        constraint.addAlphaConstraint((AlphaNodeFieldConstraint)constraint2);
        ContextEntry context = constraint.createContextEntry();
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setPrice(5);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setType("stilton");
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setPrice(15);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
    }

    public void testNestedCompositeConstraints() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader typeExtractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue cheddarField = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator stringEqual = this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL);
        LiteralConstraint constraint1 = new LiteralConstraint((InternalReadAccessor)typeExtractor, stringEqual, cheddarField);
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field10 = FieldFactory.getFieldValue((int)10);
        Evaluator integerGreater = this.comparables.getEvaluator(ValueType.INTEGER_TYPE, Operator.GREATER);
        LiteralConstraint constraint2 = new LiteralConstraint((InternalReadAccessor)priceExtractor, integerGreater, field10);
        AndConstraint and1 = new AndConstraint();
        and1.addAlphaConstraint((AlphaNodeFieldConstraint)constraint1);
        and1.addAlphaConstraint((AlphaNodeFieldConstraint)constraint2);
        FieldValue stiltonField = FieldFactory.getFieldValue((Object)"stilton");
        LiteralConstraint constraint3 = new LiteralConstraint((InternalReadAccessor)typeExtractor, stringEqual, stiltonField);
        Evaluator integerLess = this.comparables.getEvaluator(ValueType.INTEGER_TYPE, Operator.LESS);
        LiteralConstraint constraint4 = new LiteralConstraint((InternalReadAccessor)priceExtractor, integerLess, field10);
        AndConstraint and2 = new AndConstraint();
        and2.addAlphaConstraint((AlphaNodeFieldConstraint)constraint3);
        and2.addAlphaConstraint((AlphaNodeFieldConstraint)constraint4);
        OrConstraint constraint = new OrConstraint();
        constraint.addAlphaConstraint((AlphaNodeFieldConstraint)and1);
        constraint.addAlphaConstraint((AlphaNodeFieldConstraint)and2);
        ContextEntry context = constraint.createContextEntry();
        Cheese cheddar = new Cheese("cheddar", 15);
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setPrice(5);
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setType("stilton");
        FieldConstraintTest.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        cheddar.setPrice(15);
        FieldConstraintTest.assertFalse((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
    }
}

