/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import junit.framework.TestCase;
import org.drools.util.BinaryHeapQueue;
import org.drools.util.LongQueueable;
import org.drools.util.NaturalComparator;
import org.drools.util.Queueable;

public class BinaryHeapPriorityQueueTest
extends TestCase {
    public void testOptimised() {
        Random random = new Random();
        LinkedList<LongQueueable> items = new LinkedList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE, 100000);
        for (int i = 0; i < 100000; ++i) {
            items.add(new LongQueueable(random.nextLong()));
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            queue.enqueue((Queueable)i.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            ((Queueable)i2.next()).dequeue();
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }

    public void testBasic() {
        Random random = new Random();
        LinkedList<LongQueueable> items = new LinkedList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE, 100000);
        for (int i = 0; i < 100000; ++i) {
            items.add(new LongQueueable(random.nextLong()));
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            queue.enqueue((Queueable)i.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            queue.enqueue((Queueable)i2.next());
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }
}

