/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.util.AbstractBaseLinkedListNode;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;

public class LinkedListTest
extends TestCase {
    LinkedList list = null;
    LinkedListNode node1 = null;
    LinkedListNode node2 = null;
    LinkedListNode node3 = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.list = new LinkedList();
        this.node1 = new AbstractBaseLinkedListNode();
        this.node2 = new AbstractBaseLinkedListNode();
        this.node3 = new AbstractBaseLinkedListNode();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAdd() {
        this.list.add(this.node1);
        Assert.assertNull((String)"Node1 previous should be null", (Object)this.node1.getPrevious());
        Assert.assertNull((String)"Node1 next should be null", (Object)this.node1.getNext());
        Assert.assertSame((String)"First node should be node1", (Object)this.list.getFirst(), (Object)this.node1);
        Assert.assertSame((String)"Last node should be node1", (Object)this.list.getLast(), (Object)this.node1);
        this.list.add(this.node2);
        Assert.assertSame((String)"node1 next should be node2", (Object)this.node1.getNext(), (Object)this.node2);
        Assert.assertSame((String)"node2 previous should be node1", (Object)this.node2.getPrevious(), (Object)this.node1);
        Assert.assertSame((String)"First node should be node1", (Object)this.list.getFirst(), (Object)this.node1);
        Assert.assertSame((String)"Last node should be node2", (Object)this.list.getLast(), (Object)this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"node2 next should be node3", (Object)this.node2.getNext(), (Object)this.node3);
        Assert.assertSame((String)"node3 previous should be node2", (Object)this.node3.getPrevious(), (Object)this.node2);
        Assert.assertEquals((String)"LinkedList should have 3 nodes", (int)this.list.size(), (int)3);
        Assert.assertSame((String)"First node should be node1", (Object)this.list.getFirst(), (Object)this.node1);
        Assert.assertSame((String)"Last node should be node3", (Object)this.list.getLast(), (Object)this.node3);
    }

    public void testRemove() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"Node2 previous should be node1", (Object)this.node2.getPrevious(), (Object)this.node1);
        Assert.assertSame((String)"Node2 next should be node3", (Object)this.node2.getNext(), (Object)this.node3);
        this.list.remove(this.node2);
        Assert.assertNull((String)"Node2 previous should be null", (Object)this.node2.getPrevious());
        Assert.assertNull((String)"Node2 next should be null", (Object)this.node2.getNext());
        Assert.assertNull((String)"Node1 previous should be null", (Object)this.node1.getPrevious());
        Assert.assertSame((String)"Node1 next should be node3", (Object)this.node1.getNext(), (Object)this.node3);
        this.list.remove(this.node1);
        Assert.assertNull((String)"Node1 previous should be null", (Object)this.node1.getPrevious());
        Assert.assertNull((String)"Node1 next should be null", (Object)this.node1.getNext());
        Assert.assertNull((String)"Node3 previous should be null", (Object)this.node3.getPrevious());
        Assert.assertNull((String)"Node3 next should be null", (Object)this.node3.getNext());
        this.list.remove(this.node3);
        Assert.assertNull((String)"Node3 previous should be null", (Object)this.node3.getPrevious());
        Assert.assertNull((String)"Node3 next should be null", (Object)this.node3.getNext());
    }

    public void testGetFirst() {
        Assert.assertNull((String)"Empty list should return null on getFirst()", (Object)this.list.getFirst());
        this.list.add(this.node1);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
        this.list.add(this.node2);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
    }

    public void testGetLast() {
        Assert.assertNull((String)"Empty list should return null on getLast()", (Object)this.list.getLast());
        this.list.add(this.node1);
        Assert.assertSame((String)"List should return node1 on getLast()", (Object)this.list.getLast(), (Object)this.node1);
        this.list.add(this.node2);
        Assert.assertSame((String)"List should return node2 on getLast()", (Object)this.list.getLast(), (Object)this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node3 on getLast()", (Object)this.list.getLast(), (Object)this.node3);
    }

    public void testRemoveFirst() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node1 on getFirst()", (Object)this.list.getFirst(), (Object)this.node1);
        this.list.removeFirst();
        Assert.assertSame((String)"List should return node2 on getFirst()", (Object)this.list.getFirst(), (Object)this.node2);
        this.list.removeFirst();
        Assert.assertSame((String)"List should return node3 on getFirst()", (Object)this.list.getFirst(), (Object)this.node3);
        this.list.removeFirst();
        Assert.assertNull((String)"Empty list should return null on getFirst()", (Object)this.list.getFirst());
    }

    public void testRemoveLast() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertSame((String)"List should return node1 on getLast()", (Object)this.list.getLast(), (Object)this.node3);
        this.list.removeLast();
        Assert.assertSame((String)"List should return node2 on getLast()", (Object)this.list.getLast(), (Object)this.node2);
        this.list.removeLast();
        Assert.assertSame((String)"List should return node3 on getLast()", (Object)this.list.getLast(), (Object)this.node1);
        this.list.removeLast();
        Assert.assertNull((String)"Empty list should return null on getLast()", (Object)this.list.getLast());
    }

    public void testIsEmpty() {
        Assert.assertTrue((String)"Empty list should return true on isEmpty()", (boolean)this.list.isEmpty());
        this.list.add(this.node1);
        Assert.assertFalse((String)"Not empty list should return false on isEmpty()", (boolean)this.list.isEmpty());
    }

    public void testClear() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        Assert.assertEquals((String)"List size should be 3", (int)this.list.size(), (int)3);
        this.list.clear();
        Assert.assertEquals((String)"Empty list should have size 0", (int)this.list.size(), (int)0);
    }

    public void testSize() {
        this.list.add(this.node1);
        Assert.assertEquals((String)"LinkedList should have 1 node", (int)this.list.size(), (int)1);
        this.list.add(this.node2);
        Assert.assertEquals((String)"LinkedList should have 2 nodes", (int)this.list.size(), (int)2);
        this.list.add(this.node3);
        Assert.assertEquals((String)"LinkedList should have 3 nodes", (int)this.list.size(), (int)3);
    }

    public void testInsertAfter() {
        try {
            this.list.insertAfter(null, this.node1);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            LinkedListTest.fail((String)"Should NOT raise NPE!");
        }
    }
}

