/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.common.AgendaGroupFactory;
import org.drools.common.ArrayAgendaGroupFactory;
import org.drools.common.PriorityQueueAgendaGroupFactory;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.impl.ParameterDefinitionImpl;
import org.drools.process.core.impl.WorkDefinitionExtensionImpl;
import org.drools.process.instance.ProcessInstanceFactory;
import org.drools.process.instance.ProcessInstanceFactoryRegistry;
import org.drools.process.instance.ProcessInstanceManagerFactory;
import org.drools.process.instance.WorkItemManagerFactory;
import org.drools.process.instance.event.SignalManagerFactory;
import org.drools.process.instance.impl.ContextInstanceFactory;
import org.drools.process.instance.impl.ContextInstanceFactoryRegistry;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.spi.ConflictResolver;
import org.drools.util.ChainedProperties;
import org.drools.util.ConfFileUtils;
import org.drools.util.StringUtils;
import org.drools.workflow.instance.impl.NodeInstanceFactory;
import org.drools.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBaseConfiguration
implements KnowledgeBaseConfiguration,
Externalizable {
    private static final long serialVersionUID = 400L;
    private ChainedProperties chainedProperties;
    private boolean immutable;
    private boolean sequential;
    private SequentialAgenda sequentialAgenda;
    private boolean maintainTms;
    private boolean removeIdentities;
    private boolean shareAlphaNodes;
    private boolean shareBetaNodes;
    private int alphaNodeHashingThreshold;
    private int compositeKeyDepth;
    private boolean indexLeftBetaMemory;
    private boolean indexRightBetaMemory;
    private AssertBehaviour assertBehaviour;
    private LogicalOverride logicalOverride;
    private String executorService;
    private String consequenceExceptionHandler;
    private String ruleBaseUpdateHandler;
    private EventProcessingMode eventProcessingMode;
    private boolean multithread;
    private int maxThreads;
    private ConflictResolver conflictResolver;
    private static final String STAR = "*";
    private ContextInstanceFactoryRegistry processContextInstanceFactoryRegistry;
    private Map<String, WorkDefinition> workDefinitions;
    private Map<String, WorkItemHandler> workItemHandlers;
    private boolean advancedProcessRuleIntegration;
    private ProcessInstanceFactoryRegistry processInstanceFactoryRegistry;
    private NodeInstanceFactoryRegistry processNodeInstanceFactoryRegistry;
    private ProcessInstanceManagerFactory processInstanceManagerFactory;
    private SignalManagerFactory processSignalManagerFactory;
    private WorkItemManagerFactory workItemManagerFactory;
    private transient ClassLoader classLoader;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.sequential);
        out.writeObject(this.sequentialAgenda);
        out.writeBoolean(this.maintainTms);
        out.writeBoolean(this.removeIdentities);
        out.writeBoolean(this.shareAlphaNodes);
        out.writeBoolean(this.shareBetaNodes);
        out.writeInt(this.alphaNodeHashingThreshold);
        out.writeInt(this.compositeKeyDepth);
        out.writeBoolean(this.indexLeftBetaMemory);
        out.writeBoolean(this.indexRightBetaMemory);
        out.writeObject(this.assertBehaviour);
        out.writeObject(this.logicalOverride);
        out.writeObject(this.executorService);
        out.writeObject(this.consequenceExceptionHandler);
        out.writeObject(this.ruleBaseUpdateHandler);
        out.writeObject(this.conflictResolver);
        out.writeObject(this.processNodeInstanceFactoryRegistry);
        out.writeBoolean(this.advancedProcessRuleIntegration);
        out.writeBoolean(this.multithread);
        out.writeInt(this.maxThreads);
        out.writeObject((Object)this.eventProcessingMode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.sequential = in.readBoolean();
        this.sequentialAgenda = (SequentialAgenda)in.readObject();
        this.maintainTms = in.readBoolean();
        this.removeIdentities = in.readBoolean();
        this.shareAlphaNodes = in.readBoolean();
        this.shareBetaNodes = in.readBoolean();
        this.alphaNodeHashingThreshold = in.readInt();
        this.compositeKeyDepth = in.readInt();
        this.indexLeftBetaMemory = in.readBoolean();
        this.indexRightBetaMemory = in.readBoolean();
        this.assertBehaviour = (AssertBehaviour)in.readObject();
        this.logicalOverride = (LogicalOverride)in.readObject();
        this.executorService = (String)in.readObject();
        this.consequenceExceptionHandler = (String)in.readObject();
        this.ruleBaseUpdateHandler = (String)in.readObject();
        this.conflictResolver = (ConflictResolver)in.readObject();
        this.processNodeInstanceFactoryRegistry = (NodeInstanceFactoryRegistry)in.readObject();
        this.advancedProcessRuleIntegration = in.readBoolean();
        this.multithread = in.readBoolean();
        this.maxThreads = in.readInt();
        this.eventProcessingMode = (EventProcessingMode)((Object)in.readObject());
    }

    public RuleBaseConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public RuleBaseConfiguration() {
        this.init(null, null);
    }

    public RuleBaseConfiguration(ClassLoader classLoader) {
        this.init(classLoader, null);
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.sequential.agenda")) {
            this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(StringUtils.isEmpty(value) ? "sequential" : value));
        } else if (name.equals("drools.sequential")) {
            this.setSequential(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.maintainTms")) {
            this.setMaintainTms(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.removeIdentities")) {
            this.setRemoveIdentities(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.shareAlphaNodes")) {
            this.setShareAlphaNodes(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.shareBetaNodes")) {
            this.setShareBetaNodes(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.alphaNodeHashingThreshold")) {
            this.setAlphaNodeHashingThreshold(StringUtils.isEmpty(value) ? 3 : Integer.parseInt(value));
        } else if (name.equals("drools.compositeKeyDepth")) {
            this.setCompositeKeyDepth(StringUtils.isEmpty(value) ? 3 : Integer.parseInt(value));
        } else if (name.equals("drools.indexLeftBetaMemory")) {
            this.setIndexLeftBetaMemory(StringUtils.isEmpty(value) ? true : Boolean.valueOf(value));
        } else if (name.equals("drools.indexRightBetaMemory")) {
            this.setIndexRightBetaMemory(StringUtils.isEmpty(value) ? true : Boolean.valueOf(value));
        } else if (name.equals("drools.assertBehaviour")) {
            this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(StringUtils.isEmpty(value) ? "identity" : value));
        } else if (name.equals("drools.logicalOverride")) {
            this.setLogicalOverride(LogicalOverride.determineLogicalOverride(StringUtils.isEmpty(value) ? "discard" : value));
        } else if (name.equals("drools.executorService")) {
            this.setExecutorService(StringUtils.isEmpty(value) ? "org.drools.concurrent.DefaultExecutorService" : value);
        } else if (name.equals("drools.consequenceExceptionHandler")) {
            this.setConsequenceExceptionHandler(StringUtils.isEmpty(value) ? "org.drools.runtime.rule.impl.DefaultConsequenceExceptionHandler" : value);
        } else if (name.equals("drools.ruleBaseUpdateHandler")) {
            this.setRuleBaseUpdateHandler(StringUtils.isEmpty(value) ? "org.drools.base.FireAllRulesRuleBaseUpdateListener" : value);
        } else if (name.equals("drools.conflictResolver")) {
            this.setConflictResolver(RuleBaseConfiguration.determineConflictResolver(StringUtils.isEmpty(value) ? "org.drools.conflict.DepthConflictResolver" : value));
        } else if (name.equals("drools.advancedProcessRuleIntegration")) {
            this.setAdvancedProcessRuleIntegration(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.multithreadEvaluation")) {
            this.setMultithreadEvaluation(StringUtils.isEmpty(value) ? false : Boolean.valueOf(value));
        } else if (name.equals("drools.maxThreads")) {
            this.setMaxThreads(StringUtils.isEmpty(value) ? -1 : Integer.parseInt(value));
        } else if (name.equals("drools.eventProcessingMode")) {
            this.setEventProcessingMode(EventProcessingMode.determineAssertBehaviour(StringUtils.isEmpty(value) ? "cloud" : value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.sequential.agenda")) {
            return this.getSequentialAgenda().toExternalForm();
        }
        if (name.equals("drools.sequential")) {
            return Boolean.toString(this.isSequential());
        }
        if (name.equals("drools.maintainTms")) {
            return Boolean.toString(this.isMaintainTms());
        }
        if (name.equals("drools.removeIdentities")) {
            return Boolean.toString(this.isRemoveIdentities());
        }
        if (name.equals("drools.shareAlphaNodes")) {
            return Boolean.toString(this.isShareAlphaNodes());
        }
        if (name.equals("drools.shareBetaNodes")) {
            return Boolean.toString(this.isShareBetaNodes());
        }
        if (name.equals("drools.alphaNodeHashingThreshold")) {
            return Integer.toString(this.getAlphaNodeHashingThreshold());
        }
        if (name.equals("drools.compositeKeyDepth")) {
            return Integer.toString(this.getCompositeKeyDepth());
        }
        if (name.equals("drools.indexLeftBetaMemory")) {
            return Boolean.toString(this.isIndexLeftBetaMemory());
        }
        if (name.equals("drools.indexRightBetaMemory")) {
            return Boolean.toString(this.isIndexRightBetaMemory());
        }
        if (name.equals("drools.assertBehaviour")) {
            return this.getAssertBehaviour().toExternalForm();
        }
        if (name.equals("drools.logicalOverride")) {
            return this.getLogicalOverride().toExternalForm();
        }
        if (name.equals("drools.executorService")) {
            return this.getExecutorService();
        }
        if (name.equals("drools.consequenceExceptionHandler")) {
            return this.getConsequenceExceptionHandler().getClass().getName();
        }
        if (name.equals("drools.ruleBaseUpdateHandler")) {
            return this.getRuleBaseUpdateHandler();
        }
        if (name.equals("drools.conflictResolver")) {
            return this.getConflictResolver().getClass().getName();
        }
        if (name.equals("drools.advancedProcessRuleIntegration")) {
            return Boolean.toString(this.isAdvancedProcessRuleIntegration());
        }
        if (name.equals("drools.multithreadEvaluation")) {
            Boolean.toString(this.isMultithreadEvaluation());
        } else {
            if (name.equals("drools.maxThreads")) {
                return Integer.toString(this.getMaxThreads());
            }
            if (name.equals("drools.eventProcessingMode")) {
                return this.getEventProcessingMode().toExternalForm();
            }
        }
        return null;
    }

    public RuleBaseConfiguration(ClassLoader classLoader, Properties properties) {
        this.init(classLoader, properties);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        this.immutable = false;
        this.classLoader = classLoader != null ? classLoader : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader());
        this.chainedProperties = new ChainedProperties("rulebase.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(this.chainedProperties.getProperty("drools.sequential.agenda", "sequential")));
        this.setSequential(Boolean.valueOf(this.chainedProperties.getProperty("drools.sequential", "false")));
        this.setMaintainTms(Boolean.valueOf(this.chainedProperties.getProperty("drools.maintainTms", "true")));
        this.setRemoveIdentities(Boolean.valueOf(this.chainedProperties.getProperty("drools.removeIdentities", "false")));
        this.setShareAlphaNodes(Boolean.valueOf(this.chainedProperties.getProperty("drools.shareAlphaNodes", "true")));
        this.setShareBetaNodes(Boolean.valueOf(this.chainedProperties.getProperty("drools.shareBetaNodes", "true")));
        this.setAlphaNodeHashingThreshold(Integer.parseInt(this.chainedProperties.getProperty("drools.alphaNodeHashingThreshold", "3")));
        this.setCompositeKeyDepth(Integer.parseInt(this.chainedProperties.getProperty("drools.compositeKeyDepth", "3")));
        this.setIndexLeftBetaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.indexLeftBetaMemory", "true")));
        this.setIndexRightBetaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.indexRightBetaMemory", "true")));
        this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(this.chainedProperties.getProperty("drools.assertBehaviour", "identity")));
        this.setLogicalOverride(LogicalOverride.determineLogicalOverride(this.chainedProperties.getProperty("drools.logicalOverride", "discard")));
        this.setExecutorService(this.chainedProperties.getProperty("drools.executorService", "org.drools.concurrent.DefaultExecutorService"));
        this.setConsequenceExceptionHandler(this.chainedProperties.getProperty("drools.consequenceExceptionHandler", "org.drools.runtime.rule.impl.DefaultConsequenceExceptionHandler"));
        this.setRuleBaseUpdateHandler(this.chainedProperties.getProperty("drools.ruleBaseUpdateHandler", "org.drools.base.FireAllRulesRuleBaseUpdateListener"));
        this.setConflictResolver(RuleBaseConfiguration.determineConflictResolver(this.chainedProperties.getProperty("drools.conflictResolver", "org.drools.conflict.DepthConflictResolver")));
        this.setAdvancedProcessRuleIntegration(Boolean.valueOf(this.chainedProperties.getProperty("drools.advancedProcessRuleIntegration", "false")));
        this.setMultithreadEvaluation(Boolean.valueOf(this.chainedProperties.getProperty("drools.multithreadEvaluation", "false")));
        this.setMaxThreads(Integer.parseInt(this.chainedProperties.getProperty("drools.maxThreads", "-1")));
        this.setEventProcessingMode(EventProcessingMode.determineAssertBehaviour(this.chainedProperties.getProperty("drools.eventProcessingMode", "cloud")));
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public boolean isMaintainTms() {
        return this.maintainTms;
    }

    public void setMaintainTms(boolean maintainTms) {
        this.checkCanChange();
        this.maintainTms = maintainTms;
    }

    public boolean isRemoveIdentities() {
        return this.removeIdentities;
    }

    public void setRemoveIdentities(boolean removeIdentities) {
        this.checkCanChange();
        this.removeIdentities = removeIdentities;
    }

    public boolean isShareAlphaNodes() {
        return this.shareAlphaNodes;
    }

    public void setShareAlphaNodes(boolean shareAlphaNodes) {
        this.checkCanChange();
        this.shareAlphaNodes = shareAlphaNodes;
    }

    public boolean isShareBetaNodes() {
        return this.shareBetaNodes;
    }

    public void setShareBetaNodes(boolean shareBetaNodes) {
        this.checkCanChange();
        this.shareBetaNodes = shareBetaNodes;
    }

    public int getAlphaNodeHashingThreshold() {
        return this.alphaNodeHashingThreshold;
    }

    public void setAlphaNodeHashingThreshold(int alphaNodeHashingThreshold) {
        this.checkCanChange();
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public AssertBehaviour getAssertBehaviour() {
        return this.assertBehaviour;
    }

    public void setAssertBehaviour(AssertBehaviour assertBehaviour) {
        this.checkCanChange();
        this.assertBehaviour = assertBehaviour;
    }

    public EventProcessingMode getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    public void setEventProcessingMode(EventProcessingMode mode) {
        this.checkCanChange();
        this.eventProcessingMode = mode;
    }

    public int getCompositeKeyDepth() {
        return this.compositeKeyDepth;
    }

    public void setCompositeKeyDepth(int compositeKeyDepth) {
        if (!this.immutable) {
            if (compositeKeyDepth > 3) {
                throw new UnsupportedOperationException("compositeKeyDepth cannot be greater than 3");
            }
        } else {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
        this.compositeKeyDepth = compositeKeyDepth;
    }

    public boolean isIndexLeftBetaMemory() {
        return this.indexLeftBetaMemory;
    }

    public void setIndexLeftBetaMemory(boolean indexLeftBetaMemory) {
        this.checkCanChange();
        this.indexLeftBetaMemory = indexLeftBetaMemory;
    }

    public boolean isIndexRightBetaMemory() {
        return this.indexRightBetaMemory;
    }

    public void setIndexRightBetaMemory(boolean indexRightBetaMemory) {
        this.checkCanChange();
        this.indexRightBetaMemory = indexRightBetaMemory;
    }

    public LogicalOverride getLogicalOverride() {
        return this.logicalOverride;
    }

    public void setLogicalOverride(LogicalOverride logicalOverride) {
        this.checkCanChange();
        this.logicalOverride = logicalOverride;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.checkCanChange();
        this.executorService = executorService;
    }

    public String getConsequenceExceptionHandler() {
        return this.consequenceExceptionHandler;
    }

    public void setConsequenceExceptionHandler(String consequenceExceptionHandler) {
        this.checkCanChange();
        this.consequenceExceptionHandler = consequenceExceptionHandler;
    }

    public String getRuleBaseUpdateHandler() {
        return this.ruleBaseUpdateHandler;
    }

    public void setRuleBaseUpdateHandler(String ruleBaseUpdateHandler) {
        this.checkCanChange();
        this.ruleBaseUpdateHandler = ruleBaseUpdateHandler;
    }

    public AgendaGroupFactory getAgendaGroupFactory() {
        if (this.isSequential()) {
            if (this.sequentialAgenda == SequentialAgenda.SEQUENTIAL) {
                return ArrayAgendaGroupFactory.getInstance();
            }
            return PriorityQueueAgendaGroupFactory.getInstance();
        }
        return PriorityQueueAgendaGroupFactory.getInstance();
    }

    public SequentialAgenda getSequentialAgenda() {
        return this.sequentialAgenda;
    }

    public void setSequentialAgenda(SequentialAgenda sequentialAgenda) {
        this.checkCanChange();
        this.sequentialAgenda = sequentialAgenda;
    }

    public NodeInstanceFactoryRegistry getProcessNodeInstanceFactoryRegistry() {
        if (this.processNodeInstanceFactoryRegistry == null) {
            this.initProcessNodeInstanceFactoryRegistry();
        }
        return this.processNodeInstanceFactoryRegistry;
    }

    public void setMultithreadEvaluation(boolean enableMultithread) {
        this.checkCanChange();
        this.multithread = enableMultithread;
    }

    public boolean isMultithreadEvaluation() {
        return this.multithread;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    private void initProcessNodeInstanceFactoryRegistry() {
        this.processNodeInstanceFactoryRegistry = new NodeInstanceFactoryRegistry();
        String[] locations = this.chainedProperties.getProperty("processNodeInstanceFactoryRegistry", "").split("\\s");
        boolean i = false;
        for (String factoryLocation : locations) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadProcessNodeInstanceFactoryRegistry(factoryLocation);
        }
    }

    private void loadProcessNodeInstanceFactoryRegistry(String factoryLocation) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(factoryLocation, null, RuleBaseConfiguration.class));
        Map map = (Map)MVEL.eval((String)content, new HashMap());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.processNodeInstanceFactoryRegistry.register((Class)entry.getKey(), (NodeInstanceFactory)entry.getValue());
            }
        }
    }

    public ProcessInstanceFactoryRegistry getProcessInstanceFactoryRegistry() {
        if (this.processInstanceFactoryRegistry == null) {
            this.initProcessInstanceFactoryRegistry();
        }
        return this.processInstanceFactoryRegistry;
    }

    private void initProcessInstanceFactoryRegistry() {
        this.processInstanceFactoryRegistry = new ProcessInstanceFactoryRegistry();
        String[] locations = this.chainedProperties.getProperty("processInstanceFactoryRegistry", "").split("\\s");
        boolean i = false;
        for (String factoryLocation : locations) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadProcessInstanceFactoryRegistry(factoryLocation);
        }
    }

    private void loadProcessInstanceFactoryRegistry(String factoryLocation) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(factoryLocation, null, RuleBaseConfiguration.class));
        Map map = (Map)MVEL.eval((String)content, new HashMap());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.processInstanceFactoryRegistry.register((Class)entry.getKey(), (ProcessInstanceFactory)entry.getValue());
            }
        }
    }

    public Map<String, WorkDefinition> getProcessWorkDefinitions() {
        if (this.workDefinitions == null) {
            this.initWorkDefinitions();
        }
        return this.workDefinitions;
    }

    private void initWorkDefinitions() {
        String[] locations;
        this.workDefinitions = new HashMap<String, WorkDefinition>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workDefinitions", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItems(factoryLocation);
        }
    }

    private void loadWorkItems(String location) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        try {
            List workDefinitionsMap = (List)MVEL.eval((String)content, new HashMap());
            for (Map workDefinitionMap : workDefinitionsMap) {
                WorkDefinitionExtensionImpl workDefinition = new WorkDefinitionExtensionImpl();
                workDefinition.setName((String)workDefinitionMap.get("name"));
                workDefinition.setDisplayName((String)workDefinitionMap.get("displayName"));
                workDefinition.setIcon((String)workDefinitionMap.get("icon"));
                workDefinition.setCustomEditor((String)workDefinitionMap.get("customEditor"));
                HashSet<ParameterDefinition> parameters = new HashSet<ParameterDefinition>();
                Map parameterMap = (Map)workDefinitionMap.get("parameters");
                if (parameterMap != null) {
                    for (Map.Entry entry : parameterMap.entrySet()) {
                        parameters.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                    }
                }
                workDefinition.setParameters(parameters);
                HashSet<ParameterDefinition> results = new HashSet<ParameterDefinition>();
                Map resultMap = (Map)workDefinitionMap.get("results");
                if (resultMap != null) {
                    for (Map.Entry entry : resultMap.entrySet()) {
                        results.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                    }
                }
                workDefinition.setResults(results);
                this.workDefinitions.put(workDefinition.getName(), workDefinition);
            }
        }
        catch (Throwable t) {
            System.err.println("Error occured while loading work definitions " + location);
            System.err.println("Continuing without reading these work definitions");
            t.printStackTrace();
        }
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers();
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers() {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation);
        }
    }

    private void loadWorkItemHandlers(String location) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)MVEL.eval((String)content, new HashMap());
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public ContextInstanceFactoryRegistry getProcessContextInstanceFactoryRegistry() {
        if (this.processContextInstanceFactoryRegistry == null) {
            this.initProcessContextInstanceFactoryRegistry();
        }
        return this.processContextInstanceFactoryRegistry;
    }

    private void initProcessContextInstanceFactoryRegistry() {
        this.processContextInstanceFactoryRegistry = new ContextInstanceFactoryRegistry();
        String[] locations = this.chainedProperties.getProperty("processContextInstanceFactoryRegistry", "").split("\\s");
        boolean i = false;
        for (String factoryLocation : locations) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadProcessContextInstanceFactoryRegistry(factoryLocation);
        }
    }

    private void loadProcessContextInstanceFactoryRegistry(String factoryLocation) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(factoryLocation, null, RuleBaseConfiguration.class));
        Map map = (Map)MVEL.eval((String)content, new HashMap());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.processContextInstanceFactoryRegistry.register((Class)entry.getKey(), (ContextInstanceFactory)entry.getValue());
            }
        }
    }

    public ProcessInstanceManagerFactory getProcessInstanceManagerFactory() {
        if (this.processInstanceManagerFactory == null) {
            this.initProcessInstanceManagerFactory();
        }
        return this.processInstanceManagerFactory;
    }

    private void initProcessInstanceManagerFactory() {
        String className = this.chainedProperties.getProperty("processInstanceManagerFactory", "org.drools.process.instance.impl.DefaultProcessInstanceManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.processInstanceManagerFactory = (ProcessInstanceManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate process instance manager factory '" + className + "'");
            }
        } else {
            throw new IllegalArgumentException("Process instance manager factory '" + className + "' not found");
        }
    }

    public SignalManagerFactory getSignalManagerFactory() {
        if (this.processSignalManagerFactory == null) {
            this.initSignalManagerFactory();
        }
        return this.processSignalManagerFactory;
    }

    private void initSignalManagerFactory() {
        String className = this.chainedProperties.getProperty("processSignalManagerFactory", "org.drools.process.instance.event.DefaultSignalManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.processSignalManagerFactory = (SignalManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate signal manager factory '" + className + "'");
            }
        } else {
            throw new IllegalArgumentException("Signal manager factory '" + className + "' not found");
        }
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.chainedProperties.getProperty("workItemManagerFactory", "org.drools.process.instance.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public boolean isAdvancedProcessRuleIntegration() {
        return this.advancedProcessRuleIntegration;
    }

    public void setAdvancedProcessRuleIntegration(boolean advancedProcessRuleIntegration) {
        this.advancedProcessRuleIntegration = advancedProcessRuleIntegration;
    }

    private boolean determineShadowProxy(String userValue) {
        if (this.isSequential()) {
            return false;
        }
        if (userValue != null) {
            return Boolean.valueOf(userValue);
        }
        return true;
    }

    private static ConflictResolver determineConflictResolver(String className) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                return (ConflictResolver)clazz.getMethod("getInstance", null).invoke(null, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to Conflict Resolver '" + className + "'");
            }
        }
        throw new IllegalArgumentException("conflict Resolver '" + className + "' not found");
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.checkCanChange();
        this.conflictResolver = conflictResolver;
    }

    public ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventProcessingMode {
        CLOUD("cloud"),
        STREAM("stream");

        private String string;

        private EventProcessingMode(String mode) {
            this.string = mode;
        }

        public String getId() {
            return this.string;
        }

        public String toString() {
            return this.string;
        }

        public String toExternalForm() {
            return this.string;
        }

        public static EventProcessingMode determineAssertBehaviour(String mode) {
            if (STREAM.getId().equalsIgnoreCase(mode)) {
                return STREAM;
            }
            if (CLOUD.getId().equalsIgnoreCase(mode)) {
                return CLOUD;
            }
            throw new IllegalArgumentException("Illegal enum value '" + mode + "' for EventProcessingMode");
        }
    }

    public static class SequentialAgenda
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        public static final SequentialAgenda SEQUENTIAL = new SequentialAgenda(0);
        public static final SequentialAgenda DYNAMIC = new SequentialAgenda(1);
        private int value;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public SequentialAgenda() {
        }

        private SequentialAgenda(int value) {
            this.value = value;
        }

        public static SequentialAgenda determineSequentialAgenda(String value) {
            if ("sequential".equalsIgnoreCase(value)) {
                return SEQUENTIAL;
            }
            if ("dynamic".equalsIgnoreCase(value)) {
                return DYNAMIC;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for SequentialAgenda");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return SEQUENTIAL;
                }
                case 1: {
                    return DYNAMIC;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for SequentialAgenda");
        }

        public String toExternalForm() {
            return this.value == 0 ? "sequential" : "dynamic";
        }

        public String toString() {
            return "SequentialAgenda : " + (this.value == 0 ? "sequential" : "dynamic");
        }
    }

    public static class LogicalOverride
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        public static final LogicalOverride PRESERVE = new LogicalOverride(0);
        public static final LogicalOverride DISCARD = new LogicalOverride(1);
        private int value;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public LogicalOverride() {
        }

        private LogicalOverride(int value) {
            this.value = value;
        }

        public static LogicalOverride determineLogicalOverride(String value) {
            if ("PRESERVE".equalsIgnoreCase(value)) {
                return PRESERVE;
            }
            if ("DISCARD".equalsIgnoreCase(value)) {
                return DISCARD;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for LogicalOverride");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return PRESERVE;
                }
                case 1: {
                    return DISCARD;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for LogicalOverride");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LogicalOverride) {
                return this.value == ((LogicalOverride)obj).value;
            }
            return false;
        }

        public String toExternalForm() {
            return this.value == 0 ? "preserve" : "discard";
        }

        public String toString() {
            return "LogicalOverride : " + (this.value == 0 ? "preserve" : "discard");
        }
    }

    public static class AssertBehaviour
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        public static final AssertBehaviour IDENTITY = new AssertBehaviour(0);
        public static final AssertBehaviour EQUALITY = new AssertBehaviour(1);
        private int value;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public AssertBehaviour() {
        }

        private AssertBehaviour(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AssertBehaviour) {
                AssertBehaviour that = (AssertBehaviour)obj;
                return this.value == that.value;
            }
            return false;
        }

        public static AssertBehaviour determineAssertBehaviour(String value) {
            if ("IDENTITY".equalsIgnoreCase(value)) {
                return IDENTITY;
            }
            if ("EQUALITY".equalsIgnoreCase(value)) {
                return EQUALITY;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for AssertBehaviour");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return IDENTITY;
                }
                case 1: {
                    return EQUALITY;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for AssertBehaviour");
        }

        public String toExternalForm() {
            return this.value == 0 ? "identity" : "equality";
        }

        public String toString() {
            return "AssertBehaviour : " + (this.value == 0 ? "identity" : "equality");
        }
    }
}

