/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.drools.ClockType;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.util.ChainedProperties;
import org.drools.util.StringUtils;

public class SessionConfiguration
implements KnowledgeSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 500L;
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private ClockType clockType;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
    }

    public SessionConfiguration(Properties properties) {
        this.init(properties);
    }

    public SessionConfiguration() {
        this.init(null);
    }

    private void init(Properties properties) {
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("rulebase.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.valueOf(this.chainedProperties.getProperty("drools.keepReference", "true")));
        this.setClockType(ClockType.resolveClockType(this.chainedProperties.getProperty("drools.clockType", "realtime")));
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) ? true : Boolean.parseBoolean(value));
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.keepReference);
        }
        if (name.equals("drools.clockType")) {
            return this.clockType.toExternalForm();
        }
        return null;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }
}

