/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.agent.AgentEventListener;
import org.drools.agent.DirectoryScanner;
import org.drools.agent.FileScanner;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.URLScanner;
import org.drools.rule.Package;

public class RuleAgent {
    public static final String NEW_INSTANCE = "newInstance";
    public static final String FILES = "file";
    public static final String DIRECTORY = "dir";
    public static final String URLS = "url";
    public static final String POLL_INTERVAL = "poll";
    public static final String CONFIG_NAME = "name";
    public static final String LOCAL_URL_CACHE = "localCacheDir";
    public static Map PACKAGE_PROVIDERS = new HashMap(){
        {
            this.put(RuleAgent.FILES, FileScanner.class);
            this.put(RuleAgent.DIRECTORY, DirectoryScanner.class);
            this.put(RuleAgent.URLS, URLScanner.class);
        }
    };
    String name;
    private boolean newInstance;
    private RuleBase ruleBase;
    private RuleBaseConfiguration ruleBaseConf;
    private Timer timer;
    List providers;
    Map packages = new HashMap();
    AgentEventListener listener = this.getDefaultListener();
    private int secondsToRefresh;

    public static RuleAgent newRuleAgent(Properties config) {
        return RuleAgent.newRuleAgent(config, null, null);
    }

    public static RuleAgent newRuleAgent(Properties config, RuleBaseConfiguration ruleBaseConf) {
        return RuleAgent.newRuleAgent(config, null, ruleBaseConf);
    }

    public static RuleAgent newRuleAgent(Properties config, AgentEventListener listener) {
        return RuleAgent.newRuleAgent(config, listener, null);
    }

    public static RuleAgent newRuleAgent(Properties config, AgentEventListener listener, RuleBaseConfiguration ruleBaseConf) {
        RuleAgent agent = new RuleAgent(ruleBaseConf);
        if (listener != null) {
            agent.listener = listener;
        }
        if (ruleBaseConf == null) {
            agent.init(config, true);
        } else {
            agent.init(config);
        }
        return agent;
    }

    void init(Properties config) {
        this.init(config, false);
    }

    void init(Properties config, boolean lookForRuleBaseConfigurations) {
        boolean newInstance = Boolean.valueOf(config.getProperty(NEW_INSTANCE, "false"));
        int secondsToRefresh = Integer.parseInt(config.getProperty(POLL_INTERVAL, "-1"));
        String name = config.getProperty(CONFIG_NAME, "default");
        this.listener.setAgentName(name);
        this.listener.info("Configuring with newInstance=" + newInstance + ", secondsToRefresh=" + secondsToRefresh);
        ArrayList<PackageProvider> provs = new ArrayList<PackageProvider>();
        Properties droolsProperties = new Properties();
        for (String string : config.keySet()) {
            if (this.ruleBaseConf != null && string.startsWith("drools.")) {
                droolsProperties.setProperty(string, config.getProperty(string));
                continue;
            }
            PackageProvider prov = this.getProvider(string, config);
            if (prov == null) continue;
            this.listener.info("Configuring package provider : " + prov.toString());
            provs.add(prov);
        }
        if (lookForRuleBaseConfigurations && !droolsProperties.isEmpty()) {
            this.ruleBaseConf = new RuleBaseConfiguration(droolsProperties);
        }
        this.configure(newInstance, provs, secondsToRefresh);
    }

    public static RuleAgent newRuleAgent(String propsFileName) {
        return RuleAgent.newRuleAgent(RuleAgent.loadFromProperties(propsFileName));
    }

    public static RuleAgent newRuleAgent(String propsFileName, RuleBaseConfiguration ruleBaseConfiguration) {
        return RuleAgent.newRuleAgent(RuleAgent.loadFromProperties(propsFileName), ruleBaseConfiguration);
    }

    public static RuleAgent newRuleAgent(String propsFileName, AgentEventListener listener) {
        return RuleAgent.newRuleAgent(RuleAgent.loadFromProperties(propsFileName), listener);
    }

    public static RuleAgent newRuleAgent(String propsFileName, AgentEventListener listener, RuleBaseConfiguration ruleBaseConfiguration) {
        return RuleAgent.newRuleAgent(RuleAgent.loadFromProperties(propsFileName), listener, ruleBaseConfiguration);
    }

    public void setName(String name) {
        this.name = name;
        if (this.listener != null) {
            this.listener.setAgentName(this.name);
        }
    }

    static Properties loadFromProperties(String propsFileName) {
        InputStream in = RuleAgent.class.getResourceAsStream(propsFileName);
        Properties props = new Properties();
        try {
            props.load(in);
            return props;
        }
        catch (IOException e) {
            throw new RuntimeDroolsException("Unable to load properties. Needs to be the path and name of a config file on your classpath.", e);
        }
    }

    private PackageProvider getProvider(String key, Properties config) {
        if (!PACKAGE_PROVIDERS.containsKey(key)) {
            return null;
        }
        Class clz = (Class)PACKAGE_PROVIDERS.get(key);
        try {
            PackageProvider prov = (PackageProvider)clz.newInstance();
            prov.setAgentListener(this.listener);
            prov.configure(config);
            return prov;
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Unable to load up a package provider for " + key, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Unable to load up a package provider for " + key, e);
        }
    }

    synchronized void configure(boolean newInstance, List provs, int secondsToRefresh) {
        this.newInstance = newInstance;
        this.providers = provs;
        this.refreshRuleBase();
        if (secondsToRefresh != -1) {
            this.startPolling(secondsToRefresh);
        }
    }

    public void refreshRuleBase() {
        ArrayList<Package> changedPackages = new ArrayList<Package>();
        ArrayList<String> removedPackages = new ArrayList<String>();
        for (PackageProvider prov : this.providers) {
            PackageChangeInfo info = this.checkForChanges(prov);
            Collection<Package> changes = info.getChangedPackages();
            Collection<String> removed = info.getRemovedPackages();
            if (changes != null && changes.size() > 0) {
                changedPackages.addAll(changes);
            }
            if (removed == null || removed.size() <= 0) continue;
            removedPackages.addAll(removed);
        }
        if (changedPackages.size() > 0 || removedPackages.size() > 0) {
            this.listener.info("Applying changes to the rulebase.");
            if (this.newInstance) {
                this.listener.info("Creating a new rulebase as per settings.");
                this.ruleBase = RuleBaseFactory.newRuleBase(this.ruleBaseConf);
                for (String name : removedPackages) {
                    this.packages.remove(name);
                }
                for (Package element : changedPackages) {
                    this.packages.put(element.getName(), element);
                }
                PackageProvider.applyChanges(this.ruleBase, false, this.packages.values(), this.listener);
            } else {
                PackageProvider.applyChanges(this.ruleBase, true, changedPackages, removedPackages, this.listener);
            }
        }
    }

    private synchronized PackageChangeInfo checkForChanges(PackageProvider prov) {
        this.listener.debug("SCANNING FOR CHANGE " + prov.toString());
        if (this.ruleBase == null) {
            this.ruleBase = RuleBaseFactory.newRuleBase(this.ruleBaseConf);
        }
        PackageChangeInfo info = prov.loadPackageChanges();
        return info;
    }

    static List list(String property) {
        if (property == null) {
            return Collections.EMPTY_LIST;
        }
        char[] cs = property.toCharArray();
        boolean inquotes = false;
        ArrayList<String> items = new ArrayList<String>();
        String current = "";
        block3: for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            switch (c) {
                case '\"': {
                    if (inquotes) {
                        items.add(current);
                        current = "";
                    }
                    inquotes = !inquotes;
                    continue block3;
                }
                default: {
                    if (!(inquotes || c != ' ' && c != '\n' && c != '\r' && c != '\t')) {
                        if (current.trim() == "") continue block3;
                        items.add(current);
                        current = "";
                        continue block3;
                    }
                    current = current + c;
                }
            }
        }
        if (current.trim() != "") {
            items.add(current);
        }
        return items;
    }

    public synchronized RuleBase getRuleBase() {
        return this.ruleBase;
    }

    RuleAgent(RuleBaseConfiguration ruleBaseConf) {
        this.ruleBaseConf = ruleBaseConf == null ? new RuleBaseConfiguration() : ruleBaseConf;
    }

    public synchronized void stopPolling() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public synchronized void startPolling() {
        if (this.timer == null) {
            this.startPolling(this.secondsToRefresh);
        }
    }

    public synchronized void startPolling(int secondsToRefresh) {
        if (this.timer != null) {
            if (this.secondsToRefresh != secondsToRefresh) {
                this.stopPolling();
            } else {
                return;
            }
        }
        this.secondsToRefresh = secondsToRefresh;
        int interval = this.secondsToRefresh * 1000;
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                try {
                    RuleAgent.this.listener.debug("Checking for updates.");
                    RuleAgent.this.refreshRuleBase();
                }
                catch (Exception e) {
                    RuleAgent.this.listener.exception(e);
                }
            }
        }, interval, (long)interval);
    }

    boolean isNewInstance() {
        return this.newInstance;
    }

    public synchronized boolean isPolling() {
        return this.timer != null;
    }

    private AgentEventListener getDefaultListener() {
        return new AgentEventListener(){
            private String name;

            public String time() {
                Date d = new Date();
                return d.toString();
            }

            public void exception(Exception e) {
                System.err.println("RuleAgent(" + this.name + ") EXCEPTION (" + this.time() + "): " + e.getMessage() + ". Stack trace should follow.");
                e.printStackTrace(System.err);
            }

            public void info(String message) {
                System.err.println("RuleAgent(" + this.name + ") INFO (" + this.time() + "): " + message);
            }

            public void warning(String message) {
                System.err.println("RuleAgent(" + this.name + ") WARNING (" + this.time() + "): " + message);
            }

            public void debug(String message) {
            }

            public void setAgentName(String name) {
                this.name = name;
            }

            public void debug(String message, Object object) {
            }

            public void info(String message, Object object) {
            }

            public void warning(String message, Object object) {
            }
        };
    }

    RuleBaseConfiguration getRuleBaseConfiguration() {
        return this.ruleBaseConf;
    }
}

