/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.ClassUtils;
import org.drools.util.asm.ClassFieldInspector;

public abstract class BaseClassFieldReader
implements InternalReadAccessor {
    private int index;
    private Class<?> fieldType;
    private ValueType valueType;

    public BaseClassFieldReader() {
    }

    protected BaseClassFieldReader(int index, Class fieldType, ValueType valueType) {
        this.index = index;
        this.fieldType = fieldType;
        this.valueType = valueType;
    }

    public BaseClassFieldReader(Class clazz, String fieldName) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(clazz);
            this.index = inspector.getFieldNames().get(fieldName);
            this.fieldType = inspector.getFieldTypes().get(fieldName);
            this.valueType = ValueType.determineValueType(this.fieldType);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Class getExtractToClass() {
        return this.fieldType;
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.fieldType);
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isGlobal() {
        return false;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fieldType.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseClassFieldReader)) {
            return false;
        }
        BaseClassFieldReader other = (BaseClassFieldReader)object;
        return this.fieldType == other.fieldType && this.index == other.index && this.valueType.equals(other.valueType);
    }

    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    public char getCharValue(Object object) {
        return this.getCharValue(null, object);
    }

    public int getIntValue(Object object) {
        return this.getIntValue(null, object);
    }

    public byte getByteValue(Object object) {
        return this.getByteValue(null, object);
    }

    public short getShortValue(Object object) {
        return this.getShortValue(null, object);
    }

    public long getLongValue(Object object) {
        return this.getLongValue(null, object);
    }

    public float getFloatValue(Object object) {
        return this.getFloatValue(null, object);
    }

    public double getDoubleValue(Object object) {
        return this.getDoubleValue(null, object);
    }

    public boolean getBooleanValue(Object object) {
        return this.getBooleanValue(null, object);
    }

    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }
}

