/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.spi.Activation;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;

public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 400L;
    private Rule rule;
    private GroupElement subrule;
    private Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.activation = (Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
    }

    public void setActivation(Activation agendaItem) {
        this.rule = agendaItem.getRule();
        this.subrule = agendaItem.getSubRule();
        this.activation = agendaItem;
        this.tuple = agendaItem.getTuple();
    }

    public void reset() {
        this.rule = null;
        this.subrule = null;
        this.activation = null;
        this.tuple = null;
    }

    public void insert(Object object) throws FactException {
        this.insert(object, false);
    }

    public void insert(Object object, boolean dynamic) throws FactException {
        this.workingMemory.insert(object, dynamic, false, this.rule, this.activation);
    }

    public void insertLogical(Object object) throws FactException {
        this.insertLogical(object, false);
    }

    public void insertLogical(Object object, boolean dynamic) throws FactException {
        this.workingMemory.insert(object, dynamic, true, this.rule, this.activation);
    }

    public void update(FactHandle handle, Object newObject) throws FactException {
        this.workingMemory.update(handle, newObject, this.rule, this.activation);
    }

    public void update(Object object) throws FactException {
        FactHandle handle = this.workingMemory.getFactHandleByIdentity(object);
        if (handle == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.workingMemory.update(handle, object, this.rule, this.activation);
    }

    public void retract(FactHandle handle) throws FactException {
        this.workingMemory.retract(handle, true, true, this.rule, this.activation);
    }

    public void retract(Object object) throws FactException {
        FactHandle handle = this.workingMemory.getFactHandleByIdentity(object);
        if (handle == null) {
            throw new FactException("Retract error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.workingMemory.retract(handle, true, true, this.rule, this.activation);
    }

    public void modifyRetract(Object object) {
        FactHandle handle = this.workingMemory.getFactHandleByIdentity(object);
        this.workingMemory.modifyRetract(handle, this.rule, this.activation);
    }

    public void modifyRetract(FactHandle factHandle) {
        this.workingMemory.modifyRetract(factHandle, this.rule, this.activation);
    }

    public void modifyInsert(Object object) {
        FactHandle handle = this.workingMemory.getFactHandleByIdentity(object);
        this.workingMemory.modifyInsert(handle, object, this.rule, this.activation);
    }

    public void modifyInsert(FactHandle factHandle, Object object) {
        this.workingMemory.modifyInsert(factHandle, object, this.rule, this.activation);
    }

    public Rule getRule() {
        return this.rule;
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public KnowledgeRuntime getKnowledgeRuntime() {
        return new StatefulKnowledgeSessionImpl((ReteooStatefulSession)this.workingMemory);
    }

    public Activation getActivation() {
        return this.activation;
    }

    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    public Object get(Declaration declaration) {
        return declaration.getValue(this.workingMemory, this.tuple.get(declaration).getObject());
    }

    public Declaration getDeclaration(String identifier) {
        return (Declaration)this.subrule.getOuterDeclarations().get(identifier);
    }

    public void halt() {
        this.workingMemory.halt();
    }
}

