/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.base.accumulators.AccumulateFunction;

public class MaxAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new MaxData();
    }

    public void init(Serializable context) throws Exception {
        MaxData data = (MaxData)context;
        data.max = Double.MIN_VALUE;
    }

    public void accumulate(Serializable context, Object value) {
        MaxData data = (MaxData)context;
        data.max = Math.max(data.max, ((Number)value).doubleValue());
    }

    public void reverse(Serializable context, Object value) throws Exception {
    }

    public Object getResult(Serializable context) throws Exception {
        MaxData data = (MaxData)context;
        return new Double(data.max);
    }

    public boolean supportsReverse() {
        return false;
    }

    protected static class MaxData
    implements Externalizable {
        public double max = Double.MIN_VALUE;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.max = in.readDouble();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.max);
        }
    }
}

