/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class AfterEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator AFTER = Operator.addOperatorToRegistry("after", false);
    public static final Operator NOT_AFTER = Operator.addOperatorToRegistry("after", true);
    private static final String[] SUPPORTED_IDS = new String[]{AFTER.getOperatorString()};
    private Map<String, Evaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        String key;
        Evaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, Evaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new AfterEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean operatesOnFactHandles() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class AfterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -4833205637340977934L;
        private long initRange;
        private long finalRange;
        private String paramText;

        public AfterEvaluator() {
        }

        public AfterEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? NOT_AFTER : AFTER);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initRange = in.readLong();
            this.finalRange = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.initRange);
            out.writeLong(this.finalRange);
            out.writeObject(this.paramText);
        }

        public Object prepareObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            long init = this.initRange;
            long end = this.finalRange;
            if (this.getOperator().isNegated()) {
                if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                    init = this.finalRange + 1L;
                    end = Long.MAX_VALUE;
                } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = Long.MIN_VALUE;
                    end = this.initRange - 1L;
                } else if (init == Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = 0L;
                    end = -1L;
                } else {
                    init = Long.MIN_VALUE;
                    end = Long.MAX_VALUE;
                }
            }
            return new Interval(init, end);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'after' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long dist = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp() - ((EventFactHandle)left).getEndTimestamp();
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long dist = ((EventFactHandle)right).getStartTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp();
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long dist = ((EventFactHandle)object1).getStartTimestamp() - ((EventFactHandle)object2).getEndTimestamp();
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        public String toString() {
            return this.getOperator().toString() + "[" + this.paramText + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
            result = 31 * result + (int)(this.initRange ^ this.initRange >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AfterEvaluator other = (AfterEvaluator)obj;
            return this.finalRange == other.finalRange && this.initRange == other.initRange;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.initRange = 1L;
                this.finalRange = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.initRange = parameters[0];
                this.finalRange = Long.MAX_VALUE;
            } else if (parameters.length == 2) {
                if (parameters[0] <= parameters[1]) {
                    this.initRange = parameters[0];
                    this.finalRange = parameters[1];
                } else {
                    this.initRange = parameters[1];
                    this.finalRange = parameters[0];
                }
            } else {
                throw new RuntimeDroolsException("[After Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

