/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class CoincidesEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator COINCIDES = Operator.addOperatorToRegistry("coincides", false);
    public static final Operator COINCIDES_NOT = Operator.addOperatorToRegistry("coincides", true);
    private static final String[] SUPPORTED_IDS = new String[]{COINCIDES.getOperatorString()};
    private Map<String, CoincidesEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        String key;
        CoincidesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, CoincidesEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new CoincidesEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean operatesOnFactHandles() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class CoincidesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 6031520837249122183L;
        private long startDev;
        private long endDev;
        private String paramText;

        public CoincidesEvaluator() {
        }

        public CoincidesEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? COINCIDES_NOT : COINCIDES);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startDev = in.readLong();
            this.endDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startDev);
            out.writeLong(this.endDev);
            out.writeObject(this.paramText);
        }

        public Object prepareObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'coincides' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp() - ((EventFactHandle)left).getStartTimestamp());
            long distEnd = Math.abs(((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp() - ((EventFactHandle)left).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)right).getStartTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp());
            long distEnd = Math.abs(((EventFactHandle)right).getEndTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)object1).getStartTimestamp() - ((EventFactHandle)object2).getStartTimestamp());
            long distEnd = Math.abs(((EventFactHandle)object1).getEndTimestamp() - ((EventFactHandle)object2).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public String toString() {
            return "coincides[" + this.startDev + ", " + this.endDev + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            result = 31 * result + (int)(this.startDev ^ this.startDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoincidesEvaluator other = (CoincidesEvaluator)obj;
            return this.endDev == other.endDev && this.startDev == other.startDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startDev = 0L;
                this.endDev = 0L;
                return;
            }
            for (Long param : parameters) {
                if (param >= 0L) continue;
                throw new RuntimeDroolsException("[Coincides Evaluator]: negative values not allowed for temporal distance thresholds: '" + this.paramText + "'");
            }
            if (parameters.length == 1) {
                this.startDev = parameters[0];
                this.endDev = parameters[0];
            } else if (parameters.length == 2) {
                this.startDev = parameters[0];
                this.endDev = parameters[1];
            } else {
                throw new RuntimeDroolsException("[Coincides Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

