/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class FinishedByEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator FINISHED_BY = Operator.addOperatorToRegistry("finishedby", false);
    public static final Operator NOT_FINISHED_BY = Operator.addOperatorToRegistry("finishedby", true);
    private static final String[] SUPPORTED_IDS = new String[]{FINISHED_BY.getOperatorString()};
    private Map<String, FinishedByEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        String key;
        FinishedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, FinishedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new FinishedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean operatesOnFactHandles() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class FinishedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -5156972073099070733L;
        private long endDev;
        private String paramText;

        public FinishedByEvaluator() {
        }

        public FinishedByEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? NOT_FINISHED_BY : FINISHED_BY);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.endDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.endDev);
            out.writeObject(this.paramText);
        }

        public Object prepareObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'finishedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long distStart = ((EventFactHandle)left).getStartTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)left).getEndTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long distStart = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp() - ((EventFactHandle)right).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp() - ((EventFactHandle)right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long distStart = ((EventFactHandle)object2).getStartTimestamp() - ((EventFactHandle)object1).getStartTimestamp();
            long distEnd = Math.abs(((EventFactHandle)object2).getEndTimestamp() - ((EventFactHandle)object1).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public String toString() {
            return "finishedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FinishedByEvaluator other = (FinishedByEvaluator)obj;
            return this.endDev == other.endDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.endDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeDroolsException("[FinishedBy Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeDroolsException("[FinishedBy Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.endDev = parameters[0];
            }
        }
    }
}

