/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class MeetsEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator MEETS = Operator.addOperatorToRegistry("meets", false);
    public static final Operator MEETS_NOT = Operator.addOperatorToRegistry("meets", true);
    private static final String[] SUPPORTED_IDS = new String[]{MEETS.getOperatorString()};
    private Map<String, MeetsEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        String key;
        MeetsEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, MeetsEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new MeetsEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean operatesOnFactHandles() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class MeetsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 9091548399308812447L;
        private long finalRange;
        private String paramText;

        public MeetsEvaluator() {
        }

        public MeetsEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText) {
            super(type, isNegated ? MEETS_NOT : MEETS);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.finalRange = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.finalRange);
            out.writeObject(this.paramText);
        }

        public Object prepareObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, Long.MAX_VALUE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'meets' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long leftStartTS = ((EventFactHandle)left).getStartTimestamp();
            long dist = Math.abs(leftStartTS - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp());
            return this.getOperator().isNegated() ^ dist <= this.finalRange;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long leftStartTS = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp();
            long dist = Math.abs(leftStartTS - ((EventFactHandle)right).getEndTimestamp());
            return this.getOperator().isNegated() ^ dist <= this.finalRange;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long obj2StartTS = ((EventFactHandle)object2).getStartTimestamp();
            long dist = Math.abs(obj2StartTS - ((EventFactHandle)object1).getEndTimestamp());
            return this.getOperator().isNegated() ^ dist <= this.finalRange;
        }

        public String toString() {
            return "meets[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeetsEvaluator other = (MeetsEvaluator)obj;
            return this.finalRange == other.finalRange;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.finalRange = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeDroolsException("[Meets Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeDroolsException("[Meets Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.finalRange = parameters[0];
            }
        }
    }
}

