/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class StartedByEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator STARTED_BY = Operator.addOperatorToRegistry("startedby", false);
    public static final Operator NOT_STARTED_BY = Operator.addOperatorToRegistry("startedby", true);
    private static final String[] SUPPORTED_IDS = new String[]{STARTED_BY.getOperatorString()};
    private Map<String, StartedByEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        String key;
        StartedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, StartedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new StartedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean operatesOnFactHandles() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class StartedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -2655549435451501420L;
        private long startDev;
        private String paramText;

        public StartedByEvaluator() {
        }

        public StartedByEvaluator(ValueType type, boolean isNegated, Long[] params, String paramText) {
            super(type, isNegated ? NOT_STARTED_BY : STARTED_BY);
            this.paramText = paramText;
            this.setParameters(params);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startDev);
            out.writeObject(this.paramText);
        }

        public Object prepareObject(InternalFactHandle handle) {
            return handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'startedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp() - ((EventFactHandle)left).getStartTimestamp());
            long distEnd = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp() - ((EventFactHandle)left).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd > 0L);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)right).getStartTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp());
            long distEnd = ((EventFactHandle)right).getEndTimestamp() - ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd > 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long distStart = Math.abs(((EventFactHandle)object1).getStartTimestamp() - ((EventFactHandle)object2).getStartTimestamp());
            long distEnd = ((EventFactHandle)object1).getEndTimestamp() - ((EventFactHandle)object2).getEndTimestamp();
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd > 0L);
        }

        public String toString() {
            return "startedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.startDev ^ this.startDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StartedByEvaluator other = (StartedByEvaluator)obj;
            return this.startDev == other.startDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeDroolsException("[StartedBy Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeDroolsException("[StartedBy Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.startDev = parameters[0];
            }
        }
    }
}

