/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.RuntimeDroolsException;
import org.drools.base.evaluators.EvaluatorParametersParser;

public class TimeIntervalParser
implements EvaluatorParametersParser {
    private static final Pattern SIMPLE = Pattern.compile("([+-])?((\\d+)[Dd])?\\s*((\\d+)[Hh])?\\s*((\\d+)[Mm])?\\s*((\\d+)[Ss])?\\s*((\\d+)([Mm][Ss])?)?");
    private static final int SIM_SGN = 1;
    private static final int SIM_DAY = 3;
    private static final int SIM_HOU = 5;
    private static final int SIM_MIN = 7;
    private static final int SIM_SEC = 9;
    private static final int SIM_MS = 11;
    private static final long SEC_MS = 1000L;
    private static final long MIN_MS = 60000L;
    private static final long HOU_MS = 3600000L;
    private static final long DAY_MS = 86400000L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long[] parse(String paramText) {
        if (paramText == null || paramText.trim().length() == 0) {
            return new Long[0];
        }
        String[] params = paramText.split(",");
        Long[] result = new Long[params.length];
        int index = 0;
        for (String param : params) {
            String trimmed = param.trim();
            if (trimmed.length() <= 0) throw new RuntimeDroolsException("Empty parameters not allowed in: [" + paramText + "]");
            Matcher mat = SIMPLE.matcher(trimmed);
            if (mat.matches()) {
                int days = mat.group(3) != null ? Integer.parseInt(mat.group(3)) : 0;
                int hours = mat.group(5) != null ? Integer.parseInt(mat.group(5)) : 0;
                int min = mat.group(7) != null ? Integer.parseInt(mat.group(7)) : 0;
                int sec = mat.group(9) != null ? Integer.parseInt(mat.group(9)) : 0;
                int ms = mat.group(11) != null ? Integer.parseInt(mat.group(11)) : 0;
                long r = (long)days * 86400000L + (long)hours * 3600000L + (long)min * 60000L + (long)sec * 1000L + (long)ms;
                if (mat.group(1) != null && mat.group(1).equals("-")) {
                    r = -r;
                }
                result[index] = new Long(r);
            } else if ("*".equals(trimmed) || "+*".equals(trimmed)) {
                result[index] = Long.MAX_VALUE;
            } else {
                if (!"-*".equals(trimmed)) throw new RuntimeDroolsException("Error parsing interval value: " + param);
                result[index] = Long.MIN_VALUE;
            }
            ++index;
        }
        return result;
    }
}

