/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.DefaultFactHandle;

public class EventFactHandle
extends DefaultFactHandle {
    private static final long serialVersionUID = 5997141759543399455L;
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private long activationsCount;

    public EventFactHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object) {
        super(id, object);
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency) {
        super(id, object, recency);
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration) {
        super(id, object, recency);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    public String toExternalForm() {
        return "[event fid:" + this.getId() + ":" + this.getRecency() + ":" + this.getObject() + "]";
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean isEvent() {
        return true;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public long getActivationsCount() {
        return this.activationsCount;
    }

    public void increaseActivationsCount() {
        ++this.activationsCount;
    }

    public void decreaseActivationsCount() {
        --this.activationsCount;
    }
}

