/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.Agenda;
import org.drools.ClockType;
import org.drools.common.InternalAgenda;
import org.drools.common.ScheduledAgendaItem;
import org.drools.process.instance.timer.TimerManager;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.TimerServiceFactory;

final class Scheduler {
    private static final Scheduler INSTANCE = new Scheduler();
    private final TimerService timerService = TimerServiceFactory.getTimerService(ClockType.REALTIME_CLOCK);

    static Scheduler getInstance() {
        return INSTANCE;
    }

    private Scheduler() {
    }

    void scheduleAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda) {
        DuractionJob job = new DuractionJob();
        DuractionJobContext ctx = new DuractionJobContext(item, agenda);
        TimerManager.TimerTrigger trigger = new TimerManager.TimerTrigger(item.getRule().getDuration().getDuration(item.getTuple()), 0L);
        JobHandle jobHandle = this.timerService.scheduleJob(job, ctx, trigger);
        item.setJobHandle(jobHandle);
    }

    public void removeAgendaItem(ScheduledAgendaItem item) {
        this.timerService.removeJob(item.getJobHandle());
    }

    public static class DuractionJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private ScheduledAgendaItem scheduledAgendaItem;
        private Agenda agenda;

        public DuractionJobContext(ScheduledAgendaItem scheduledAgendaItem, Agenda agenda) {
            this.scheduledAgendaItem = scheduledAgendaItem;
            this.agenda = agenda;
        }

        public DuractionJobContext(ScheduledAgendaItem scheduledAgendaItem) {
            this.scheduledAgendaItem = scheduledAgendaItem;
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public ScheduledAgendaItem getScheduledAgendaItem() {
            return this.scheduledAgendaItem;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }
    }

    public static class DuractionJob
    implements Job {
        public void execute(JobContext ctx) {
            InternalAgenda agenda = (InternalAgenda)((DuractionJobContext)ctx).getAgenda();
            ScheduledAgendaItem item = ((DuractionJobContext)ctx).getScheduledAgendaItem();
            agenda.fireActivation(item);
            agenda.getScheduledActivationsLinkedList().remove(item);
            agenda.getWorkingMemory().fireAllRules();
        }
    }
}

