/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.drools.RuleBaseConfiguration;
import org.drools.common.EqualityAssertMapComparator;
import org.drools.common.IdentityAssertMapComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.ObjectStore;
import org.drools.runtime.ObjectFilter;
import org.drools.util.AbstractHashTable;
import org.drools.util.JavaIteratorAdapter;
import org.drools.util.ObjectHashMap;

public class SingleThreadedObjectStore
implements Externalizable,
ObjectStore {
    private ObjectHashMap assertMap;
    private ObjectHashMap identityMap;
    private RuleBaseConfiguration.AssertBehaviour behaviour;
    private Lock lock;

    public SingleThreadedObjectStore() {
    }

    public SingleThreadedObjectStore(RuleBaseConfiguration conf, Lock lock) {
        this.behaviour = conf.getAssertBehaviour();
        this.lock = lock;
        this.assertMap = new ObjectHashMap();
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals(this.behaviour)) {
            this.assertMap.setComparator(new IdentityAssertMapComparator());
            this.identityMap = this.assertMap;
        } else {
            this.assertMap.setComparator(new EqualityAssertMapComparator());
            this.identityMap = new ObjectHashMap();
            this.identityMap.setComparator(new IdentityAssertMapComparator());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.assertMap = (ObjectHashMap)in.readObject();
        this.identityMap = (ObjectHashMap)in.readObject();
        this.behaviour = (RuleBaseConfiguration.AssertBehaviour)in.readObject();
        this.lock = (Lock)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.assertMap);
        out.writeObject(this.identityMap);
        out.writeObject(this.behaviour);
        out.writeObject(this.lock);
    }

    public int size() {
        return this.assertMap.size();
    }

    public boolean isEmpty() {
        return this.assertMap != null;
    }

    public void clear() {
        this.assertMap.clear();
        this.identityMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectForHandle(InternalFactHandle handle) {
        try {
            Object object;
            this.lock.lock();
            InternalFactHandle internalHandle = (InternalFactHandle)this.assertMap.get(handle);
            if (internalHandle == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object2 = object = internalHandle.getObject();
            return object2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public InternalFactHandle getHandleForObject(Object object) {
        return (InternalFactHandle)this.assertMap.get(object);
    }

    public InternalFactHandle getHandleForObjectIdentity(Object object) {
        return (InternalFactHandle)this.identityMap.get(object);
    }

    public void updateHandle(InternalFactHandle handle, Object object) {
        this.assertMap.remove(handle);
        Object oldObject = handle.getObject();
        handle.setObject(object);
        this.assertMap.put(handle, handle, false);
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        this.assertMap.put(handle, handle, false);
        if (RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(this.behaviour)) {
            this.identityMap.put(handle, handle, false);
        }
    }

    public void removeHandle(InternalFactHandle handle) {
        this.assertMap.remove(handle);
        if (RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(this.behaviour)) {
            this.identityMap.remove(handle);
        }
    }

    public Iterator iterateObjects() {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.OBJECT);
    }

    public Iterator iterateObjects(ObjectFilter filter) {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.OBJECT, filter);
    }

    public Iterator iterateFactHandles() {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.FACT_HANDLE);
    }

    public Iterator iterateFactHandles(ObjectFilter filter) {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.FACT_HANDLE, filter);
    }
}

