/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.WorkingMemory;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgendaEventSupport
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private List<AgendaEventListener> listeners = new CopyOnWriteArrayList<AgendaEventListener>();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.listeners = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.listeners);
    }

    public void addEventListener(AgendaEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.listeners.remove(listener);
    }

    public List<AgendaEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireActivationCreated(Activation activation, WorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCreatedEvent event = new ActivationCreatedEvent(activation);
        for (AgendaEventListener listener : this.listeners) {
            listener.activationCreated(event, workingMemory);
        }
    }

    public void fireActivationCancelled(Activation activation, WorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCancelledEvent event = new ActivationCancelledEvent(activation);
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            this.listeners.get(i).activationCancelled(event, workingMemory);
        }
    }

    public void fireBeforeActivationFired(Activation activation, WorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeActivationFiredEvent event = new BeforeActivationFiredEvent(activation);
        for (AgendaEventListener listener : this.listeners) {
            listener.beforeActivationFired(event, workingMemory);
        }
    }

    public void fireAfterActivationFired(Activation activation, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterActivationFiredEvent event = new AfterActivationFiredEvent(activation);
        for (AgendaEventListener listener : this.listeners) {
            listener.afterActivationFired(event, workingMemory);
        }
    }

    public void fireAgendaGroupPopped(AgendaGroup agendaGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AgendaGroupPoppedEvent event = new AgendaGroupPoppedEvent(agendaGroup);
        for (AgendaEventListener listener : this.listeners) {
            listener.agendaGroupPopped(event, workingMemory);
        }
    }

    public void fireAgendaGroupPushed(AgendaGroup agendaGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AgendaGroupPushedEvent event = new AgendaGroupPushedEvent(agendaGroup);
        for (AgendaEventListener listener : this.listeners) {
            listener.agendaGroupPushed(event, workingMemory);
        }
    }

    public void reset() {
        this.listeners.clear();
    }
}

