/*
 * Decompiled with CFR 0.152.
 */
package org.drools.facttemplates;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactTemplate;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.ClassUtils;

public class FactTemplateFieldExtractor
implements Externalizable,
InternalReadAccessor {
    private static final long serialVersionUID = 400L;
    private FactTemplate factTemplate;
    private int fieldIndex;

    public FactTemplateFieldExtractor() {
    }

    public FactTemplateFieldExtractor(FactTemplate factTemplate, int fieldIndex) {
        this.factTemplate = factTemplate;
        this.fieldIndex = fieldIndex;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.fieldIndex = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeInt(this.fieldIndex);
    }

    public ValueType getValueType() {
        return this.factTemplate.getFieldTemplate(this.fieldIndex).getValueType();
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Fact)object).getFieldValue(this.fieldIndex);
    }

    public int getIndex() {
        return this.fieldIndex;
    }

    public Class getExtractToClass() {
        return this.factTemplate.getFieldTemplate(this.fieldIndex).getValueType().getClassType();
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.getExtractToClass());
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return (Boolean)((Fact)object).getFieldValue(this.fieldIndex);
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).byteValue();
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Character)((Fact)object).getFieldValue(this.fieldIndex)).charValue();
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).doubleValue();
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).floatValue();
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).intValue();
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).longValue();
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).shortValue();
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.getValue(workingMemory, object).hashCode();
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Fact)object).getFieldValue(this.fieldIndex) == null;
    }

    public boolean getBooleanValue(Object object) {
        return this.getBooleanValue(null, object);
    }

    public byte getByteValue(Object object) {
        return this.getByteValue(null, object);
    }

    public char getCharValue(Object object) {
        return this.getCharValue(null, object);
    }

    public double getDoubleValue(Object object) {
        return this.getDoubleValue(null, object);
    }

    public float getFloatValue(Object object) {
        return this.getFloatValue(null, object);
    }

    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    public int getIntValue(Object object) {
        return this.getIntValue(null, object);
    }

    public long getLongValue(Object object) {
        return this.getLongValue(null, object);
    }

    public short getShortValue(Object object) {
        return this.getShortValue(null, object);
    }

    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }
}

