/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.drools.RuntimeDroolsException;
import org.drools.SessionConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.BinaryHeapQueueAgendaGroup;
import org.drools.common.DefaultAgenda;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EqualityKey;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.concurrent.ExecutorService;
import org.drools.marshalling.MarshallerReaderContext;
import org.drools.marshalling.ObjectPlaceholder;
import org.drools.marshalling.PersisterHelper;
import org.drools.marshalling.PlaceholderResolverStrategy;
import org.drools.marshalling.PlaceholderResolverStrategyFactory;
import org.drools.marshalling.RightTupleKey;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.context.swimlane.SwimlaneContextInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.process.instance.timer.TimerManager;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CollectNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.InitialFactHandle;
import org.drools.reteoo.InitialFactHandleDummyObject;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.EntryPoint;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.spi.Activation;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.util.ObjectHashMap;
import org.drools.util.ObjectHashSet;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.node.CompositeContextNodeInstance;
import org.drools.workflow.instance.node.ForEachNodeInstance;
import org.drools.workflow.instance.node.HumanTaskNodeInstance;
import org.drools.workflow.instance.node.JoinInstance;
import org.drools.workflow.instance.node.MilestoneNodeInstance;
import org.drools.workflow.instance.node.RuleSetNodeInstance;
import org.drools.workflow.instance.node.SubProcessNodeInstance;
import org.drools.workflow.instance.node.TimerNodeInstance;
import org.drools.workflow.instance.node.WorkItemNodeInstance;

public class InputMarshaller {
    public static ReteooStatefulSession readSession(ReteooStatefulSession session, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        boolean multithread = context.readBoolean();
        int handleId = context.readInt();
        long handleCounter = context.readLong();
        long propagationCounter = context.readLong();
        context.readInt();
        context.readLong();
        session.reset(handleId, handleCounter, propagationCounter);
        DefaultAgenda agenda = (DefaultAgenda)session.getAgenda();
        InputMarshaller.readAgenda(context, agenda);
        context.wm = session;
        InputMarshaller.readFactHandles(context);
        InputMarshaller.readActionQueue(context);
        if (context.readBoolean()) {
            InputMarshaller.readTruthMaintenanceSystem(context);
        }
        InputMarshaller.readProcessInstances(context);
        InputMarshaller.readWorkItems(context);
        InputMarshaller.readTimers(context);
        if (multithread) {
            session.startPartitionManagers();
        }
        return session;
    }

    public static ReteooStatefulSession readSession(MarshallerReaderContext context, int id, ExecutorService executor) throws IOException, ClassNotFoundException {
        boolean multithread = context.readBoolean();
        FactHandleFactory handleFactory = context.ruleBase.newFactHandleFactory(context.readInt(), context.readLong());
        InitialFactHandle initialFactHandle = new InitialFactHandle(new DefaultFactHandle(context.readInt(), new InitialFactHandleDummyObject(), context.readLong()));
        context.handles.put(initialFactHandle.getId(), initialFactHandle);
        long propagationCounter = context.readLong();
        DefaultAgenda agenda = new DefaultAgenda(context.ruleBase, false);
        InputMarshaller.readAgenda(context, agenda);
        ReteooStatefulSession session = new ReteooStatefulSession(id, context.ruleBase, executor, handleFactory, initialFactHandle, propagationCounter, new SessionConfiguration(), agenda);
        for (RuleFlowGroup group : agenda.getRuleFlowGroupsMap().values()) {
            ((RuleFlowGroupImpl)group).setWorkingMemory(session);
        }
        context.wm = session;
        InputMarshaller.readFactHandles(context);
        InputMarshaller.readActionQueue(context);
        if (context.readBoolean()) {
            InputMarshaller.readTruthMaintenanceSystem(context);
        }
        InputMarshaller.readProcessInstances(context);
        InputMarshaller.readWorkItems(context);
        InputMarshaller.readTimers(context);
        if (multithread) {
            session.startPartitionManagers();
        }
        return session;
    }

    public static void readAgenda(MarshallerReaderContext context, DefaultAgenda agenda) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 13) {
            BinaryHeapQueueAgendaGroup group = new BinaryHeapQueueAgendaGroup(stream.readUTF(), context.ruleBase);
            group.setActive(stream.readBoolean());
            agenda.getAgendaGroupsMap().put(group.getName(), group);
        }
        while (stream.readShort() == 13) {
            String agendaGroupName = stream.readUTF();
            agenda.getStackList().add(agenda.getAgendaGroup(agendaGroupName));
        }
        while (stream.readShort() == 15) {
            String rfgName = stream.readUTF();
            boolean active = stream.readBoolean();
            boolean autoDeactivate = stream.readBoolean();
            RuleFlowGroupImpl rfg = new RuleFlowGroupImpl(rfgName, active, autoDeactivate);
            agenda.getRuleFlowGroupsMap().put(rfgName, rfg);
        }
    }

    public static void readActionQueue(MarshallerReaderContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        Queue<WorkingMemoryAction> actionQueue = wm.getActionQueue();
        while (context.readShort() == 10) {
            actionQueue.offer(PersisterHelper.readWorkingMemoryAction(context));
        }
    }

    public static void readTruthMaintenanceSystem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        TruthMaintenanceSystem tms = context.wm.getTruthMaintenanceSystem();
        while (stream.readShort() == 11) {
            int status = stream.readInt();
            int factHandleId = stream.readInt();
            InternalFactHandle handle = context.handles.get(factHandleId);
            EqualityKey key = new EqualityKey(handle, status);
            handle.setEqualityKey(key);
            while (stream.readShort() == 2) {
                factHandleId = stream.readInt();
                handle = context.handles.get(factHandleId);
                key.addFactHandle(handle);
                handle.setEqualityKey(key);
            }
            tms.put(key);
        }
    }

    public static void readFactHandles(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        PlaceholderResolverStrategyFactory resolverStrategyFactory = context.resolverStrategyFactory;
        InternalWorkingMemory wm = context.wm;
        if (stream.readBoolean()) {
            InternalFactHandle initialFactHandle = wm.getInitialFactHandle();
            int sinkId = stream.readInt();
            ObjectTypeNode initialFactNode = (ObjectTypeNode)context.sinks.get(sinkId);
            ObjectHashSet initialFactMemory = (ObjectHashSet)context.wm.getNodeMemory(initialFactNode);
            initialFactMemory.add(initialFactHandle);
            InputMarshaller.readRightTuples(initialFactHandle, context);
        }
        int size = stream.readInt();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        for (int i = 0; i < size; ++i) {
            InternalFactHandle handle = InputMarshaller.readFactHandle(context);
            context.handles.put(handle.getId(), handle);
            handles[i] = handle;
            context.wm.getObjectStore().addHandle(handle, handle.getObject());
            InputMarshaller.readRightTuples(handle, context);
        }
        EntryPointNode node = ruleBase.getRete().getEntryPointNode(EntryPoint.DEFAULT);
        Map<ObjectType, ObjectTypeNode> objectTypeNodes = node.getObjectTypeNodes();
        for (InternalFactHandle handle : handles) {
            Object object = handle.getObject();
            ClassObjectType objectType = new ClassObjectType(object.getClass());
            ObjectTypeNode objectTypeNode = objectTypeNodes.get(objectType);
            ObjectHashSet set = (ObjectHashSet)context.wm.getNodeMemory(objectTypeNode);
            set.add(handle, false);
        }
        InternalFactHandle handle = wm.getInitialFactHandle();
        while (stream.readShort() == 3) {
            LeftTupleSink sink = (LeftTupleSink)((Object)context.sinks.get(stream.readInt()));
            LeftTuple leftTuple = new LeftTuple(handle, sink, true);
            InputMarshaller.readLeftTuple(leftTuple, context);
        }
        InputMarshaller.readLeftTuples(context);
        InputMarshaller.readPropagationContexts(context);
        InputMarshaller.readActivations(context);
    }

    public static InternalFactHandle readFactHandle(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        int id = context.stream.readInt();
        long recency = context.stream.readLong();
        int strategyIndex = context.stream.readInt();
        PlaceholderResolverStrategy strategy = context.resolverStrategyFactory.getStrategy(strategyIndex);
        ObjectPlaceholder placeHolder = strategy.read(context.stream);
        Object object = placeHolder.resolveObject();
        DefaultFactHandle handle = new DefaultFactHandle(id, object, recency);
        return handle;
    }

    public static void readRightTuples(InternalFactHandle factHandle, MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 4) {
            InputMarshaller.readRightTuple(context, factHandle);
        }
    }

    public static void readRightTuple(MarshallerReaderContext context, InternalFactHandle factHandle) throws IOException {
        MarshallerReaderContext stream = context.stream;
        RightTupleSink sink = (RightTupleSink)((Object)context.sinks.get(stream.readInt()));
        RightTuple rightTuple = new RightTuple(factHandle, sink);
        context.rightTuples.put(new RightTupleKey(factHandle.getId(), sink), rightTuple);
        BetaMemory memory = null;
        switch (sink.getType()) {
            case 6: {
                memory = ((AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((NodeMemory)((BetaNode)sink))).betaMemory;
                break;
            }
            case 5: {
                memory = ((CollectNode.CollectMemory)context.wm.getNodeMemory((NodeMemory)((BetaNode)sink))).betaMemory;
                break;
            }
            default: {
                memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
            }
        }
        memory.getRightTupleMemory().add(rightTuple);
    }

    public static void readLeftTuples(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 3) {
            LeftTupleSink sink = (LeftTupleSink)((Object)context.sinks.get(stream.readInt()));
            int factHandleId = stream.readInt();
            LeftTuple leftTuple = new LeftTuple(context.handles.get(factHandleId), sink, true);
            InputMarshaller.readLeftTuple(leftTuple, context);
        }
    }

    public static void readLeftTuple(LeftTuple parentLeftTuple, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        Map<Integer, BaseNode> sinks = context.sinks;
        LeftTupleSink sink = parentLeftTuple.getLeftTupleSink();
        block0 : switch (sink.getType()) {
            case 0: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                memory.getLeftTupleMemory().add(parentLeftTuple);
                while (stream.readShort() == 4) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    int factHandleId = stream.readInt();
                    RightTupleKey key = new RightTupleKey(factHandleId, sink);
                    RightTuple rightTuple = context.rightTuples.get(key);
                    LeftTuple childLeftTuple = new LeftTuple(parentLeftTuple, rightTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 3: {
                EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)context.wm.getNodeMemory((EvalConditionNode)sink);
                memory.tupleMemory.add(parentLeftTuple);
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = new LeftTuple(parentLeftTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 1: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                short type = stream.readShort();
                if (type == 7) {
                    memory.getLeftTupleMemory().add(parentLeftTuple);
                    while (stream.readShort() == 3) {
                        LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                        LeftTuple childLeftTuple = new LeftTuple(parentLeftTuple, childSink, true);
                        InputMarshaller.readLeftTuple(childLeftTuple, context);
                    }
                    break;
                }
                int factHandleId = stream.readInt();
                RightTupleKey key = new RightTupleKey(factHandleId, sink);
                RightTuple rightTuple = context.rightTuples.get(key);
                parentLeftTuple.setBlocker(rightTuple);
                rightTuple.setBlocked(parentLeftTuple);
                break;
            }
            case 2: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                short type = stream.readShort();
                if (type == 7) {
                    memory.getLeftTupleMemory().add(parentLeftTuple);
                    break;
                }
                int factHandleId = stream.readInt();
                RightTupleKey key = new RightTupleKey(factHandleId, sink);
                RightTuple rightTuple = context.rightTuples.get(key);
                parentLeftTuple.setBlocker(rightTuple);
                rightTuple.setBlocked(parentLeftTuple);
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = new LeftTuple(parentLeftTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 6: {
                AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((BetaNode)sink);
                memory.betaMemory.getLeftTupleMemory().add(parentLeftTuple);
                AccumulateNode.AccumulateContext accctx = new AccumulateNode.AccumulateContext();
                memory.betaMemory.getCreatedHandles().put(parentLeftTuple, accctx, false);
                InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                accctx.result = new RightTuple(handle, (RightTupleSink)((Object)sink));
                accctx.context = (Serializable)stream.readObject();
                accctx.propagated = stream.readBoolean();
                int head = -1;
                block22: while (true) {
                    short s = stream.readShort();
                    head = s;
                    if (s == 1) break block0;
                    switch (head) {
                        case 4: {
                            int factHandleId = stream.readInt();
                            RightTupleKey key = new RightTupleKey(factHandleId, sink);
                            RightTuple rightTuple = context.rightTuples.get(key);
                            new LeftTuple(parentLeftTuple, rightTuple, sink, true);
                            continue block22;
                        }
                        case 3: {
                            LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                            LeftTuple childLeftTuple = new LeftTuple(parentLeftTuple, accctx.result, childSink, true);
                            InputMarshaller.readLeftTuple(childLeftTuple, context);
                            continue block22;
                        }
                    }
                    break;
                }
                throw new RuntimeDroolsException("Marshalling error. This is a bug. Please contact the development team.");
            }
            case 5: {
                CollectNode.CollectMemory memory = (CollectNode.CollectMemory)context.wm.getNodeMemory((BetaNode)sink);
                memory.betaMemory.getLeftTupleMemory().add(parentLeftTuple);
                CollectNode.CollectContext colctx = new CollectNode.CollectContext();
                memory.betaMemory.getCreatedHandles().put(parentLeftTuple, colctx, false);
                InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                colctx.resultTuple = new RightTuple(handle, (RightTupleSink)((Object)sink));
                colctx.propagated = stream.readBoolean();
                int head = -1;
                block23: while (true) {
                    short s = stream.readShort();
                    head = s;
                    if (s == 1) break block0;
                    switch (head) {
                        case 4: {
                            int factHandleId = stream.readInt();
                            RightTupleKey key = new RightTupleKey(factHandleId, sink);
                            RightTuple rightTuple = context.rightTuples.get(key);
                            new LeftTuple(parentLeftTuple, rightTuple, sink, true);
                            continue block23;
                        }
                        case 3: {
                            LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                            LeftTuple childLeftTuple = new LeftTuple(parentLeftTuple, colctx.resultTuple, childSink, true);
                            InputMarshaller.readLeftTuple(childLeftTuple, context);
                            continue block23;
                        }
                    }
                    break;
                }
                throw new RuntimeDroolsException("Marshalling error. This is a bug. Please contact the development team.");
            }
            case 7: {
                ObjectHashMap memory = (ObjectHashMap)context.wm.getNodeMemory((NodeMemory)((Object)sink));
                int id = stream.readInt();
                long recency = stream.readLong();
                DefaultFactHandle handle = new DefaultFactHandle(id, parentLeftTuple, recency);
                memory.put(parentLeftTuple, handle);
                InputMarshaller.readRightTuples(handle, context);
                stream.readShort();
                break;
            }
            case 9: {
                RuleTerminalNode ruleTerminalNode = (RuleTerminalNode)sink;
                RuleTerminalNode.TerminalNodeMemory memory = (RuleTerminalNode.TerminalNodeMemory)wm.getNodeMemory(ruleTerminalNode);
                memory.getTupleMemory().add(parentLeftTuple);
                int pos = context.terminalTupleMap.size();
                context.terminalTupleMap.put(pos, parentLeftTuple);
                break;
            }
        }
    }

    public static void readActivations(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 8) {
            InputMarshaller.readActivation(context);
        }
    }

    public static Activation readActivation(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        long activationNumber = stream.readLong();
        int pos = stream.readInt();
        LeftTuple leftTuple = context.terminalTupleMap.get(pos);
        int salience = stream.readInt();
        String pkgName = stream.readUTF();
        String ruleName = stream.readUTF();
        Package pkg = ruleBase.getPackage(pkgName);
        Rule rule = pkg.getRule(ruleName);
        RuleTerminalNode ruleTerminalNode = (RuleTerminalNode)leftTuple.getLeftTupleSink();
        GroupElement subRule = ruleTerminalNode.getSubRule();
        PropagationContext pc = context.propagationContexts.get(stream.readLong());
        AgendaItem activation = new AgendaItem(activationNumber, leftTuple, salience, pc, rule, subRule);
        leftTuple.setActivation(activation);
        if (stream.readBoolean()) {
            String activationGroupName = stream.readUTF();
            ((DefaultAgenda)wm.getAgenda()).getActivationGroup(activationGroupName).addActivation(activation);
        }
        boolean activated = stream.readBoolean();
        activation.setActivated(activated);
        InternalAgendaGroup agendaGroup = rule.getAgendaGroup() == null || rule.getAgendaGroup().equals("") || rule.getAgendaGroup().equals("MAIN") ? (InternalAgendaGroup)((DefaultAgenda)wm.getAgenda()).getAgendaGroup("MAIN") : (InternalAgendaGroup)((DefaultAgenda)wm.getAgenda()).getAgendaGroup(rule.getAgendaGroup());
        activation.setAgendaGroup(agendaGroup);
        if (activated) {
            if (rule.getRuleFlowGroup() == null) {
                agendaGroup.add(activation);
            } else {
                InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)((DefaultAgenda)wm.getAgenda()).getRuleFlowGroup(rule.getRuleFlowGroup());
                rfg.addActivation(activation);
            }
        }
        TruthMaintenanceSystem tms = context.wm.getTruthMaintenanceSystem();
        while (stream.readShort() == 12) {
            int factHandleId = stream.readInt();
            InternalFactHandle handle = context.handles.get(factHandleId);
            tms.addLogicalDependency(handle, activation, pc, rule);
        }
        return activation;
    }

    public static void readPropagationContexts(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 9) {
            InputMarshaller.readPropagationContext(context);
        }
    }

    public static void readPropagationContext(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        int type = stream.readInt();
        Rule rule = null;
        if (stream.readBoolean()) {
            String pkgName = stream.readUTF();
            String ruleName = stream.readUTF();
            Package pkg = ruleBase.getPackage(pkgName);
            rule = pkg.getRule(ruleName);
        }
        LeftTuple leftTuple = null;
        if (stream.readBoolean()) {
            int tuplePos = stream.readInt();
            leftTuple = context.terminalTupleMap.get(tuplePos);
        }
        long propagationNumber = stream.readLong();
        int factHandleId = stream.readInt();
        InternalFactHandle factHandle = context.handles.get(factHandleId);
        int activeActivations = stream.readInt();
        int dormantActivations = stream.readInt();
        String entryPointId = stream.readUTF();
        EntryPoint entryPoint = context.entryPoints.get(entryPointId);
        if (entryPoint == null) {
            entryPoint = new EntryPoint(entryPointId);
            context.entryPoints.put(entryPointId, entryPoint);
        }
        PropagationContextImpl pc = new PropagationContextImpl(propagationNumber, type, rule, leftTuple, factHandle, activeActivations, dormantActivations, entryPoint);
        context.propagationContexts.put(propagationNumber, pc);
    }

    public static void readProcessInstances(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 17) {
            InputMarshaller.readProcessInstance(context);
        }
    }

    public static ProcessInstance readProcessInstance(MarshallerReaderContext context) throws IOException {
        int nbSwimlanes;
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setId(stream.readLong());
        String processId = stream.readUTF();
        processInstance.setProcessId(processId);
        if (ruleBase != null) {
            processInstance.setProcess(ruleBase.getProcess(processId));
        }
        processInstance.setState(stream.readInt());
        long nodeInstanceCounter = stream.readLong();
        processInstance.setWorkingMemory(wm);
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    Object value = stream.readObject();
                    variableScopeInstance.setVariable(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        if ((nbSwimlanes = stream.readInt()) > 0) {
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance("SwimlaneScope");
            for (int i = 0; i < nbSwimlanes; ++i) {
                String name = stream.readUTF();
                String value = stream.readUTF();
                swimlaneContextInstance.setActorId(name, value);
            }
        }
        while (stream.readShort() == 18) {
            InputMarshaller.readNodeInstance(context, processInstance, processInstance);
        }
        processInstance.internalSetNodeInstanceCounter(nodeInstanceCounter);
        if (wm != null) {
            processInstance.reconnect();
        }
        return processInstance;
    }

    public static NodeInstance readNodeInstance(MarshallerReaderContext context, NodeInstanceContainer nodeInstanceContainer, RuleFlowProcessInstance processInstance) throws IOException {
        int i;
        MarshallerReaderContext stream = context.stream;
        NodeInstanceImpl nodeInstance = null;
        long id = stream.readLong();
        long nodeId = stream.readLong();
        short nodeType = stream.readShort();
        switch (nodeType) {
            case 20: {
                nodeInstance = new RuleSetNodeInstance();
                break;
            }
            case 27: {
                nodeInstance = new HumanTaskNodeInstance();
                ((HumanTaskNodeInstance)nodeInstance).internalSetWorkItemId(stream.readLong());
                break;
            }
            case 21: {
                nodeInstance = new WorkItemNodeInstance();
                ((WorkItemNodeInstance)nodeInstance).internalSetWorkItemId(stream.readLong());
                break;
            }
            case 22: {
                nodeInstance = new SubProcessNodeInstance();
                ((SubProcessNodeInstance)nodeInstance).internalSetProcessInstanceId(stream.readLong());
                break;
            }
            case 23: {
                nodeInstance = new MilestoneNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readLong());
                }
                ((MilestoneNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 24: {
                nodeInstance = new TimerNodeInstance();
                ((TimerNodeInstance)nodeInstance).internalSetTimerId(stream.readLong());
                break;
            }
            case 25: {
                nodeInstance = new JoinInstance();
                int number = stream.readInt();
                if (number <= 0) break;
                HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
                for (int i2 = 0; i2 < number; ++i2) {
                    long l = stream.readLong();
                    int count = stream.readInt();
                    triggers.put(l, count);
                }
                ((JoinInstance)nodeInstance).internalSetTriggers(triggers);
                break;
            }
            case 26: {
                nodeInstance = new CompositeContextNodeInstance();
                break;
            }
            case 28: {
                nodeInstance = new ForEachNodeInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + nodeType);
            }
        }
        nodeInstance.setNodeId(nodeId);
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance(processInstance);
        nodeInstance.setId(id);
        switch (nodeType) {
            case 26: {
                int nbVariables = stream.readInt();
                if (nbVariables > 0) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((CompositeContextNodeInstance)nodeInstance).getContextInstance("VariableScope");
                    for (i = 0; i < nbVariables; ++i) {
                        String name = stream.readUTF();
                        try {
                            Object value = stream.readObject();
                            variableScopeInstance.setVariable(name, value);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not reload variable " + name);
                        }
                    }
                }
                while (stream.readShort() == 18) {
                    InputMarshaller.readNodeInstance(context, (CompositeContextNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
            case 28: {
                while (stream.readShort() == 18) {
                    InputMarshaller.readNodeInstance(context, (ForEachNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
        }
        return nodeInstance;
    }

    public static void readWorkItems(MarshallerReaderContext context) throws IOException {
        InternalWorkingMemory wm = context.wm;
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 19) {
            WorkItem workItem = InputMarshaller.readWorkItem(context);
            wm.getWorkItemManager().internalAddWorkItem(workItem);
        }
    }

    public static WorkItem readWorkItem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(stream.readLong());
        workItem.setProcessInstanceId(stream.readLong());
        workItem.setName(stream.readUTF());
        workItem.setState(stream.readInt());
        int nbParameters = stream.readInt();
        for (int i = 0; i < nbParameters; ++i) {
            String name = stream.readUTF();
            try {
                Object value = stream.readObject();
                workItem.setParameter(name, value);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not reload parameter " + name);
            }
        }
        return workItem;
    }

    public static void readTimers(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        InternalWorkingMemory wm = context.wm;
        MarshallerReaderContext stream = context.stream;
        TimerManager timerManager = wm.getTimerManager();
        timerManager.internalSetTimerId(stream.readLong());
        while (stream.readShort() == 29) {
            TimerInstance timer = InputMarshaller.readTimer(context);
            timerManager.internalAddTimer(timer);
        }
    }

    public static TimerInstance readTimer(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        TimerInstance timer = new TimerInstance();
        timer.setId(stream.readLong());
        timer.setTimerId(stream.readLong());
        timer.setDelay(stream.readLong());
        timer.setPeriod(stream.readLong());
        timer.setProcessInstanceId(stream.readLong());
        timer.setActivated(new Date(stream.readLong()));
        if (stream.readBoolean()) {
            timer.setLastTriggered(new Date(stream.readLong()));
        }
        return timer;
    }
}

