/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.InitialFact;
import org.drools.base.ClassObjectType;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.EqualityKey;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.NodeMemory;
import org.drools.common.ObjectStore;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.MarshallerWriteContext;
import org.drools.marshalling.PlaceholderResolverStrategy;
import org.drools.marshalling.PlaceholderResolverStrategyFactory;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.context.swimlane.SwimlaneContextInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.process.instance.timer.TimerManager;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CollectNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.runtime.process.NodeInstance;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaGroup;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.util.LinkedList;
import org.drools.util.ObjectHashMap;
import org.drools.util.ObjectHashSet;
import org.drools.workflow.instance.node.CompositeContextNodeInstance;
import org.drools.workflow.instance.node.ForEachNodeInstance;
import org.drools.workflow.instance.node.HumanTaskNodeInstance;
import org.drools.workflow.instance.node.JoinInstance;
import org.drools.workflow.instance.node.MilestoneNodeInstance;
import org.drools.workflow.instance.node.RuleSetNodeInstance;
import org.drools.workflow.instance.node.SubProcessNodeInstance;
import org.drools.workflow.instance.node.TimerNodeInstance;
import org.drools.workflow.instance.node.WorkItemNodeInstance;

public class OutputMarshaller {
    public static void writeSession(MarshallerWriteContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        boolean multithread = wm.isPartitionManagersActive();
        if (multithread) {
            context.writeBoolean(true);
            wm.stopPartitionManagers();
        } else {
            context.writeBoolean(false);
        }
        context.writeInt(wm.getFactHandleFactory().getId());
        context.writeLong(wm.getFactHandleFactory().getRecency());
        context.out.println("FactHandleFactory int:" + wm.getFactHandleFactory().getId() + " long:" + wm.getFactHandleFactory().getRecency());
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        context.writeInt(handle.getId());
        context.writeLong(handle.getRecency());
        context.out.println("InitialFact int:" + handle.getId() + " long:" + handle.getRecency());
        context.writeLong(wm.getPropagationIdCounter());
        context.out.println("PropagationCounter long:" + wm.getPropagationIdCounter());
        OutputMarshaller.writeAgenda(context);
        OutputMarshaller.writeFactHandles(context);
        OutputMarshaller.writeActionQueue(context);
        if (wm.getTruthMaintenanceSystem() != null) {
            context.writeBoolean(true);
            OutputMarshaller.writeTruthMaintenanceSystem(context);
        } else {
            context.writeBoolean(false);
        }
        OutputMarshaller.writeProcessInstances(context);
        OutputMarshaller.writeWorkItems(context);
        OutputMarshaller.writeTimers(context);
        if (multithread) {
            wm.startPartitionManagers();
        }
    }

    public static void writeAgenda(MarshallerWriteContext context) throws IOException {
        InternalWorkingMemory wm = context.wm;
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        Map<String, ActivationGroup> activationGroups = agenda.getActivationGroupsMap();
        AgendaGroup[] agendaGroups = agenda.getAgendaGroupsMap().values().toArray(new AgendaGroup[agenda.getAgendaGroupsMap().size()]);
        Arrays.sort(agendaGroups, AgendaGroupSorter.instance);
        for (AgendaGroup group : agendaGroups) {
            context.writeShort(13);
            context.writeUTF(group.getName());
            context.writeBoolean(group.isActive());
        }
        context.writeShort(1);
        java.util.LinkedList<AgendaGroup> focusStack = agenda.getStackList();
        for (AgendaGroup group : focusStack) {
            context.writeShort(13);
            context.writeUTF(group.getName());
        }
        context.writeShort(1);
        RuleFlowGroupImpl[] ruleFlowGroups = agenda.getRuleFlowGroupsMap().values().toArray(new RuleFlowGroupImpl[agenda.getRuleFlowGroupsMap().size()]);
        Arrays.sort(ruleFlowGroups, RuleFlowGroupSorter.instance);
        for (RuleFlowGroupImpl group : ruleFlowGroups) {
            context.writeShort(15);
            context.writeUTF(group.getName());
            context.writeBoolean(group.isActive());
            context.writeBoolean(group.isAutoDeactivate());
        }
        context.writeShort(1);
    }

    public static void writeActionQueue(MarshallerWriteContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        WorkingMemoryAction[] queue = wm.getActionQueue().toArray(new WorkingMemoryAction[wm.getActionQueue().size()]);
        for (int i = queue.length - 1; i >= 0; --i) {
            context.writeShort(10);
            queue[i].write(context);
        }
        context.writeShort(1);
    }

    public static void writeTruthMaintenanceSystem(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ObjectHashMap assertMap = context.wm.getTruthMaintenanceSystem().getAssertMap();
        EqualityKey[] keys = new EqualityKey[assertMap.size()];
        org.drools.util.Iterator it = assertMap.iterator();
        int i = 0;
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            EqualityKey key = (EqualityKey)entry.getKey();
            keys[i++] = key;
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
        Arrays.sort(keys, EqualityKeySorter.instance);
        for (EqualityKey key : keys) {
            stream.writeShort(11);
            stream.writeInt(key.getStatus());
            InternalFactHandle handle = key.getFactHandle();
            stream.writeInt(handle.getId());
            context.out.println("EqualityKey int:" + key.getStatus() + " int:" + handle.getId());
            if (key.getOtherFactHandle() != null && !key.getOtherFactHandle().isEmpty()) {
                for (InternalFactHandle handle2 : key.getOtherFactHandle()) {
                    stream.writeShort(2);
                    stream.writeInt(handle2.getId());
                    context.out.println("OtherHandle int:" + handle2.getId());
                }
            }
            stream.writeShort(1);
        }
        stream.writeShort(1);
    }

    public static void writeFactHandles(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        PlaceholderResolverStrategyFactory resolverStrategyFactory = context.resolverStrategyFactory;
        OutputMarshaller.writeInitialFactHandleRightTuples(context);
        stream.writeInt(wm.getObjectStore().size());
        for (InternalFactHandle handle : OutputMarshaller.orderFacts(wm.getObjectStore())) {
            OutputMarshaller.writeFactHandle(context, stream, resolverStrategyFactory, handle);
            OutputMarshaller.writeRightTuples(handle, context);
        }
        OutputMarshaller.writeInitialFactHandleLeftTuples(context);
        OutputMarshaller.writeLeftTuples(context);
        OutputMarshaller.writePropagationContexts(context);
        OutputMarshaller.writeActivations(context);
    }

    private static void writeFactHandle(MarshallerWriteContext context, ObjectOutputStream stream, PlaceholderResolverStrategyFactory resolverStrategyFactory, InternalFactHandle handle) throws IOException {
        stream.writeInt(handle.getId());
        stream.writeLong(handle.getRecency());
        context.out.println("Object : int:" + handle.getId() + " long:" + handle.getRecency());
        context.out.println(handle.getObject());
        Object object = handle.getObject();
        PlaceholderResolverStrategy strategy = resolverStrategyFactory.getStrategy(object);
        stream.writeInt(strategy.getIndex());
        strategy.write(stream, object);
    }

    public static InternalFactHandle[] orderFacts(ObjectStore objectStore) {
        int size = objectStore.size();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        int i = 0;
        Iterator it = objectStore.iterateFactHandles();
        while (it.hasNext()) {
            handles[i++] = (InternalFactHandle)it.next();
        }
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static void writeInitialFactHandleRightTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        ObjectTypeNode initialFactNode = ruleBase.getRete().getEntryPointNode(EntryPoint.DEFAULT).getObjectTypeNodes().get(new ClassObjectType(InitialFact.class));
        if (initialFactNode != null) {
            ObjectHashSet initialFactMemory = (ObjectHashSet)context.wm.getNodeMemory(initialFactNode);
            if (initialFactMemory != null && !initialFactMemory.isEmpty()) {
                context.out.println("InitialFactMemory true int:" + initialFactNode.getId());
                stream.writeBoolean(true);
                stream.writeInt(initialFactNode.getId());
                context.out.println("InitialFact RightTuples");
                OutputMarshaller.writeRightTuples(context.wm.getInitialFactHandle(), context);
            } else {
                context.out.println("InitialFactMemory false ");
                stream.writeBoolean(false);
            }
        } else {
            context.out.println("InitialFactMemory false ");
            stream.writeBoolean(false);
        }
    }

    public static void writeInitialFactHandleLeftTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        context.out.println("InitialFact LeftTuples Start");
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        for (LeftTuple leftTuple = OutputMarshaller.getLeftTuple(handle.getLeftTuple()); leftTuple != null; leftTuple = leftTuple.getLeftParentPrevious()) {
            stream.writeShort(3);
            stream.writeInt(leftTuple.getLeftTupleSink().getId());
            context.out.println("LeftTuple sinkId:" + leftTuple.getLeftTupleSink().getId());
            OutputMarshaller.writeLeftTuple(leftTuple, context, true);
        }
        stream.writeShort(1);
        context.out.println("InitialFact LeftTuples End");
    }

    public static void writeRightTuples(InternalFactHandle handle, MarshallerWriteContext context) throws IOException {
        RightTuple rightTuple;
        MarshallerWriteContext stream = context.stream;
        context.out.println("RightTuples Start");
        for (RightTuple tempRightTuple = rightTuple = handle.getRightTuple(); tempRightTuple != null; tempRightTuple = tempRightTuple.getHandleNext()) {
            rightTuple = tempRightTuple;
        }
        while (rightTuple != null) {
            stream.writeShort(4);
            OutputMarshaller.writeRightTuple(rightTuple, context);
            rightTuple = rightTuple.getHandlePrevious();
        }
        stream.writeShort(1);
        context.out.println("RightTuples END");
    }

    public static void writeRightTuple(RightTuple rightTuple, MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        stream.writeInt(rightTuple.getRightTupleSink().getId());
        context.out.println("RightTuple sinkId:" + rightTuple.getRightTupleSink().getId());
    }

    public static void writeLeftTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        context.out.println("LeftTuples Start");
        for (InternalFactHandle handle : OutputMarshaller.orderFacts(wm.getObjectStore())) {
            for (LeftTuple leftTuple = OutputMarshaller.getLeftTuple(handle.getLeftTuple()); leftTuple != null; leftTuple = leftTuple.getLeftParentPrevious()) {
                stream.writeShort(3);
                stream.writeInt(leftTuple.getLeftTupleSink().getId());
                stream.writeInt(handle.getId());
                context.out.println("LeftTuple sinkId:" + leftTuple.getLeftTupleSink().getId() + " handleId:" + handle.getId());
                OutputMarshaller.writeLeftTuple(leftTuple, context, true);
            }
        }
        stream.writeShort(1);
        context.out.println("LeftTuples End");
    }

    public static void writeLeftTuple(LeftTuple leftTuple, MarshallerWriteContext context, boolean recurse) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        LeftTupleSink sink = leftTuple.getLeftTupleSink();
        switch (sink.getType()) {
            case 0: {
                context.out.println("JoinNode");
                for (LeftTuple childLeftTuple = OutputMarshaller.getLeftTuple(leftTuple.getBetaChildren()); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentPrevious()) {
                    stream.writeShort(4);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                    context.out.println("RightTuple int:" + childLeftTuple.getLeftTupleSink().getId() + " int:" + childLeftTuple.getRightParent().getFactHandle().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                context.out.println("JoinNode   ---   END");
                break;
            }
            case 3: {
                context.out.println("EvalConditionNode");
                for (LeftTuple childLeftTuple = OutputMarshaller.getLeftTuple(leftTuple.getBetaChildren()); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentPrevious()) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 1: {
                if (leftTuple.getBlocker() == null) {
                    stream.writeShort(7);
                    LeftTuple childLeftTuple = OutputMarshaller.getLeftTuple(leftTuple.getBetaChildren());
                    while (childLeftTuple != null) {
                        stream.writeShort(3);
                        stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                        OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                        childLeftTuple = leftTuple.getLeftParentPrevious();
                    }
                    stream.writeShort(1);
                    break;
                }
                stream.writeShort(6);
                stream.writeInt(leftTuple.getBlocker().getFactHandle().getId());
                break;
            }
            case 2: {
                if (leftTuple.getBlocker() == null) {
                    stream.writeShort(7);
                    break;
                }
                stream.writeShort(6);
                stream.writeInt(leftTuple.getBlocker().getFactHandle().getId());
                LeftTuple childLeftTuple = OutputMarshaller.getLeftTuple(leftTuple.getBetaChildren());
                while (childLeftTuple != null) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                    childLeftTuple = leftTuple.getLeftParentPrevious();
                }
                stream.writeShort(1);
                break;
            }
            case 6: {
                context.out.println("AccumulateNode");
                AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((BetaNode)sink);
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
                OutputMarshaller.writeFactHandle(context, stream, context.resolverStrategyFactory, accctx.result.getFactHandle());
                stream.writeObject(accctx.context);
                stream.writeBoolean(accctx.propagated);
                for (LeftTuple childLeftTuple = OutputMarshaller.getLeftTuple(leftTuple.getBetaChildren()); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentPrevious()) {
                    if (leftTuple.getLeftTupleSink().getId() == childLeftTuple.getLeftTupleSink().getId()) {
                        context.out.println("RightTuple(match) int:" + childLeftTuple.getLeftTupleSink().getId() + " int:" + childLeftTuple.getRightParent().getFactHandle().getId());
                        stream.writeShort(4);
                        stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                        continue;
                    }
                    context.out.println("RightTuple(propagation) int:" + childLeftTuple.getLeftTupleSink().getId() + " int:" + childLeftTuple.getRightParent().getFactHandle().getId());
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                context.out.println("AccumulateNode   ---   END");
                break;
            }
            case 5: {
                context.out.println("CollectNode");
                CollectNode.CollectMemory memory = (CollectNode.CollectMemory)context.wm.getNodeMemory((BetaNode)sink);
                CollectNode.CollectContext colctx = (CollectNode.CollectContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
                OutputMarshaller.writeFactHandle(context, stream, context.resolverStrategyFactory, colctx.resultTuple.getFactHandle());
                stream.writeBoolean(colctx.propagated);
                for (LeftTuple childLeftTuple = OutputMarshaller.getLeftTuple(leftTuple.getBetaChildren()); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentPrevious()) {
                    if (leftTuple.getLeftTupleSink().getId() == childLeftTuple.getLeftTupleSink().getId()) {
                        context.out.println("RightTuple(match) int:" + childLeftTuple.getLeftTupleSink().getId() + " int:" + childLeftTuple.getRightParent().getFactHandle().getId());
                        stream.writeShort(4);
                        stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                        continue;
                    }
                    context.out.println("RightTuple(propagation) int:" + childLeftTuple.getLeftTupleSink().getId() + " int:" + childLeftTuple.getRightParent().getFactHandle().getId());
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                context.out.println("CollectNode   ---   END");
                break;
            }
            case 7: {
                context.out.println("RightInputAdapterNode");
                ObjectHashMap memory = (ObjectHashMap)context.wm.getNodeMemory((NodeMemory)((Object)sink));
                InternalFactHandle ifh = (InternalFactHandle)memory.get(leftTuple);
                context.out.println("FactHandle id:" + ifh.getId());
                stream.writeInt(ifh.getId());
                stream.writeLong(ifh.getRecency());
                OutputMarshaller.writeRightTuples(ifh, context);
                stream.writeShort(1);
                context.out.println("RightInputAdapterNode   ---   END");
                break;
            }
            case 9: {
                context.out.println("RuleTerminalNode");
                int pos = context.terminalTupleMap.size();
                context.terminalTupleMap.put(leftTuple, pos);
                break;
            }
        }
    }

    public static LeftTuple getLeftTuple(LeftTuple leftTuple) {
        for (LeftTuple tempLeftTuple = leftTuple; tempLeftTuple != null; tempLeftTuple = tempLeftTuple.getLeftParentNext()) {
            leftTuple = tempLeftTuple;
        }
        return leftTuple;
    }

    public static void writeActivations(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map.Entry[] entries = context.terminalTupleMap.entrySet().toArray(new Map.Entry[context.terminalTupleMap.size()]);
        Arrays.sort(entries, TupleSorter.instance);
        if (entries.length != 0) {
            for (Map.Entry entry : entries) {
                if (((LeftTuple)entry.getKey()).getActivation() == null) continue;
                LeftTuple leftTuple = (LeftTuple)entry.getKey();
                stream.writeShort(8);
                OutputMarshaller.writeActivation(context, leftTuple, (AgendaItem)leftTuple.getActivation(), (RuleTerminalNode)leftTuple.getLeftTupleSink());
            }
        }
        stream.writeShort(1);
    }

    public static void writeActivation(MarshallerWriteContext context, LeftTuple leftTuple, AgendaItem agendaItem, RuleTerminalNode ruleTerminalNode) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(agendaItem.getActivationNumber());
        stream.writeInt(context.terminalTupleMap.get(leftTuple));
        stream.writeInt(agendaItem.getSalience());
        Rule rule = agendaItem.getRule();
        stream.writeUTF(rule.getPackage());
        stream.writeUTF(rule.getName());
        context.out.println("Rule " + rule.getPackage() + "." + rule.getName());
        context.out.println("AgendaItem long:" + agendaItem.getPropagationContext().getPropagationNumber());
        stream.writeLong(agendaItem.getPropagationContext().getPropagationNumber());
        if (agendaItem.getActivationGroupNode() != null) {
            stream.writeBoolean(true);
            context.out.println("ActivationGroup bool:true");
            stream.writeUTF(agendaItem.getActivationGroupNode().getActivationGroup().getName());
            context.out.println("ActivationGroup string:" + agendaItem.getActivationGroupNode().getActivationGroup().getName());
        } else {
            stream.writeBoolean(false);
            context.out.println("ActivationGroup bool:false");
        }
        stream.writeBoolean(agendaItem.isActivated());
        context.out.println("AgendaItem bool:" + agendaItem.isActivated());
        LinkedList list = agendaItem.getLogicalDependencies();
        if (list != null && !list.isEmpty()) {
            for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
                stream.writeShort(12);
                stream.writeInt(((InternalFactHandle)node.getFactHandle()).getId());
                context.out.println("Logical Depenency : int " + ((InternalFactHandle)node.getFactHandle()).getId());
            }
        }
        stream.writeShort(1);
    }

    public static void writePropagationContexts(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map.Entry[] entries = context.terminalTupleMap.entrySet().toArray(new Map.Entry[context.terminalTupleMap.size()]);
        Arrays.sort(entries, TupleSorter.instance);
        if (entries.length != 0) {
            HashMap<Long, PropagationContext> pcMap = new HashMap<Long, PropagationContext>();
            for (Map.Entry entry : entries) {
                PropagationContext pc;
                LeftTuple leftTuple = (LeftTuple)entry.getKey();
                if (leftTuple.getActivation() == null || pcMap.containsKey((pc = leftTuple.getActivation().getPropagationContext()).getPropagationNumber())) continue;
                stream.writeShort(9);
                OutputMarshaller.writePropagationContext(context, pc);
                pcMap.put(pc.getPropagationNumber(), pc);
            }
        }
        stream.writeShort(1);
    }

    public static void writePropagationContext(MarshallerWriteContext context, PropagationContext pc) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map<LeftTuple, Integer> tuples = context.terminalTupleMap;
        stream.writeInt(pc.getType());
        Rule ruleOrigin = pc.getRuleOrigin();
        if (ruleOrigin != null) {
            stream.writeBoolean(true);
            stream.writeUTF(ruleOrigin.getPackage());
            stream.writeUTF(ruleOrigin.getName());
        } else {
            stream.writeBoolean(false);
        }
        LeftTuple tupleOrigin = pc.getLeftTupleOrigin();
        if (tupleOrigin != null && tuples.containsKey(tupleOrigin)) {
            stream.writeBoolean(true);
            stream.writeInt(tuples.get(tupleOrigin));
        } else {
            stream.writeBoolean(false);
        }
        stream.writeLong(pc.getPropagationNumber());
        if (pc.getFactHandleOrigin() != null) {
            stream.writeInt(((InternalFactHandle)pc.getFactHandleOrigin()).getId());
        } else {
            stream.writeInt(-1);
        }
        stream.writeInt(pc.getActiveActivations());
        stream.writeInt(pc.getDormantActivations());
        stream.writeUTF(pc.getEntryPoint().getEntryPointId());
    }

    public static void writeProcessInstances(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>(context.wm.getProcessInstances());
        Collections.sort(processInstances, new Comparator<org.drools.runtime.process.ProcessInstance>(){

            @Override
            public int compare(org.drools.runtime.process.ProcessInstance o1, org.drools.runtime.process.ProcessInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (org.drools.runtime.process.ProcessInstance processInstance : processInstances) {
            stream.writeShort(17);
            OutputMarshaller.writeProcessInstance(context, (RuleFlowProcessInstance)processInstance);
        }
        stream.writeShort(1);
    }

    public static void writeProcessInstance(MarshallerWriteContext context, RuleFlowProcessInstance processInstance) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(processInstance.getId());
        stream.writeUTF(processInstance.getProcessId());
        stream.writeInt(processInstance.getState());
        stream.writeLong(processInstance.getNodeInstanceCounter());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        Map<String, Object> variables = variableScopeInstance.getVariables();
        ArrayList<String> keys = new ArrayList<String>(variables.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        stream.writeInt(keys.size());
        for (String key : keys) {
            stream.writeUTF(key);
            stream.writeObject(variables.get(key));
        }
        SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance("SwimlaneScope");
        Map<String, String> swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
        stream.writeInt(swimlaneActors.size());
        for (Map.Entry<String, String> entry : swimlaneActors.entrySet()) {
            stream.writeUTF(entry.getKey());
            stream.writeUTF(entry.getValue());
        }
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(processInstance.getNodeInstances());
        Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

            @Override
            public int compare(NodeInstance o1, NodeInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (NodeInstance nodeInstance : nodeInstances) {
            stream.writeShort(18);
            OutputMarshaller.writeNodeInstance(context, nodeInstance);
        }
        stream.writeShort(1);
    }

    public static void writeNodeInstance(MarshallerWriteContext context, NodeInstance nodeInstance) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(nodeInstance.getId());
        stream.writeLong(nodeInstance.getNodeId());
        if (nodeInstance instanceof RuleSetNodeInstance) {
            stream.writeShort(20);
        } else if (nodeInstance instanceof HumanTaskNodeInstance) {
            stream.writeShort(27);
            stream.writeLong(((HumanTaskNodeInstance)nodeInstance).getWorkItem().getId());
        } else if (nodeInstance instanceof WorkItemNodeInstance) {
            stream.writeShort(21);
            stream.writeLong(((WorkItemNodeInstance)nodeInstance).getWorkItem().getId());
        } else if (nodeInstance instanceof SubProcessNodeInstance) {
            stream.writeShort(22);
            stream.writeLong(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId());
        } else if (nodeInstance instanceof MilestoneNodeInstance) {
            stream.writeShort(23);
            List<Long> timerInstances = ((MilestoneNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof TimerNodeInstance) {
            stream.writeShort(24);
            stream.writeLong(((TimerNodeInstance)nodeInstance).getTimerId());
        } else if (nodeInstance instanceof JoinInstance) {
            stream.writeShort(25);
            Map<Long, Integer> triggers = ((JoinInstance)nodeInstance).getTriggers();
            stream.writeInt(triggers.size());
            ArrayList<Long> keys = new ArrayList<Long>(triggers.keySet());
            Collections.sort(keys, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Long key : keys) {
                stream.writeLong(key);
                stream.writeInt(triggers.get(key));
            }
        } else if (nodeInstance instanceof CompositeContextNodeInstance) {
            stream.writeShort(26);
            CompositeContextNodeInstance compositeNodeInstance = (CompositeContextNodeInstance)nodeInstance;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)compositeNodeInstance.getContextInstance("VariableScope");
            Map<String, Object> variables = variableScopeInstance.getVariables();
            ArrayList<String> keys = new ArrayList<String>(variables.keySet());
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            stream.writeInt(keys.size());
            for (String key : keys) {
                stream.writeUTF(key);
                stream.writeObject(variables.get(key));
            }
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(compositeNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                stream.writeShort(18);
                OutputMarshaller.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
        } else if (nodeInstance instanceof ForEachNodeInstance) {
            stream.writeShort(28);
            ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)nodeInstance;
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(forEachNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                if (!(subNodeInstance instanceof CompositeContextNodeInstance)) continue;
                stream.writeShort(18);
                OutputMarshaller.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
        } else {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
    }

    public static void writeWorkItems(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(context.wm.getWorkItemManager().getWorkItems());
        Collections.sort(workItems, new Comparator<org.drools.runtime.process.WorkItem>(){

            @Override
            public int compare(org.drools.runtime.process.WorkItem o1, org.drools.runtime.process.WorkItem o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (org.drools.runtime.process.WorkItem workItem : workItems) {
            stream.writeShort(19);
            OutputMarshaller.writeWorkItem(context, workItem);
        }
        stream.writeShort(1);
    }

    public static void writeWorkItem(MarshallerWriteContext context, org.drools.runtime.process.WorkItem workItem) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(workItem.getId());
        stream.writeLong(workItem.getProcessInstanceId());
        stream.writeUTF(workItem.getName());
        stream.writeInt(workItem.getState());
        Map parameters = workItem.getParameters();
        stream.writeInt(parameters.size());
        for (Map.Entry entry : parameters.entrySet()) {
            stream.writeUTF((String)entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    public static void writeTimers(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        TimerManager timerManager = context.wm.getTimerManager();
        long timerId = timerManager.internalGetTimerId();
        stream.writeLong(timerId);
        ArrayList<TimerInstance> timers = new ArrayList<TimerInstance>(timerManager.getTimers());
        Collections.sort(timers, new Comparator<TimerInstance>(){

            @Override
            public int compare(TimerInstance o1, TimerInstance o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (TimerInstance timer : timers) {
            stream.writeShort(29);
            OutputMarshaller.writeTimer(context, timer);
        }
        stream.writeShort(1);
    }

    public static void writeTimer(MarshallerWriteContext context, TimerInstance timer) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(timer.getId());
        stream.writeLong(timer.getTimerId());
        stream.writeLong(timer.getDelay());
        stream.writeLong(timer.getPeriod());
        stream.writeLong(timer.getProcessInstanceId());
        stream.writeLong(timer.getActivated().getTime());
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered != null) {
            stream.writeBoolean(true);
            stream.writeLong(timer.getLastTriggered().getTime());
        } else {
            stream.writeBoolean(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleSorter
    implements Comparator<Map.Entry<LeftTuple, Integer>> {
        public static final TupleSorter instance = new TupleSorter();

        @Override
        public int compare(Map.Entry<LeftTuple, Integer> e1, Map.Entry<LeftTuple, Integer> e2) {
            return e1.getValue() - e2.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleSorter
    implements Comparator<InternalFactHandle> {
        @Override
        public int compare(InternalFactHandle h1, InternalFactHandle h2) {
            return h1.getId() - h2.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualityKeySorter
    implements Comparator<EqualityKey> {
        public static final EqualityKeySorter instance = new EqualityKeySorter();

        @Override
        public int compare(EqualityKey key1, EqualityKey key2) {
            return key1.getFactHandle().getId() - key2.getFactHandle().getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleFlowGroupSorter
    implements Comparator<RuleFlowGroup> {
        public static final RuleFlowGroupSorter instance = new RuleFlowGroupSorter();

        @Override
        public int compare(RuleFlowGroup group1, RuleFlowGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AgendaGroupSorter
    implements Comparator<AgendaGroup> {
        public static final AgendaGroupSorter instance = new AgendaGroupSorter();

        @Override
        public int compare(AgendaGroup group1, AgendaGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }
}

