/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.common.InternalRuleBase;
import org.drools.marshalling.DefaultMarshaller;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.PlaceholderResolverStrategyFactory;
import org.drools.persistence.ByteArraySnapshotter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionSnapshotter
implements ByteArraySnapshotter<StatefulSession> {
    private RuleBase ruleBase;
    private StatefulSession session;
    private Marshaller marshaller;

    private StatefulSessionSnapshotter(StatefulSession session, RuleBase ruleBase, PlaceholderResolverStrategyFactory factory) {
        this.session = session;
        this.ruleBase = ruleBase;
        this.marshaller = new DefaultMarshaller(null, factory);
    }

    public StatefulSessionSnapshotter(RuleBase ruleBase) {
        this(null, ruleBase, null);
    }

    public StatefulSessionSnapshotter(RuleBase ruleBase, PlaceholderResolverStrategyFactory factory) {
        this(null, ruleBase, factory);
    }

    public StatefulSessionSnapshotter(StatefulSession session) {
        this(session, session.getRuleBase(), null);
    }

    public StatefulSessionSnapshotter(StatefulSession session, PlaceholderResolverStrategyFactory factory) {
        this(session, session.getRuleBase(), factory);
    }

    @Override
    public byte[] getSnapshot() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.marshaller.write(baos, (InternalRuleBase)this.ruleBase, this.session);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get session snapshot", e);
        }
        return baos.toByteArray();
    }

    @Override
    public void loadSnapshot(byte[] bytes) {
        if (this.session == null) {
            this.session = this.ruleBase.newStatefulSession();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            this.marshaller.read(bais, (InternalRuleBase)this.ruleBase, this.session);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load session snapshot", e);
        }
    }

    @Override
    public StatefulSession getObject() {
        return this.session;
    }
}

