/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.process.instance.event.SignalManager;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.ProcessInstance;

public class DefaultSignalManager
implements SignalManager {
    private Map<String, List<EventListener>> processEventListeners;

    public void addEventListener(String type, EventListener eventListener) {
        List<EventListener> eventListeners;
        if (this.processEventListeners == null) {
            this.processEventListeners = new HashMap<String, List<EventListener>>();
        }
        if ((eventListeners = this.processEventListeners.get(type)) == null) {
            eventListeners = new CopyOnWriteArrayList<EventListener>();
            this.processEventListeners.put(type, eventListeners);
        }
        eventListeners.add(eventListener);
    }

    public void removeEventListener(String type, EventListener eventListener) {
        List<EventListener> eventListeners;
        if (this.processEventListeners != null && (eventListeners = this.processEventListeners.get(type)) != null) {
            eventListeners.remove(eventListener);
        }
    }

    public void signalEvent(String type, Object event) {
        List<EventListener> eventListeners;
        if (this.processEventListeners != null && (eventListeners = this.processEventListeners.get(type)) != null) {
            for (EventListener eventListener : eventListeners) {
                eventListener.signalEvent(type, event);
            }
        }
    }

    public void signalEvent(ProcessInstance processInstance, String type, Object event) {
        processInstance.signalEvent(type, event);
    }
}

