/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.timer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerManager {
    private long timerId = 0L;
    private WorkingMemory workingMemory;
    private TimerService timerService;
    private Map<Long, TimerInstance> timers = new HashMap<Long, TimerInstance>();
    private Job processJob = new ProcessJob();

    public TimerManager(WorkingMemory workingMemory, TimerService timerService) {
        this.workingMemory = workingMemory;
        this.timerService = timerService;
    }

    public void registerTimer(TimerInstance timer, ProcessInstance processInstance) {
        timer.setId(++this.timerId);
        timer.setProcessInstanceId(processInstance.getId());
        timer.setActivated(new Date());
        ProcessJobContext ctx = new ProcessJobContext(timer, processInstance.getId(), this.workingMemory);
        JobHandle jobHandle = this.timerService.scheduleJob(this.processJob, ctx, new TimerTrigger(timer.getDelay(), timer.getPeriod()));
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void internalAddTimer(TimerInstance timer) {
        long delay;
        ProcessJobContext ctx = new ProcessJobContext(timer, timer.getProcessInstanceId(), this.workingMemory);
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered == null) {
            Date activated = timer.getActivated();
            Date now = new Date();
            long timespan = now.getTime() - activated.getTime();
            delay = timer.getDelay() - timespan;
            if (delay < 0L) {
                delay = 0L;
            }
        } else {
            Date now = new Date();
            long timespan = now.getTime() - lastTriggered.getTime();
            delay = timespan - timer.getPeriod();
            if (delay < 0L) {
                delay = 0L;
            }
        }
        JobHandle jobHandle = this.timerService.scheduleJob(this.processJob, ctx, new TimerTrigger(delay, timer.getPeriod()));
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void cancelTimer(long timerId) {
        TimerInstance timer = this.timers.remove(timerId);
        if (timer != null) {
            this.timerService.removeJob(timer.getJobHandle());
        }
    }

    public void dispose() {
        for (TimerInstance timer : this.timers.values()) {
            this.timerService.removeJob(timer.getJobHandle());
        }
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Collection<TimerInstance> getTimers() {
        return this.timers.values();
    }

    public long internalGetTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public static class ProcessJobContext
    implements JobContext {
        private Long processInstanceId;
        private WorkingMemory workingMemory;
        private TimerInstance timer;
        private JobHandle jobHandle;

        public ProcessJobContext(TimerInstance timer, Long processInstanceId, WorkingMemory workingMemory) {
            this.timer = timer;
            this.processInstanceId = processInstanceId;
            this.workingMemory = workingMemory;
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public WorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public TimerInstance getTimer() {
            return this.timer;
        }
    }

    public static class TimerTrigger
    implements Trigger {
        private long delay;
        private long period;
        private int count;

        public TimerTrigger() {
        }

        public TimerTrigger(long delay, long period) {
            this.delay = delay;
            this.period = period;
        }

        public Date getNextFireTime() {
            Date date = null;
            if (this.count == 0) {
                date = new Date(System.currentTimeMillis() + this.delay);
            } else if (this.period != 0L) {
                date = new Date(System.currentTimeMillis() + this.period);
            }
            ++this.count;
            return date;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.delay = in.readLong();
            this.period = in.readLong();
            this.count = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.delay);
            out.writeLong(this.period);
            out.writeInt(this.count);
        }
    }

    public class ProcessJob
    implements Job {
        public void execute(JobContext c) {
            ProcessJobContext ctx = (ProcessJobContext)c;
            Long processInstanceId = ctx.getProcessInstanceId();
            WorkingMemory workingMemory = ctx.getWorkingMemory();
            if (processInstanceId == null) {
                throw new IllegalArgumentException("Could not find process instance for timer ");
            }
            ctx.getTimer().setLastTriggered(new Date());
            ProcessInstance processInstance = workingMemory.getProcessInstance(processInstanceId);
            if (processInstance != null) {
                workingMemory.getSignalManager().signalEvent(processInstance, "timerTriggered", ctx.getTimer());
            }
            if (ctx.getTimer().getPeriod() == 0L) {
                TimerManager.this.timers.remove(ctx.getTimer().getId());
            }
        }
    }
}

