/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBaseConfiguration;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.common.AbstractRuleBase;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.concurrent.CommandExecutor;
import org.drools.concurrent.ExecutorService;
import org.drools.event.RuleBaseEventListener;
import org.drools.marshalling.Marshaller;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooFactHandleFactory;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooStatelessSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.ExecutorServiceFactory;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.PropagationContext;

public class ReteooRuleBase
extends AbstractRuleBase {
    private static final long serialVersionUID = 500L;
    private transient Rete rete;
    private ReteooBuilder reteooBuilder;

    public ReteooRuleBase() {
    }

    public ReteooRuleBase(String id) {
        this(id, null, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, FactHandleFactory factHandleFactory) {
        this(id, null, factHandleFactory);
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config) {
        this(id, config, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(RuleBaseConfiguration config) {
        this(null, config, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        super(id, config, factHandleFactory);
        this.setupRete();
    }

    private void setupRete() {
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
        EntryPointNode epn = new EntryPointNode(this.reteooBuilder.getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, this.config.isMultithreadEvaluation(), (ObjectSource)this.rete, EntryPoint.DEFAULT);
        epn.attach();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        super.writeExternal(stream);
        stream.writeObject(this.reteooBuilder);
        stream.writeObject(this.rete);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        super.readExternal(stream);
        this.reteooBuilder = (ReteooBuilder)stream.readObject();
        this.rete = (Rete)stream.readObject();
    }

    public Rete getRete() {
        return this.rete;
    }

    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    public void assertObject(FactHandle handle, Object object, PropagationContext context, InternalWorkingMemory workingMemory) throws FactException {
        this.getRete().assertObject((DefaultFactHandle)handle, context, workingMemory);
    }

    public void retractObject(FactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) throws FactException {
        this.getRete().retractObject((InternalFactHandle)handle, context, workingMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatefulSession newStatefulSession(SessionConfiguration sessionConfig) {
        if (this.config.isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        ReteooStatefulSession session = null;
        Map map = this.pkgs;
        synchronized (map) {
            ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.config.getExecutorService());
            session = new ReteooStatefulSession(this.nextWorkingMemoryCounter(), (InternalRuleBase)this, executor, sessionConfig);
            executor.setCommandExecutor(new CommandExecutor(session));
            if (sessionConfig.isKeepReference()) {
                super.addStatefulSession(session);
                Iterator it = session.getRuleBaseUpdateListeners().iterator();
                while (it.hasNext()) {
                    this.addEventListener((RuleBaseEventListener)it.next());
                }
            }
            session.startPartitionManagers();
            session.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(session.getInitialFactHandle(), false, true, null, null));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulSession readStatefulSession(InputStream stream, boolean keepReference, Marshaller marshaller) throws IOException, ClassNotFoundException {
        if (this.config.isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        StatefulSession session = null;
        Map map = this.pkgs;
        synchronized (map) {
            ExecutorService executor = ExecutorServiceFactory.createExecutorService(this.config.getExecutorService());
            session = marshaller.read(stream, this, this.nextWorkingMemoryCounter(), executor);
            executor.setCommandExecutor(new CommandExecutor(session));
            if (keepReference) {
                super.addStatefulSession(session);
                Iterator it = session.getRuleBaseUpdateListeners().iterator();
                while (it.hasNext()) {
                    this.addEventListener((RuleBaseEventListener)it.next());
                }
            }
        }
        return session;
    }

    public void writeStatefulSession(StatefulSession session, OutputStream stream, Marshaller marshaller) throws IOException {
        marshaller.write(stream, this, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatelessSession newStatelessSession() {
        if (this.config.isSequential()) {
            this.reteooBuilder.order();
        }
        Map map = this.pkgs;
        synchronized (map) {
            return new ReteooStatelessSession(this);
        }
    }

    protected synchronized void addRule(Rule rule) throws InvalidPatternException {
        this.reteooBuilder.addRule(rule);
    }

    protected synchronized void removeRule(Rule rule) {
        this.reteooBuilder.removeRule(rule);
    }

    public int getNodeCount() {
        return this.reteooBuilder.getIdGenerator().getLastId() + 1;
    }

    public void addPackages(Package[] pkgs) {
        for (Package pkg : pkgs) {
            this.addPackage(pkg);
        }
    }

    public synchronized void addPackage(Package newPkg) {
        super.addPackage(newPkg);
        if (this.config.isSequential()) {
            this.reteooBuilder.setOrdered(false);
        }
    }
}

