/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.drools.QueryResults;
import org.drools.SessionConfiguration;
import org.drools.base.DroolsQuery;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.DefaultAgenda;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.MarshallerReaderContext;
import org.drools.marshalling.MarshallerWriteContext;
import org.drools.reteoo.InitialFactHandle;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.EntryPoint;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public class ReteooWorkingMemory
extends AbstractWorkingMemory {
    private static final long serialVersionUID = 400L;

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase) {
        this(id, ruleBase, new SessionConfiguration());
    }

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase, SessionConfiguration config) {
        super(id, ruleBase, ruleBase.newFactHandleFactory(), config);
        this.agenda = new DefaultAgenda(ruleBase);
        this.agenda.setWorkingMemory(this);
    }

    public ReteooWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, InitialFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, InternalAgenda agenda) {
        super(id, ruleBase, handleFactory, initialFactHandle, propagationContext, config);
        this.agenda = agenda;
        this.agenda.setWorkingMemory(this);
    }

    public QueryResults getQueryResults(String query) {
        return this.getQueryResults(query, null);
    }

    public QueryResults getQueryResults(String query, Object[] arguments) {
        DroolsQuery object = new DroolsQuery(query, arguments);
        InternalFactHandle handle = this.handleFactory.newFactHandle(object, this.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, object), this);
        this.insert(handle, object, null, null, this.typeConfReg.getObjectTypeConf(this.entryPoint, object));
        QueryTerminalNode node = (QueryTerminalNode)this.queryResults.remove(query);
        Query queryObj = null;
        List list = null;
        if (node == null) {
            Package[] pkgs = this.ruleBase.getPackages();
            for (int i = 0; i < pkgs.length; ++i) {
                Rule rule = pkgs[i].getRule(query);
                if (rule == null || !(rule instanceof Query)) continue;
                queryObj = (Query)rule;
                break;
            }
            this.handleFactory.destroyFactHandle(handle);
            if (queryObj == null) {
                throw new IllegalArgumentException("Query '" + query + "' does not exist");
            }
            list = Collections.EMPTY_LIST;
        } else {
            list = (List)this.getNodeMemory(node);
            if (list == null) {
                list = Collections.EMPTY_LIST;
            } else {
                this.clearNodeMemory(node);
            }
            queryObj = (Query)node.getRule();
            this.handleFactory.destroyFactHandle(handle);
        }
        return new QueryResults(list, queryObj, this);
    }

    void setQueryResults(String query, QueryTerminalNode node) {
        if (this.queryResults == Collections.EMPTY_MAP) {
            this.queryResults = new HashMap();
        }
        this.queryResults.put(query, node);
    }

    public static class WorkingMemoryReteExpireAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private ObjectTypeNode node;

        public WorkingMemoryReteExpireAction(InternalFactHandle factHandle, ObjectTypeNode node) {
            this.factHandle = factHandle;
            this.node = node;
        }

        public WorkingMemoryReteExpireAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            int nodeId = context.readInt();
            this.node = (ObjectTypeNode)context.sinks.get(nodeId);
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(5);
            context.writeInt(this.factHandle.getId());
            context.writeInt(this.node.getId());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.factHandle = (InternalFactHandle)in.readObject();
            this.node = (ObjectTypeNode)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.factHandle);
            out.writeObject(this.node);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            PropagationContextImpl context = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, this.factHandle);
            ((EventFactHandle)this.factHandle).setExpired(true);
            this.node.retractObject(this.factHandle, context, workingMemory);
        }
    }

    public static class WorkingMemoryReteAssertAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private boolean removeLogical;
        private boolean updateEqualsMap;
        private Rule ruleOrigin;
        private LeftTuple leftTuple;

        public WorkingMemoryReteAssertAction(InternalFactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule ruleOrigin, LeftTuple leftTuple) {
            this.factHandle = factHandle;
            this.removeLogical = removeLogical;
            this.updateEqualsMap = updateEqualsMap;
            this.ruleOrigin = ruleOrigin;
            this.leftTuple = leftTuple;
        }

        public WorkingMemoryReteAssertAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            this.removeLogical = context.readBoolean();
            this.updateEqualsMap = context.readBoolean();
            if (context.readBoolean()) {
                String pkgName = context.readUTF();
                String ruleName = context.readUTF();
                Package pkg = context.ruleBase.getPackage(pkgName);
                this.ruleOrigin = pkg.getRule(ruleName);
            }
            if (context.readBoolean()) {
                this.leftTuple = context.terminalTupleMap.get(context.readInt());
            }
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(1);
            context.writeInt(this.factHandle.getId());
            context.writeBoolean(this.removeLogical);
            context.writeBoolean(this.updateEqualsMap);
            if (this.ruleOrigin != null) {
                context.writeBoolean(true);
                context.writeUTF(this.ruleOrigin.getPackage());
                context.writeUTF(this.ruleOrigin.getName());
            } else {
                context.writeBoolean(false);
            }
            if (this.leftTuple != null) {
                context.writeBoolean(true);
                context.writeInt(context.terminalTupleMap.get(this.leftTuple));
            } else {
                context.writeBoolean(false);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.factHandle = (InternalFactHandle)in.readObject();
            this.removeLogical = in.readBoolean();
            this.updateEqualsMap = in.readBoolean();
            this.ruleOrigin = (Rule)in.readObject();
            this.leftTuple = (LeftTuple)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.factHandle);
            out.writeBoolean(this.removeLogical);
            out.writeBoolean(this.updateEqualsMap);
            out.writeObject(this.ruleOrigin);
            out.writeObject(this.leftTuple);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            PropagationContextImpl context = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 0, this.ruleOrigin, this.leftTuple, this.factHandle);
            ReteooRuleBase ruleBase = (ReteooRuleBase)workingMemory.getRuleBase();
            ruleBase.assertObject(this.factHandle, this.factHandle.getObject(), context, workingMemory);
        }
    }
}

