/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.EventFactHandle;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.Duration;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.Iterator;
import org.drools.util.LeftTupleList;

public final class RuleTerminalNode
extends BaseNode
implements LeftTupleSinkNode,
NodeMemory,
TerminalNode,
Externalizable {
    private int sequence = -1;
    private static final long serialVersionUID = 400L;
    private Rule rule;
    private GroupElement subrule;
    private LeftTupleSource tupleSource;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected boolean tupleMemoryEnabled;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.rule = rule;
        this.tupleSource = source;
        this.subrule = subrule;
        this.tupleMemoryEnabled = context.isTerminalNodeMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequence = in.readInt();
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeObject(this.tupleSource);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
    }

    public Rule getRule() {
        return this.rule;
    }

    public GroupElement getSubRule() {
        return this.subrule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.assertLeftTuple(tuple, context, workingMemory, true);
    }

    public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean fireActivationCreated) {
        if (!this.rule.isEffective(workingMemory.getTimeMachine(), tuple, workingMemory)) {
            return;
        }
        if (context.getType() == 2 ? this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin()) && context.getLeftTupleOrigin().equals(tuple) : this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            return;
        }
        LeftTuple cloned = tuple;
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Duration dur = this.rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            ScheduledAgendaItem item = new ScheduledAgendaItem(context.getPropagationNumber(), (Tuple)cloned, agenda, context, this.rule, this.subrule);
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            agenda.scheduleItem(item);
            tuple.setActivation(item);
            if (this.tupleMemoryEnabled) {
                memory.getTupleMemory().add(tuple);
            }
            item.setActivated(true);
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
        } else {
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            AgendaItem item = new AgendaItem(context.getPropagationNumber(), cloned, this.rule.getSalience().getValue(tuple, workingMemory), context, this.rule, this.subrule);
            item.setSequenence(this.sequence);
            tuple.setActivation(item);
            memory.getTupleMemory().add(tuple);
            boolean added = agenda.addActivation(item);
            item.setActivated(added);
            if (added && fireActivationCreated) {
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
            }
        }
        agenda.increaseActiveActivations();
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().remove(leftTuple);
        Activation activation = leftTuple.getActivation();
        if (activation == null) {
            return;
        }
        if (activation.getLogicalDependencies() != null && !activation.getLogicalDependencies().isEmpty()) {
            context.addRetractedTuple(this.rule, activation);
        }
        if (activation.isActivated()) {
            if (context.getType() == 2 && this.rule.isLockOnActive()) {
                context.addRetractedTuple(this.rule, activation);
            }
            if (context.getType() == 5) {
                EventFactHandle efh = (EventFactHandle)context.getFactHandleOrigin();
                efh.increaseActivationsCount();
            } else {
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                if (activation.getRuleFlowGroupNode() != null) {
                    InternalRuleFlowGroup ruleFlowGroup = activation.getRuleFlowGroupNode().getRuleFlowGroup();
                    ruleFlowGroup.removeActivation(activation);
                }
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory);
                ((InternalAgenda)workingMemory.getAgenda()).decreaseActiveActivations();
            }
        } else {
            ((InternalAgenda)workingMemory.getAgenda()).decreaseDormantActivations();
        }
        workingMemory.removeLogicalDependencies(activation, context, this.rule);
    }

    public String toString() {
        return "[RuleTerminalNode: rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            TerminalNodeMemory memory = (TerminalNodeMemory)workingMemory.getNodeMemory(this);
            Iterator it = memory.getTupleMemory().iterator();
            LeftTuple leftTuple = (LeftTuple)it.next();
            while (leftTuple != null) {
                Activation activation = leftTuple.getActivation();
                if (activation.isActivated()) {
                    activation.remove();
                    ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory);
                }
                PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null, null);
                workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.rule);
                leftTuple.unlinkFromLeftParent();
                leftTuple.unlinkFromRightParent();
                leftTuple = (LeftTuple)it.next();
            }
            workingMemory.executeQueuedActions();
            workingMemory.clearNodeMemory(this);
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, builder, this, workingMemories);
        }
    }

    public boolean isInUse() {
        return false;
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new TerminalNodeMemory();
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule);
    }

    public short getType() {
        return 9;
    }

    public static class TerminalNodeMemory
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        private LeftTupleList tupleMemory = new LeftTupleList();

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tupleMemory = (LeftTupleList)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tupleMemory);
        }

        public LeftTupleList getTupleMemory() {
            return this.tupleMemory;
        }
    }
}

