/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.InstanceNotEqualsConstraint;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;

public class PatternBuilder
implements ReteooComponentBuilder {
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        this.attachPattern(context, utils, pattern);
    }

    private void attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        pattern.setOffset(context.getCurrentPatternOffset());
        LinkedList alphaConstraints = new LinkedList();
        LinkedList betaConstraints = new LinkedList();
        LinkedList<Behavior> behaviors = new LinkedList<Behavior>();
        this.createConstraints(context, utils, pattern, alphaConstraints, betaConstraints);
        context.setBetaconstraints(betaConstraints);
        behaviors.addAll(pattern.getBehaviors());
        context.setBehaviors(behaviors);
        if (pattern.getSource() != null) {
            context.setAlphaConstraints(alphaConstraints);
            int currentOffset = context.getCurrentPatternOffset();
            PatternSource source = pattern.getSource();
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            builder.build(context, utils, source);
            context.setCurrentPatternOffset(currentOffset);
        }
        if (pattern.getSource() == null || context.getCurrentEntryPoint() != EntryPoint.DEFAULT) {
            this.attachAlphaNodes(context, utils, pattern, alphaConstraints);
            if (context.getCurrentEntryPoint() != EntryPoint.DEFAULT) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new PropagationQueuingNode(context.getNextId(), context.getObjectSource(), context)));
                context.setCurrentEntryPoint(EntryPoint.DEFAULT);
            }
        }
        context.incrementCurrentPatternOffset();
    }

    private void createConstraints(BuildContext context, BuildUtils utils, Pattern pattern, List alphaConstraints, List betaConstraints) {
        List constraints = pattern.getConstraints();
        this.checkRemoveIdentities(context, pattern, betaConstraints);
        for (Object object : constraints) {
            if (object instanceof Declaration) continue;
            Constraint constraint = (Constraint)object;
            if (constraint.getType().equals((Object)Constraint.ConstraintType.ALPHA)) {
                alphaConstraints.add(constraint);
                continue;
            }
            if (constraint.getType().equals((Object)Constraint.ConstraintType.BETA)) {
                utils.checkUnboundDeclarations(context, constraint.getRequiredDeclarations());
                betaConstraints.add(constraint);
                continue;
            }
            throw new RuntimeDroolsException("Unknown constraint type: " + (Object)((Object)constraint.getType()) + ". This is a bug. Please contact development team.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeNode attachObjectTypeNode(BuildContext context, ObjectType objectType) {
        Map map = context.getRuleBase().getPackagesMap();
        synchronized (map) {
            InternalWorkingMemory[] wms = context.getWorkingMemories();
            EntryPointNode epn = context.getRuleBase().getRete().getEntryPointNode(context.getCurrentEntryPoint());
            if (epn == null) {
                epn = new EntryPointNode(context.getNextId(), context.getRuleBase().getRete(), context);
                if (wms.length > 0) {
                    epn.attach(wms);
                } else {
                    epn.attach();
                }
            }
            ObjectTypeNode otn = new ObjectTypeNode(context.getNextId(), epn, objectType, context);
            if (wms.length > 0) {
                otn.attach(wms);
            } else {
                otn.attach();
            }
            return otn;
        }
    }

    public void attachAlphaNodes(BuildContext context, BuildUtils utils, Pattern pattern, List alphaConstraints) throws InvalidPatternException {
        boolean objectMemory = context.isObjectTypeNodeMemoryEnabled();
        boolean alphaMemory = context.isAlphaMemoryAllowed();
        ObjectType objectType = pattern.getObjectType();
        if (pattern.getObjectType() instanceof ClassObjectType && DroolsQuery.class == ((ClassObjectType)pattern.getObjectType()).getClassType()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
            context.setTerminalNodeMemoryEnabled(false);
            context.setAlphaNodeMemoryAllowed(false);
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, new EntryPointNode(context.getNextId(), context.getRuleBase().getRete(), context)));
        ObjectTypeNode otn = new ObjectTypeNode(context.getNextId(), (EntryPointNode)context.getObjectSource(), objectType, context);
        if (objectType.isEvent() && RuleBaseConfiguration.EventProcessingMode.STREAM.equals((Object)context.getRuleBase().getConfiguration().getEventProcessingMode())) {
            otn.setExpirationOffset(context.getTemporalDistance().getExpirationOffset(pattern));
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, otn));
        for (AlphaNodeFieldConstraint constraint : alphaConstraints) {
            context.setObjectSource((ObjectSource)utils.attachNode(context, new AlphaNode(context.getNextId(), constraint, context.getObjectSource(), context)));
        }
        context.setObjectTypeNodeMemoryEnabled(objectMemory);
        context.setAlphaNodeMemoryAllowed(alphaMemory);
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List betaConstraints) {
        if (context.getRuleBase().getConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            Object patterns = null;
            Class thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
            for (Pattern previousPattern : context.getObjectType()) {
                Class previousClass = ((ClassObjectType)previousPattern.getObjectType()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                betaConstraints.add(new InstanceNotEqualsConstraint(previousPattern));
            }
            context.getObjectType().add(pattern);
        }
    }

    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return ((Pattern)rce).getSource() != null;
    }
}

