/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.drools.rule.DroolsClassLoader;

public class CompositeClassLoader
extends ClassLoader
implements DroolsClassLoader {
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
    private boolean hasParent = false;

    public CompositeClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
        if (parentClassLoader != null) {
            this.hasParent = true;
        }
    }

    public void addClassLoader(ClassLoader classLoader) {
        for (ClassLoader cl : this.classLoaders) {
            if (cl != classLoader) continue;
            return;
        }
        this.classLoaders.add(classLoader);
    }

    public void removeClassLoader(ClassLoader classLoader) {
        this.classLoaders.remove(classLoader);
    }

    public Class fastFindClass(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            Class<?> cls = ((DroolsClassLoader)((Object)classLoader)).fastFindClass(name);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.fastFindClass(name);
        if (this.hasParent && cls == null) {
            cls = this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.classLoaders) {
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        if (this.hasParent) {
            return this.getParent().getResourceAsStream(name);
        }
        return null;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class cls = this.fastFindClass(name);
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        return cls;
    }
}

