/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.DroolsObjectInput;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.ConditionalElement;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.DroolsClassLoader;
import org.drools.rule.EvalCondition;
import org.drools.rule.Function;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.Wireable;
import org.drools.util.StringUtils;

public class JavaDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private static final long serialVersionUID = 400L;
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JavaDialectRuntimeData.class.getProtectionDomain();
        }
    });
    private Map invokerLookups;
    private Map store;
    private DialectRuntimeRegistry registry;
    private transient PackageClassLoader classLoader;
    private transient CompositeClassLoader rootClassLoader;
    private boolean dirty = false;
    private List<String> wireList = Collections.emptyList();

    public JavaDialectRuntimeData() {
        this.invokerLookups = new HashMap();
        this.store = new HashMap();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeInt(this.store.size());
        for (Map.Entry entry : this.store.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
        stream.writeInt(this.invokerLookups.size());
        for (Map.Entry entry : this.invokerLookups.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i;
        DroolsObjectInput droolsStream = (DroolsObjectInput)stream;
        int length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.store.put(stream.readObject(), stream.readObject());
        }
        length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.invokerLookups.put(stream.readObject(), stream.readObject());
        }
        this.dirty = true;
    }

    public void onAdd(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        this.registry = registry;
        this.rootClassLoader = rootClassLoader;
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        this.rootClassLoader.addClassLoader(this.classLoader);
    }

    public void onRemove() {
        this.rootClassLoader.removeClassLoader(this.classLoader);
    }

    public void onBeforeExecute() {
        if (this.isDirty()) {
            this.reload();
        } else if (!this.wireList.isEmpty()) {
            try {
                for (String resourceName : this.wireList) {
                    this.wire(JavaDialectRuntimeData.convertResourceToClassName(resourceName));
                }
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Unable to wire up JavaDialect", e);
            }
        }
        this.wireList.clear();
    }

    public DialectRuntimeData clone(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        JavaDialectRuntimeData cloneOne = new JavaDialectRuntimeData();
        cloneOne.merge(registry, this);
        cloneOne.onAdd(registry, rootClassLoader);
        return cloneOne;
    }

    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.registry = registry;
        JavaDialectRuntimeData newJavaData = (JavaDialectRuntimeData)newData;
        for (String resourceName : newJavaData.list()) {
            this.write(resourceName, newJavaData.read(resourceName));
        }
        this.putAllInvokers(newJavaData.getInvokers());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected Map getStore() {
        if (this.store == null) {
            this.store = new HashMap();
        }
        return this.store;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void removeRule(Package pkg, Rule rule) {
        String consequenceName = rule.getConsequence().getClass().getName();
        if (this.remove(consequenceName)) {
            this.removeClasses(rule.getLhs());
            this.remove(consequenceName.substring(0, consequenceName.indexOf("ConsequenceInvoker")));
        }
    }

    public void removeFunction(Package pkg, Function function) {
        this.remove(pkg.getName() + "." + StringUtils.ucFirst(function.getName()));
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            for (Object object : group.getChildren()) {
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Pattern)) continue;
                this.removeClasses((Pattern)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Pattern pattern) {
        for (Object object : pattern.getConstraints()) {
            if (object instanceof PredicateConstraint) {
                this.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
                continue;
            }
            if (!(object instanceof ReturnValueConstraint)) continue;
            this.remove(((ReturnValueConstraint)object).getExpression().getClass().getName());
        }
    }

    public byte[] read(String resourceName) {
        byte[] bytes = null;
        if (!this.getStore().isEmpty()) {
            bytes = (byte[])this.getStore().get(resourceName);
        }
        return bytes;
    }

    public void write(String resourceName, byte[] clazzData) throws RuntimeDroolsException {
        if (this.getStore().put(resourceName, clazzData) != null) {
            this.dirty = true;
            if (!this.wireList.isEmpty()) {
                this.wireList.clear();
            }
        } else if (!this.dirty) {
            try {
                if (this.wireList == Collections.emptyList()) {
                    this.wireList = new ArrayList<String>();
                }
                this.wireList.add(resourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeDroolsException(e);
            }
        }
    }

    public void wire(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object invoker = this.getInvokers().get(className);
        this.wire(className, invoker);
    }

    public void wire(String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = this.rootClassLoader.loadClass(className);
        if (clazz != null) {
            if (invoker instanceof Wireable) {
                ((Wireable)invoker).wire(clazz.newInstance());
            }
        } else {
            throw new ClassNotFoundException(className);
        }
    }

    public boolean remove(String resourceName) throws RuntimeDroolsException {
        this.getInvokers().remove(resourceName);
        if (this.getStore().remove(JavaDialectRuntimeData.convertClassToResourcePath(resourceName)) != null) {
            this.wireList.remove(resourceName);
            this.dirty = true;
            return true;
        }
        return false;
    }

    public String[] list() {
        String[] names = new String[this.getStore().size()];
        int i = 0;
        for (Object object : this.getStore().keySet()) {
            names[i++] = (String)object;
        }
        return names;
    }

    public void reload() throws RuntimeDroolsException {
        this.rootClassLoader.removeClassLoader(this.classLoader);
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        this.rootClassLoader.addClassLoader(this.classLoader);
        try {
            Iterator i$ = this.getInvokers().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = i$.next();
                this.wire((String)entry.getKey(), entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeDroolsException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException(e);
        }
        this.dirty = false;
    }

    public void clear() {
        this.getStore().clear();
        this.getInvokers().clear();
        this.reload();
    }

    public String toString() {
        return this.getClass().getName() + this.getStore().toString();
    }

    public void putInvoker(String className, Object invoker) {
        this.getInvokers().put(className, invoker);
    }

    public void putAllInvokers(Map invokers) {
        this.getInvokers().putAll(invokers);
    }

    public Map getInvokers() {
        if (this.invokerLookups == null) {
            this.invokerLookups = new HashMap();
        }
        return this.invokerLookups;
    }

    public void removeInvoker(String className) {
        this.getInvokers().remove(className);
    }

    public static String convertResourceToClassName(String pResourceName) {
        return JavaDialectRuntimeData.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        String withoutExtension = pResourceName.substring(0, i);
        return withoutExtension;
    }

    public static class PackageClassLoader
    extends ClassLoader
    implements DroolsClassLoader {
        private JavaDialectRuntimeData store;
        CompositeClassLoader rootClassLoader;

        public PackageClassLoader(JavaDialectRuntimeData store, CompositeClassLoader rootClassLoader) {
            super(rootClassLoader);
            this.rootClassLoader = rootClassLoader;
            this.store = store;
        }

        public Class fastFindClass(String name) {
            byte[] clazzBytes;
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null && (clazzBytes = this.store.read(JavaDialectRuntimeData.convertClassToResourcePath(name))) != null) {
                cls = this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
            }
            return cls;
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            ClassLoader parent;
            Class<?> cls = this.fastFindClass(name);
            if (cls == null && (parent = this.getParent()) != null) {
                cls = Class.forName(name, true, parent);
            }
            if (resolve && cls != null) {
                this.resolveClass(cls);
            }
            return cls;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return this.fastFindClass(name);
        }

        public InputStream getResourceAsStream(String name) {
            byte[] clsBytes = this.store.read(name);
            if (clsBytes != null) {
                return new ByteArrayInputStream(clsBytes);
            }
            return null;
        }
    }
}

