/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.definition.KnowledgeDefinition;
import org.drools.factmodel.ClassDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.io.Resource;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.InternalReadAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclaration
implements KnowledgeDefinition,
Externalizable {
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_DURATION = "duration";
    public static final String ATTR_TIMESTAMP = "timestamp";
    private String typeName;
    private Role role;
    private Format format;
    private String timestampAttribute;
    private String durationAttribute;
    private InternalReadAccessor durationExtractor;
    private InternalReadAccessor timestampExtractor;
    private transient Class<?> typeClass;
    private FactTemplate typeTemplate;
    private ClassDefinition typeClassDef;
    private Resource resource;

    public TypeDeclaration() {
    }

    public TypeDeclaration(String typeName) {
        this.typeName = typeName;
        this.role = Role.FACT;
        this.format = Format.POJO;
        this.durationAttribute = null;
        this.timestampAttribute = null;
        this.typeTemplate = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = (String)in.readObject();
        this.role = (Role)((Object)in.readObject());
        this.format = (Format)((Object)in.readObject());
        this.durationAttribute = (String)in.readObject();
        this.timestampAttribute = (String)in.readObject();
        this.typeTemplate = (FactTemplate)in.readObject();
        this.typeClassDef = (ClassDefinition)in.readObject();
        this.durationExtractor = (InternalReadAccessor)in.readObject();
        this.timestampExtractor = (InternalReadAccessor)in.readObject();
        this.resource = (Resource)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.typeName);
        out.writeObject((Object)this.role);
        out.writeObject((Object)this.format);
        out.writeObject(this.durationAttribute);
        out.writeObject(this.timestampAttribute);
        out.writeObject(this.typeTemplate);
        out.writeObject(this.typeClassDef);
        out.writeObject(this.durationExtractor);
        out.writeObject(this.timestampExtractor);
        out.writeObject(this.resource);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    public void setTimestampAttribute(String timestampAttribute) {
        this.timestampAttribute = timestampAttribute;
    }

    public String getDurationAttribute() {
        return this.durationAttribute;
    }

    public void setDurationAttribute(String durationAttribute) {
        this.durationAttribute = durationAttribute;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
        if (this.typeClassDef != null) {
            this.typeClassDef.setDefinedClass(this.typeClass);
        }
    }

    public FactTemplate getTypeTemplate() {
        return this.typeTemplate;
    }

    public void setTypeTemplate(FactTemplate typeTemplate) {
        this.typeTemplate = typeTemplate;
    }

    public boolean matches(Object clazz) {
        boolean matches = false;
        matches = clazz instanceof FactTemplate ? this.typeTemplate.equals(clazz) : this.typeClass.isAssignableFrom((Class)clazz);
        return matches;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeDeclaration) {
            TypeDeclaration that = (TypeDeclaration)obj;
            return TypeDeclaration.isObjectEqual(this.typeName, that.typeName) && this.role == that.role && this.format == that.format && TypeDeclaration.isObjectEqual(this.timestampAttribute, that.timestampAttribute) && TypeDeclaration.isObjectEqual(this.durationAttribute, that.durationAttribute) && this.typeClass == that.typeClass && TypeDeclaration.isObjectEqual(this.typeTemplate, that.typeTemplate);
        }
        return false;
    }

    private static boolean isObjectEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public InternalReadAccessor getDurationExtractor() {
        return this.durationExtractor;
    }

    public void setDurationExtractor(InternalReadAccessor durationExtractor) {
        this.durationExtractor = durationExtractor;
    }

    public ClassDefinition getTypeClassDef() {
        return this.typeClassDef;
    }

    public void setTypeClassDef(ClassDefinition typeClassDef) {
        this.typeClassDef = typeClassDef;
    }

    public InternalReadAccessor getTimestampExtractor() {
        return this.timestampExtractor;
    }

    public void setTimestampExtractor(InternalReadAccessor timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public class TimestampAccessorSetter
    implements AcceptsReadAccessor,
    Serializable {
        private static final long serialVersionUID = 8656678871125722903L;

        public void setReadAccessor(InternalReadAccessor readAccessor) {
            TypeDeclaration.this.setTimestampExtractor(readAccessor);
        }
    }

    public class DurationAccessorSetter
    implements AcceptsReadAccessor,
    Serializable {
        private static final long serialVersionUID = 1429300982505284833L;

        public void setReadAccessor(InternalReadAccessor readAccessor) {
            TypeDeclaration.this.setDurationExtractor(readAccessor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        POJO,
        TEMPLATE;

        public static final String ID = "format";

        public static Format parseFormat(String format) {
            if ("pojo".equalsIgnoreCase(format)) {
                return POJO;
            }
            if (TypeDeclaration.ATTR_TEMPLATE.equalsIgnoreCase(format)) {
                return TEMPLATE;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        FACT,
        EVENT;

        public static final String ID = "role";

        public static Role parseRole(String role) {
            if ("event".equalsIgnoreCase(role)) {
                return EVENT;
            }
            if ("fact".equalsIgnoreCase(role)) {
                return FACT;
            }
            return null;
        }
    }
}

