/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.RuntimeDroolsException;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassVisitor;
import org.drools.asm.FieldVisitor;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFieldInspector {
    private final Map<String, Integer> fieldNames = new HashMap<String, Integer>();
    private final Map<String, Class<?>> fieldTypes = new HashMap();
    private final Map<String, Method> getterMethods = new HashMap<String, Method>();
    private final Map<String, Method> setterMethods = new HashMap<String, Method>();
    private final Set<String> nonGetters = new HashSet<String>();

    public ClassFieldInspector(Class<?> clazz) throws IOException {
        this(clazz, true);
    }

    public ClassFieldInspector(Class<?> clazz, boolean includeFinalMethods) throws IOException {
        String name = this.getResourcePath(clazz);
        InputStream stream = clazz.getResourceAsStream(name);
        if (stream != null) {
            this.processClassWithByteCode(clazz, stream, includeFinalMethods);
        } else {
            this.processClassWithoutByteCode(clazz, includeFinalMethods);
        }
    }

    private void processClassWithByteCode(Class<?> clazz, InputStream stream, boolean includeFinalMethods) throws IOException {
        ClassReader reader = new ClassReader(stream);
        ClassFieldVisitor visitor = new ClassFieldVisitor(clazz, includeFinalMethods, this);
        reader.accept(visitor, false);
        if (clazz.getSuperclass() != null) {
            String name = this.getResourcePath(clazz.getSuperclass());
            InputStream parentStream = clazz.getResourceAsStream(name);
            if (parentStream != null) {
                this.processClassWithByteCode(clazz.getSuperclass(), parentStream, includeFinalMethods);
            } else {
                this.processClassWithoutByteCode(clazz.getSuperclass(), includeFinalMethods);
            }
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String name = this.getResourcePath(interfaces[i]);
                InputStream parentStream = clazz.getResourceAsStream(name);
                if (parentStream != null) {
                    this.processClassWithByteCode(interfaces[i], parentStream, includeFinalMethods);
                    continue;
                }
                this.processClassWithoutByteCode(interfaces[i], includeFinalMethods);
            }
        }
    }

    private void processClassWithoutByteCode(Class<?> clazz, boolean includeFinalMethods) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int fieldIndex;
            int mask;
            int n = mask = includeFinalMethods ? 1 : 17;
            if ((methods[i].getModifiers() & mask) == 1 && methods[i].getParameterTypes().length == 0 && !methods[i].getName().equals("<init>") && !methods[i].getName().equals("<clinit>") && methods[i].getReturnType() != Void.TYPE) {
                fieldIndex = this.fieldNames.size();
                this.addToMapping(methods[i], fieldIndex);
                continue;
            }
            if ((methods[i].getModifiers() & mask) != 1 || methods[i].getParameterTypes().length != 1 || !methods[i].getName().startsWith("set")) continue;
            fieldIndex = this.fieldNames.size();
            this.addToMapping(methods[i], fieldIndex);
        }
    }

    private String getResourcePath(Class<?> clazz) {
        return "/" + clazz.getCanonicalName() + ".class";
    }

    public Map<String, Integer> getFieldNames() {
        return this.fieldNames;
    }

    public Map<String, Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    public Map<String, Method> getGetterMethods() {
        return this.getterMethods;
    }

    public Map<String, Method> getSetterMethods() {
        return this.setterMethods;
    }

    private void addToMapping(Method method, int index) {
        String name;
        int offset = (name = method.getName()).startsWith("is") ? 2 : (name.startsWith("get") || name.startsWith("set") ? 3 : 0);
        String fieldName = this.calcFieldName(name, offset);
        if (this.fieldNames.containsKey(fieldName)) {
            if (offset != 0 && this.nonGetters.contains(fieldName)) {
                Integer oldIndex = this.removeOldField(fieldName);
                this.storeField(method, oldIndex, fieldName);
                this.storeGetterSetter(method, fieldName);
                this.nonGetters.remove(fieldName);
            } else if (offset != 0) {
                this.storeGetterSetter(method, fieldName);
            }
        } else {
            this.storeField(method, new Integer(index), fieldName);
            this.storeGetterSetter(method, fieldName);
            if (offset == 0) {
                this.nonGetters.add(fieldName);
            }
        }
    }

    private Integer removeOldField(String fieldName) {
        Integer index = this.fieldNames.remove(fieldName);
        this.fieldTypes.remove(fieldName);
        this.getterMethods.remove(fieldName);
        return index;
    }

    private void storeField(Method method, Integer index, String fieldName) {
        this.fieldNames.put(fieldName, index);
    }

    private void storeGetterSetter(Method method, String fieldName) {
        if (method.getName().startsWith("set")) {
            this.setterMethods.put(fieldName, method);
            if (!this.fieldTypes.containsKey(fieldName)) {
                this.fieldTypes.put(fieldName, method.getParameterTypes()[0]);
            }
        } else {
            this.getterMethods.put(fieldName, method);
            this.fieldTypes.put(fieldName, method.getReturnType());
        }
    }

    private String calcFieldName(String name, int offset) {
        name = name.substring(offset);
        return Introspector.decapitalize(name);
    }

    static class ClassFieldAnnotationVisitor
    implements AnnotationVisitor {
        ClassFieldAnnotationVisitor() {
        }

        public void visit(String arg0, Object arg1) {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String arg0) {
            return new ClassFieldAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassFieldVisitor
    implements ClassVisitor {
        private Class<?> clazz;
        private ClassFieldInspector inspector;
        private boolean includeFinalMethods;

        ClassFieldVisitor(Class<?> cls, boolean includeFinalMethods, ClassFieldInspector inspector) {
            this.clazz = cls;
            this.includeFinalMethods = includeFinalMethods;
            this.inspector = inspector;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            int mask;
            int n = mask = this.includeFinalMethods ? 1 : 17;
            if ((access & mask) == 1) {
                try {
                    if (desc.startsWith("()") && !name.equals("<init>") && !name.equals("<clinit>")) {
                        Method method = this.clazz.getMethod(name, null);
                        if (method.getReturnType() != Void.TYPE) {
                            int fieldIndex = this.inspector.fieldNames.size();
                            this.inspector.addToMapping(method, fieldIndex);
                        }
                    } else if (name.startsWith("set")) {
                        Method[] methods = this.clazz.getMethods();
                        for (int i = 0; i < methods.length; ++i) {
                            if (!desc.equals(Type.getMethodDescriptor(methods[i]))) continue;
                            int fieldIndex = this.inspector.fieldNames.size();
                            this.inspector.addToMapping(methods[i], fieldIndex);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeDroolsException("Error getting field access method: " + name + ": " + e.getMessage(), e);
                }
            }
            return null;
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String[] arg4, String arg5) {
        }

        @Override
        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        public void visitField(int access, String arg1, String arg2, Object arg3, Attribute arg4) {
        }

        @Override
        public void visitAttribute(Attribute arg0) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        }

        @Override
        public void visitSource(String arg0, String arg1) {
        }

        @Override
        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        @Override
        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }
    }
}

