/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.impl.KnowledgeAgentConfigurationImpl;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.AbstractRuleBase;
import org.drools.definition.KnowledgeDefinition;
import org.drools.definition.process.Process;
import org.drools.event.io.ResourceChangeListener;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.io.InternalResource;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeMonitor;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.ResourceChangeNotifierImpl;
import org.drools.rule.Function;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.util.DroolsStreamUtils;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.SemanticModules;
import org.drools.xml.XmlChangeSetReader;

public class KnowledgeAgentImpl
implements KnowledgeAgent,
ResourceChangeListener {
    private String name;
    private Map<Resource, ResourceMapping> resources;
    private Set<Resource> resourceDirectories;
    private KnowledgeBase kbase;
    private ResourceChangeNotifierImpl notifier;
    private boolean newInstance;
    private SystemEventListener listener;
    private boolean scanDirectories;
    private LinkedBlockingQueue<ChangeSet> queue;
    private Thread thread;
    private ChangeSetNotificationDetector changeSetNotificationDetector;
    private SemanticModules semanticModules;

    public KnowledgeAgentImpl(String name, KnowledgeBase kbase, KnowledgeAgentConfiguration configuration) {
        this.kbase = kbase;
        this.resources = new HashMap<Resource, ResourceMapping>();
        this.resourceDirectories = new HashSet<Resource>();
        this.listener = SystemEventListenerFactory.getSystemEventListener();
        this.newInstance = true;
        this.queue = new LinkedBlockingQueue();
        boolean scanResources = false;
        boolean monitor = false;
        if (configuration != null) {
            this.notifier = (ResourceChangeNotifierImpl)ResourceFactory.getResourceChangeNotifierService();
            if (((KnowledgeAgentConfigurationImpl)configuration).isMonitorChangeSetEvents()) {
                monitor = true;
            }
            if (((KnowledgeAgentConfigurationImpl)configuration).isScanDirectories()) {
                this.scanDirectories = true;
            }
            if (scanResources = ((KnowledgeAgentConfigurationImpl)configuration).isScanResources()) {
                this.notifier.addResourceChangeMonitor((ResourceChangeMonitor)ResourceFactory.getResourceChangeScannerService());
                monitor = true;
            }
        }
        this.monitorResourceChangeEvents(monitor);
        this.buildResourceMapping(kbase);
        this.listener.info("KnowledgAgent created, with configuration:\nmonitorChangeSetEvents=" + monitor + " scanResources=" + scanResources + " scanDirectories=" + this.scanDirectories);
    }

    public void setSystemEventListener(SystemEventListener listener) {
        this.listener = listener;
    }

    public void applyChangeSet(Resource resource) {
        this.applyChangeSet(this.getChangeSet(resource));
    }

    public void applyChangeSet(ChangeSet changeSet) {
        this.listener.info("KnowledgAgent applying ChangeSet");
        ChangeSetState changeSetState = new ChangeSetState();
        changeSetState.scanDirectories = this.scanDirectories;
        this.processChangeSet(changeSet, changeSetState);
        this.rebuildResources(changeSetState);
        this.buildResourceMapping(this.kbase);
    }

    public void processChangeSet(Resource resource, ChangeSetState changeSetState) {
        this.processChangeSet(this.getChangeSet(resource), changeSetState);
    }

    public void processChangeSet(ChangeSet changeSet, ChangeSetState changeSetState) {
        for (Resource resource : changeSet.getResourcesAdded()) {
            ResourceMapping mapping;
            if (((InternalResource)resource).isDirectory()) {
                this.resourceDirectories.add(resource);
                this.listener.debug("KnowledgeAgent subscribing to directory=" + resource);
                this.notifier.subscribeResourceChangeListener(this, resource);
                for (Resource child : ((InternalResource)resource).listResources()) {
                    if (((InternalResource)child).isDirectory()) continue;
                    ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                    ResourceMapping mapping2 = this.resources.get(child);
                    if (mapping2 != null) continue;
                    this.listener.debug("KnowledgeAgent subscribing to directory content resource=" + child);
                    this.notifier.subscribeResourceChangeListener(this, child);
                    mapping2 = new ResourceMapping(child);
                    this.resources.put(child, mapping2);
                }
                continue;
            }
            if (((InternalResource)resource).getResourceType() == ResourceType.PKG) {
                changeSetState.pkgs.add(resource);
            } else if (((InternalResource)resource).getResourceType() == ResourceType.ChangeSet) continue;
            if ((mapping = this.resources.get(resource)) != null) continue;
            this.listener.debug("KnowledgeAgent subscribing to resource=" + resource);
            this.notifier.subscribeResourceChangeListener(this, resource);
            mapping = new ResourceMapping(resource);
            this.resources.put(resource, mapping);
        }
        for (Resource resource : changeSet.getResourcesRemoved()) {
            if (((InternalResource)resource).getResourceType() == ResourceType.ChangeSet) {
                this.processChangeSet(resource, changeSetState);
                continue;
            }
            if (changeSetState.scanDirectories && ((InternalResource)resource).isDirectory()) {
                this.listener.debug("KnowledgeAgent unsubscribing from directory resource=" + resource);
                this.resourceDirectories.remove(resource);
                this.notifier.unsubscribeResourceChangeListener(this, resource);
                continue;
            }
            this.listener.debug("KnowledgeAgent unsubscribing from resource=" + resource);
            this.resources.remove(resource);
            this.notifier.unsubscribeResourceChangeListener(this, resource);
        }
        for (Resource resource : this.resources.keySet()) {
            this.listener.debug("KnowledgeAgent ChangeSet requires KnowledgeBuilder");
            if (((InternalResource)resource).getResourceType() == ResourceType.ChangeSet || ((InternalResource)resource).getResourceType() == ResourceType.PKG) continue;
            changeSetState.needsKnowledgeBuilder = true;
            break;
        }
    }

    public ChangeSet getChangeSet(Resource resource) {
        if (this.semanticModules == null) {
            this.semanticModules = new SemanticModules();
            this.semanticModules.addSemanticModule(new ChangeSetSemanticModule());
        }
        XmlChangeSetReader reader = new XmlChangeSetReader(this.semanticModules);
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader());
        } else {
            reader.setClassLoader(((AbstractRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration().getClassLoader());
        }
        ChangeSet changeSet = null;
        try {
            changeSet = reader.read(resource.getReader());
        }
        catch (Exception e) {
            this.listener.exception((Exception)new RuntimeException("Unable to parse ChangeSet", e));
        }
        if (changeSet == null) {
            this.listener.exception((Exception)new RuntimeException("Unable to parse ChangeSet"));
        }
        return changeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildResourceMapping(KnowledgeBase kbase) {
        RuleBase rbase = ((KnowledgeBaseImpl)kbase).ruleBase;
        this.listener.debug("KnowledgeAgent building resource map");
        Map<Resource, ResourceMapping> map = this.resources;
        synchronized (map) {
            for (Package pkg : rbase.getPackages()) {
                ResourceMapping mapping;
                for (Rule rule : pkg.getRules()) {
                    Resource resource = rule.getResource();
                    if (resource == null || !((InternalResource)resource).hasURL()) continue;
                    ResourceMapping mapping2 = this.resources.get(resource);
                    if (mapping2 == null) {
                        this.notifier.subscribeResourceChangeListener(this, resource);
                        mapping2 = new ResourceMapping(resource);
                        this.resources.put(resource, mapping2);
                    }
                    this.listener.debug("KnowledgeAgent mapping resource=" + resource + " to rule=" + rule);
                    mapping2.getKnowledgeDefinitions().add((KnowledgeDefinition)rule);
                }
                for (Process process : pkg.getRuleFlows().values()) {
                    Resource resource = ((org.drools.process.core.Process)process).getResource();
                    if (resource == null || !((InternalResource)resource).hasURL()) continue;
                    mapping = this.resources.get(resource);
                    if (mapping == null) {
                        this.notifier.subscribeResourceChangeListener(this, resource);
                        mapping = new ResourceMapping(resource);
                        this.resources.put(resource, mapping);
                    }
                    this.listener.debug("KnowledgeAgent mapping resource=" + resource + " to process=" + process);
                    mapping.getKnowledgeDefinitions().add((KnowledgeDefinition)process);
                }
                for (TypeDeclaration typeDeclaration : pkg.getTypeDeclarations().values()) {
                    Resource resource = typeDeclaration.getResource();
                    if (resource == null || !((InternalResource)resource).hasURL()) continue;
                    mapping = this.resources.get(resource);
                    if (mapping == null) {
                        this.notifier.subscribeResourceChangeListener(this, resource);
                        mapping = new ResourceMapping(resource);
                        this.resources.put(resource, mapping);
                    }
                    this.listener.debug("KnowledgeAgent mapping resource=" + resource + " to TypeDeclaration=" + typeDeclaration);
                    mapping.getKnowledgeDefinitions().add(typeDeclaration);
                }
                for (Function function : pkg.getFunctions().values()) {
                    Resource resource = function.getResource();
                    if (resource == null || !((InternalResource)resource).hasURL()) continue;
                    mapping = this.resources.get(resource);
                    if (mapping == null) {
                        this.notifier.subscribeResourceChangeListener(this, resource);
                        mapping = new ResourceMapping(resource);
                        this.resources.put(resource, mapping);
                    }
                    this.listener.debug("KnowledgeAgent mapping resource=" + resource + " to function=" + function);
                    mapping.getKnowledgeDefinitions().add(function);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBase getKnowledgeBase() {
        Map<Resource, ResourceMapping> map = this.resources;
        synchronized (map) {
            return this.kbase;
        }
    }

    public void resourcesChanged(ChangeSet changeSet) {
        try {
            this.listener.debug("KnowledgeAgent received ChangeSet changed notification");
            this.queue.put(changeSet);
        }
        catch (InterruptedException e) {
            this.listener.exception((Exception)new RuntimeException("KnowledgeAgent error while adding ChangeSet notification to queue", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildResources(ChangeSetState changeSetState) {
        this.listener.debug("KnowledgeAgent rebuilding KnowledgeBase using ChangeSet");
        Map<Resource, ResourceMapping> map = this.resources;
        synchronized (map) {
            for (Resource child : changeSetState.pkgs) {
                try {
                    InputStream is = child.getInputStream();
                    Package pkg = (Package)DroolsStreamUtils.streamIn(is);
                    this.listener.debug("KnowledgeAgent adding KnowledgeDefinitionsPackage " + pkg.getName());
                    ((KnowledgeBaseImpl)this.kbase).ruleBase.addPackage(pkg);
                    is.close();
                }
                catch (Exception e) {
                    this.listener.exception((Exception)new RuntimeException("KnowledgeAgent exception while trying to serialize and KnowledgeDefinitionsPackage  "));
                }
            }
            if (changeSetState.needsKnowledgeBuilder) {
                Resource[] resourcesClone = this.resources.keySet().toArray(new Resource[this.resources.size()]);
                this.resources.clear();
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                for (Resource resource : resourcesClone) {
                    this.listener.debug("KnowledgeAgent building resource=" + resource);
                    if (((InternalResource)resource).getResourceType() == ResourceType.PKG) continue;
                    kbuilder.add(resource, ((InternalResource)resource).getResourceType());
                }
                if (kbuilder.hasErrors()) {
                    this.listener.warning("KnowledgeAgent has KnowledgeBuilder errors ", (Object)kbuilder.getErrors());
                }
                this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
                this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
                this.listener.info("KnowledgeAgent new KnowledgeBase now built and in use");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void monitorResourceChangeEvents(boolean monitor) {
        if (this.changeSetNotificationDetector == null) {
            if (monitor) {
                this.changeSetNotificationDetector = new ChangeSetNotificationDetector(this, this.queue, this.listener);
            } else if (this.changeSetNotificationDetector == null) {
                return;
            }
        }
        if (!this.changeSetNotificationDetector.monitor && monitor) {
            this.thread = new Thread(this.changeSetNotificationDetector);
            this.changeSetNotificationDetector.monitor = true;
            this.thread.start();
        } else {
            this.changeSetNotificationDetector.monitor = false;
            this.thread.interrupt();
        }
    }

    protected void finalize() throws Throwable {
        if (this.changeSetNotificationDetector != null) {
            this.changeSetNotificationDetector.monitor = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceMapping {
        private Resource resource;
        private Set<KnowledgeDefinition> knowledgeDefinitions = new HashSet<KnowledgeDefinition>();

        public ResourceMapping(Resource resource) {
        }

        public Resource getResource() {
            return this.resource;
        }

        public Set<KnowledgeDefinition> getKnowledgeDefinitions() {
            return this.knowledgeDefinitions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeSetNotificationDetector
    implements Runnable {
        private LinkedBlockingQueue<ChangeSet> queue;
        public volatile boolean monitor;
        private KnowledgeAgentImpl kagent;
        private SystemEventListener listener;

        public ChangeSetNotificationDetector(KnowledgeAgentImpl kagent, LinkedBlockingQueue<ChangeSet> queue, SystemEventListener listener) {
            this.queue = queue;
            this.kagent = kagent;
            this.listener = listener;
        }

        @Override
        public void run() {
            if (this.monitor) {
                this.listener.info("KnowledegAgent has started listening for ChangeSet notifications");
            }
            while (this.monitor) {
                try {
                    this.kagent.applyChangeSet(this.queue.take());
                }
                catch (InterruptedException e) {
                    this.listener.exception((Exception)new RuntimeException("KnowledgeAgent ChangeSet notification thread has been interrupted", e));
                }
                Thread.yield();
            }
            this.listener.info("KnowledegAgent has stopped listening for ChangeSet notifications");
        }
    }

    public static class ChangeSetState {
        List<Resource> pkgs = new ArrayList<Resource>();
        boolean scanDirectories;
        boolean needsKnowledgeBuilder;
    }
}

